/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blocks.crop.DoubleCropBlock;
import net.dries007.tfc.common.blocks.crop.ICropBlock;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CropBlockEntity
extends TFCBlockEntity
implements ICalendarTickable {
    private float growth;
    private float yield;
    private float expiry;
    private long lastUpdateTick = Integer.MIN_VALUE;
    private long lastGrowthTick = Calendars.SERVER.getTicks();

    public static void serverTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        crop.checkForCalendarUpdate();
    }

    public static void serverTickBottomPartOnly(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        if (state.m_61143_(DoubleCropBlock.PART) == DoubleCropBlock.Part.BOTTOM) {
            crop.checkForCalendarUpdate();
        }
    }

    public CropBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.CROP.get(), pos, state);
    }

    public CropBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        Block block = state.m_60734_();
        if (block instanceof ICropBlock) {
            ICropBlock crop = (ICropBlock)block;
            crop.growthTick(this.f_58857_, this.f_58858_, state, this);
        }
    }

    public float getGrowth() {
        return this.growth;
    }

    public float getYield() {
        return this.yield;
    }

    public float getExpiry() {
        return this.expiry;
    }

    public void setGrowth(float growth) {
        this.growth = growth;
        this.markForSync();
    }

    public void setYield(float yield) {
        this.yield = yield;
        this.markForSync();
    }

    public void setExpiry(float expiry) {
        this.expiry = expiry;
        this.markForSync();
    }

    public long getLastGrowthTick() {
        return this.lastGrowthTick;
    }

    public void setLastGrowthTick(long lastGrowthTick) {
        this.lastGrowthTick = lastGrowthTick;
        this.markForSync();
    }

    @Override
    @Deprecated
    public long getLastUpdateTick() {
        return this.lastUpdateTick;
    }

    @Override
    @Deprecated
    public void setLastUpdateTick(long tick) {
        this.lastUpdateTick = tick;
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.growth = nbt.m_128457_("growth");
        this.yield = nbt.m_128457_("yield");
        this.expiry = nbt.m_128457_("expiry");
        this.lastUpdateTick = nbt.m_128454_("tick");
        this.lastGrowthTick = nbt.m_128454_("lastGrowthTick");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128350_("growth", this.growth);
        nbt.m_128350_("yield", this.yield);
        nbt.m_128350_("expiry", this.expiry);
        nbt.m_128356_("tick", this.lastUpdateTick);
        nbt.m_128356_("lastGrowthTick", this.lastGrowthTick);
        super.m_183515_(nbt);
    }
}

