/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BurningLogPileBlockEntity
extends TickCounterBlockEntity {
    private int logs;

    public static void serverTick(Level level, BlockPos pos, BlockState state, BurningLogPileBlockEntity entity) {
        if (entity.lastUpdateTick > 0L && entity.getTicksSinceUpdate() > (long)((Integer)TFCConfig.SERVER.charcoalTicks.get()).intValue()) {
            entity.createCharcoal();
        }
    }

    public BurningLogPileBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.BURNING_LOG_PILE.get(), pos, state);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.logs = nbt.m_128451_("logs");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("logs", this.logs);
        super.m_183515_(nbt);
    }

    public void light(int logs) {
        this.logs = logs;
        this.resetCounter();
        this.markForSync();
    }

    public int getLogs() {
        return this.logs;
    }

    private void createCharcoal() {
        int currentAmount;
        int amount;
        if (this.f_58857_ == null) {
            return;
        }
        if (BurningLogPileBlockEntity.isPileBlock(this.f_58857_.m_8055_(this.f_58858_.m_7494_()))) {
            return;
        }
        int charcoal = BurningLogPileBlockEntity.getCharcoalAmount(this.f_58857_, this.logs);
        int height = 1;
        BlockPos.MutableBlockPos currentPos = this.f_58858_.m_122032_().m_122173_(Direction.DOWN);
        BlockState currentState = this.f_58857_.m_8055_((BlockPos)currentPos);
        while (currentState.m_60713_((Block)TFCBlocks.BURNING_LOG_PILE.get())) {
            ++height;
            int logs = this.f_58857_.m_141902_((BlockPos)currentPos, (BlockEntityType)TFCBlockEntities.BURNING_LOG_PILE.get()).map(BurningLogPileBlockEntity::getLogs).orElse(0);
            charcoal += BurningLogPileBlockEntity.getCharcoalAmount(this.f_58857_, logs);
            currentPos.m_122173_(Direction.DOWN);
            currentState = this.f_58857_.m_8055_((BlockPos)currentPos);
        }
        currentPos.m_122190_((Vec3i)this.f_58858_).m_122184_(0, 1 - height, 0);
        BlockState belowState = this.f_58857_.m_8055_(currentPos.m_7495_());
        if (belowState.m_60713_((Block)TFCBlocks.CHARCOAL_PILE.get()) && (amount = Mth.m_14045_((int)charcoal, (int)0, (int)(8 - (currentAmount = ((Integer)belowState.m_61143_((Property)CharcoalPileBlock.LAYERS)).intValue())))) > 0) {
            charcoal -= amount;
            this.f_58857_.m_46597_(currentPos.m_7495_(), (BlockState)belowState.m_61124_((Property)CharcoalPileBlock.LAYERS, (Comparable)Integer.valueOf(currentAmount + amount)));
        }
        for (int i = 0; i < height; ++i) {
            if (charcoal > 0) {
                amount = Mth.m_14045_((int)charcoal, (int)0, (int)8);
                charcoal -= amount;
                this.f_58857_.m_46597_((BlockPos)currentPos, (BlockState)((Block)TFCBlocks.CHARCOAL_PILE.get()).m_49966_().m_61124_((Property)CharcoalPileBlock.LAYERS, (Comparable)Integer.valueOf(amount)));
            } else {
                this.f_58857_.m_46597_((BlockPos)currentPos, Blocks.f_50016_.m_49966_());
            }
            currentPos.m_122173_(Direction.UP);
        }
    }

    private static int getCharcoalAmount(Level level, int logs) {
        return (int)Mth.m_14008_((double)((double)logs * (0.25 + 0.25 * (double)level.m_5822_().nextFloat())), (double)0.0, (double)8.0);
    }

    private static boolean isPileBlock(BlockState state) {
        return Helpers.isBlock(state, (Block)TFCBlocks.CHARCOAL_PILE.get()) || Helpers.isBlock(state, (Block)TFCBlocks.BURNING_LOG_PILE.get());
    }
}

