/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import net.dries007.tfc.client.model.animation.AnimationChannel;
import net.dries007.tfc.client.model.animation.AnimationDefinition;
import net.dries007.tfc.client.model.animation.VanillaAnimations;
import net.dries007.tfc.client.model.entity.HierarchicalAnimatedModel;
import net.dries007.tfc.common.entities.predator.Predator;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class BearModel
extends HierarchicalAnimatedModel<Predator> {
    public static final AnimationDefinition WALK = AnimationDefinition.Builder.withLength(1.0f).looping().addAnimation("right_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.25f, -30.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.75f, 25.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(1.0f))).addAnimation("left_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.25f, 20.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(0.5f), VanillaAnimations.rotation(0.75f, -30.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(1.0f))).addAnimation("left_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.375f, -30.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.75f, 25.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(1.0f))).addAnimation("right_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.2917f, 20.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(0.5833f), VanillaAnimations.rotation(0.7917f, -30.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(1.0f))).build();
    public static final AnimationDefinition RUN = AnimationDefinition.Builder.withLength(0.7f).looping().addAnimation("right_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, 17.5f, 0.0f, 0.0f), VanillaAnimations.rotation(0.32f, -20.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.7f, 17.5f, 0.0f, 0.0f))).addAnimation("left_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.04f, 17.5f, 0.0f, 0.0f), VanillaAnimations.rotation(0.36f, -20.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.7f, 17.5f, 0.0f, 0.0f))).addAnimation("left_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.04f, -15.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.36f, 20.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.7f, -15.0f, 0.0f, 0.0f))).addAnimation("right_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, -15.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.32f, 20.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.7f, -15.0f, 0.0f, 0.0f))).addAnimation("body", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.32f, -5.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(0.7f))).addAnimation("head", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, -10.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.32f, 10.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.7f, -10.0f, 0.0f, 0.0f))).build();
    public static final AnimationDefinition SLEEP = AnimationDefinition.Builder.withLength(2.5f).looping().addAnimation("right_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, -100.0f, 0.0f, 0.0f), VanillaAnimations.rotation(2.5f, -100.0f, 0.0f, 0.0f))).addAnimation("left_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, -100.0f, 0.0f, 0.0f), VanillaAnimations.rotation(2.5f, -100.0f, 0.0f, 0.0f))).addAnimation("left_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, -100.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.9167f, -102.5f, 0.0f, 0.0f), VanillaAnimations.rotation(2.5f, -100.0f, 0.0f, 0.0f))).addAnimation("right_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, -100.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.9167f, -102.5f, 0.0f, 0.0f), VanillaAnimations.rotation(2.5f, -100.0f, 0.0f, 0.0f))).addAnimation("body", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, 10.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.9167f, 12.5f, 0.0f, 0.0f), VanillaAnimations.rotation(2.5f, 10.0f, 0.0f, 0.0f))).addAnimation("head", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, 34.70381f, 17.89439f, 28.3117f), VanillaAnimations.rotation(2.5f, 34.70381f, 17.89439f, 28.3117f))).addAnimation("neck", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, -355.004f, 18.9931f, -348.65665f), VanillaAnimations.rotation(2.5f, -355.004f, 18.9931f, -348.65665f))).build();
    public static final AnimationDefinition ATTACK = AnimationDefinition.Builder.withLength(0.65f).addAnimation("right_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.25f, -77.58077f, 50.04097f, -37.61043f), VanillaAnimations.rotation(0.3333f, -5.35402f, 39.14934f, -15.61544f), VanillaAnimations.rotation(0.4167f, 24.98346f, 39.58329f, -35.66042f), VanillaAnimations.noRotation(0.65f))).addAnimation("left_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.375f, -88.26784f, -47.13536f, 48.49352f), VanillaAnimations.rotation(0.4583f, -12.45074f, -49.52961f, 14.56411f), VanillaAnimations.rotation(0.5417f, 35.22909f, -29.67177f, 26.85242f), VanillaAnimations.noRotation(0.65f))).addAnimation("left_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.4167f, 40.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(0.65f))).addAnimation("right_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.4167f, 40.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(0.65f))).addAnimation("body", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.4167f, -37.5f, 0.0f, 0.0f), VanillaAnimations.noRotation(0.65f))).addAnimation("head", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.noRotation(0.0f), VanillaAnimations.rotation(0.4167f, 10.0f, 0.0f, 0.0f), VanillaAnimations.noRotation(0.65f))).addAnimation("neck", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, 10.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.4167f, 50.0f, 0.0f, 0.0f), VanillaAnimations.rotation(0.65f, 10.0f, 0.0f, 0.0f))).build();
    public static final AnimationDefinition SWIM = AnimationDefinition.Builder.withLength(1.0f).looping().addAnimation("right_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, 0.0f, 0.0f, 82.5f), VanillaAnimations.rotation(0.25f, -44.58543f, -6.80829f, 75.18027f), VanillaAnimations.rotation(0.5833f, 35.22818f, 3.59874f, 79.76447f), VanillaAnimations.rotation(0.7917f, 15.47767f, 10.66721f, 94.49245f), VanillaAnimations.rotation(1.0f, 0.0f, 0.0f, 82.5f))).addAnimation("left_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, 0.0f, 0.0f, -82.5f), VanillaAnimations.rotation(0.2917f, -44.56145f, 7.05302f, -75.39292f), VanillaAnimations.rotation(0.625f, 35.26063f, -4.25476f, -84.31852f), VanillaAnimations.rotation(0.8333f, 17.64114f, -6.03989f, -95.48139f), VanillaAnimations.rotation(1.0f, 0.0f, 0.0f, -82.5f))).addAnimation("left_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, 32.5f, 0.0f, -82.5f), VanillaAnimations.rotation(0.5f, 42.5f, 0.0f, -82.5f), VanillaAnimations.rotation(1.0f, 32.5f, 0.0f, -82.5f))).addAnimation("right_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, VanillaAnimations.rotation(0.0f, 32.5f, 0.0f, 82.5f), VanillaAnimations.rotation(0.5f, 42.5f, 0.0f, 82.5f), VanillaAnimations.rotation(1.0f, 32.5f, 0.0f, 82.5f))).build();
    private final ModelPart body;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart right_front_leg;
    private final ModelPart left_front_leg;
    private final ModelPart right_hind_leg;
    private final ModelPart left_hind_leg;
    private final ModelPart right_ear;
    private final ModelPart left_ear;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(-7.5f, -9.0f, -18.0f, 15.0f, 11.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-7.5f, -10.0f, -8.0f, 15.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)8.0f));
        PartDefinition right_front_leg = body.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(50, 54).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(64, 27).m_171488_(-2.5f, 8.0f, -4.0f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-1.0f, (float)-15.0f));
        PartDefinition left_front_leg = body.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(34, 54).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(15, 64).m_171488_(-2.5f, 8.0f, -4.0f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-1.0f, (float)-15.0f));
        PartDefinition left_hind_leg = body.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(66, 54).m_171488_(-2.0f, 2.0f, 0.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(64, 13).m_171488_(-2.5f, 7.0f, -2.0f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_thigh_r1 = left_hind_leg.m_171599_("left_thigh_r1", CubeListBuilder.m_171558_().m_171514_(49, 19).m_171488_(-2.5f, -2.4645f, -0.2929f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-2.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right_hind_leg = body.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(62, 65).m_171488_(-2.0f, 2.0f, 0.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 62).m_171488_(-2.5f, 7.0f, -2.0f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_thigh_r2 = right_hind_leg.m_171599_("left_thigh_r2", CubeListBuilder.m_171558_().m_171514_(54, 0).m_171488_(-2.5f, -3.1716f, -1.0f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-1.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-5.0f, (float)-15.0f));
        PartDefinition neck_r1 = neck.m_171599_("neck_r1", CubeListBuilder.m_171558_().m_171514_(41, 36).m_171488_(-6.0f, -6.0761f, -6.6173f, 12.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)1.0f, (float)-1.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171488_(-5.0f, -5.0f, -8.0f, 8.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(25, 45).m_171488_(-3.0f, -1.0f, -11.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition right_ear = head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)-5.0f, (float)-7.0f));
        PartDefinition left_ear = head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-5.0f, (float)-7.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public BearModel(ModelPart root) {
        super(root);
        this.body = root.m_171324_("body");
        this.neck = this.body.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.right_ear = this.head.m_171324_("right_ear");
        this.left_ear = this.head.m_171324_("left_ear");
        this.right_front_leg = this.body.m_171324_("right_front_leg");
        this.left_front_leg = this.body.m_171324_("left_front_leg");
        this.left_hind_leg = this.body.m_171324_("left_hind_leg");
        this.right_hind_leg = this.body.m_171324_("right_hind_leg");
    }

    public void setupAnim(Predator predator, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        super.m_6973_(predator, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
        if (predator.sleepingAnimation.isStarted()) {
            this.setupSleeping();
            this.animate(predator.sleepingAnimation, SLEEP, ageInTicks);
        } else {
            float speed = this.getAdjustedLandSpeed(predator);
            if (predator.swimmingAnimation.isStarted()) {
                this.setupSwimming();
                this.animate(predator.swimmingAnimation, SWIM, ageInTicks, speed);
            } else {
                this.animate(predator.walkingAnimation, WALK, ageInTicks, speed);
                this.animate(predator.runningAnimation, RUN, ageInTicks, speed);
                this.animate(predator.attackingAnimation, ATTACK, ageInTicks);
            }
            this.head.f_104203_ = headPitch * (float)Math.PI / 180.0f;
            this.head.f_104204_ = headYaw * (float)Math.PI / 180.0f;
        }
    }

    private void setupSwimming() {
        this.body.f_104201_ = 22.0f;
    }

    private void setupSleeping() {
        this.right_front_leg.f_104202_ = -17.6f;
        this.body.f_104201_ = 22.0f;
    }
}

