/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import java.util.function.ToLongFunction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import org.gtreimagined.gt5r.GT5RConfig;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.ore.CobbleStoneType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.util.Utils;

public class ForgeHammerLoader {
    public static void init() {
        GTMaterialTypes.ORE.all().forEach(m -> {
            RecipeIngredient ore = GTMaterialTypes.ORE.getMaterialIngredient(m, 1);
            Material macerateInto = MaterialTags.MACERATE_INTO.getMapping(m);
            ItemStack crushedStack = macerateInto.has(new IMaterialTag[]{GTMaterialTypes.CRUSHED_ORE}) ? GTMaterialTypes.CRUSHED_ORE.get(macerateInto, 1) : GTMaterialTypes.DUST.get(macerateInto, 1);
            RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{ore}).io(new ItemStack[]{Utils.ca((int)MaterialTags.ORE_MULTI.getInt(m), (ItemStack)crushedStack)}).add(m.getId() + "_ore", 16L, 10L);
            if (m.has(new IMaterialTag[]{GTMaterialTypes.RAW_ORE})) {
                RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.RAW_ORE.getMaterialTag(m), (int)1)}).io(new ItemStack[]{Utils.ca((int)MaterialTags.ORE_MULTI.getInt(m), (ItemStack)crushedStack)}).add(m.getId() + "_raw_ore", 16L, 10L);
            }
            if (MaterialTags.MACERATE_INTO.getMapping(m).has(new IMaterialTag[]{GTMaterialTypes.CRUSHED_ORE})) {
                RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{GTMaterialTypes.CRUSHED_ORE.getMaterialIngredient(macerateInto, 1)}).io(new ItemStack[]{GTMaterialTypes.IMPURE_DUST.get(MaterialTags.MACERATE_INTO.getMapping(m), 1)}).add(m.getId() + "_crushed_ore", 16L, 10L);
                RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{GTMaterialTypes.PURIFIED_ORE.getMaterialIngredient(MaterialTags.MACERATE_INTO.getMapping(m), 1)}).io(new ItemStack[]{GTMaterialTypes.PURE_DUST.get(MaterialTags.MACERATE_INTO.getMapping(m), 1)}).add(m.getId() + "_purified_ore", 16L, 10L);
                if (m.has(new IMaterialTag[]{GTMaterialTypes.REFINED_ORE})) {
                    RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{GTMaterialTypes.REFINED_ORE.getMaterialIngredient(MaterialTags.MACERATE_INTO.getMapping(m), 1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(MaterialTags.MACERATE_INTO.getMapping(m), 1)}).add(m.getId() + "_refined_ore", 16L, 10L);
                }
            }
        });
        ToLongFunction<Material> baseDuration = m -> {
            if (m.has(new IMaterialTag[]{GT5RMaterialTags.RECIPE_MASS})) {
                return ((Integer)GT5RMaterialTags.RECIPE_MASS.get(m)).intValue();
            }
            return m.getMass();
        };
        GTMaterialTypes.PLATE.all().forEach(plate -> {
            if (!plate.has(new IMaterialTag[]{GTMaterialTypes.INGOT}) || plate.has(new IMaterialTag[]{MaterialTags.NOSMASH})) {
                return;
            }
            int input = GT5RConfig.MORE_LOSSY_FORGE_HAMMER.get() ? 2 : 3;
            int output = GT5RConfig.MORE_LOSSY_FORGE_HAMMER.get() ? 1 : 2;
            RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{GTMaterialTypes.INGOT.getMaterialIngredient(plate, input)}).io(new ItemStack[]{GTMaterialTypes.PLATE.get(plate, output)}).add("plate_" + plate.getId(), baseDuration.applyAsLong((Material)plate) * 2L, 16L);
        });
        GTMaterialTypes.LONG_ROD.all().stream().filter(m -> !m.has(new IMaterialTag[]{MaterialTags.NOSMASH})).forEach(rod -> RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{GTMaterialTypes.ROD.getMaterialIngredient(rod, 2)}).io(new ItemStack[]{GTMaterialTypes.LONG_ROD.get(rod, 1)}).add("rod_long_" + rod.getId(), baseDuration.applyAsLong((Material)rod) * 2L, 16L));
        GTMaterialTypes.EXQUISITE_GEM.all().forEach(m -> {
            RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{GTMaterialTypes.EXQUISITE_GEM.getMaterialIngredient(m, 1)}).io(new ItemStack[]{GTMaterialTypes.FLAWLESS_GEM.get(m, 2)}).add(m.getId() + "_exquisite", 64L, 16L);
            RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{GTMaterialTypes.FLAWLESS_GEM.getMaterialIngredient(m, 1)}).io(new ItemStack[]{GTMaterialTypes.GEM.get(m, 2)}).add(m.getId() + "_flawless", 64L, 16L);
            RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{GTMaterialTypes.GEM.getMaterialIngredient(m, 1)}).io(new ItemStack[]{GTMaterialTypes.FLAWED_GEM.get(m, 2)}).add(m.getId() + "_flawed", 64L, 16L);
            RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{GTMaterialTypes.FLAWED_GEM.getMaterialIngredient(m, 1)}).io(new ItemStack[]{GTMaterialTypes.CHIPPED_GEM.get(m, 2)}).add(m.getId() + "_chipped", 64L, 16L);
        });
        GTAPI.all(StoneType.class, s -> {
            if (!(s instanceof CobbleStoneType)) {
                return;
            }
            CobbleStoneType cs = (CobbleStoneType)s;
            RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)cs.getBlock(""), (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)cs.getBlock("cobble"))}).add(s.getId() + "_to_cobble", 10L, 16L);
            RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)cs.getBlock("bricks"), (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)cs.getBlock("cobble"))}).add(s.getId() + "_bricks_to_cobble", 10L, 16L);
            RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)cs.getBlock("smooth"), (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)cs.getBlock("cobble"))}).add("smooth_" + s.getId() + "_to_cobble", 10L, 16L);
        });
        RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42018_})}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42594_)}).add("stone_bricks_to_cobble", 10L, 16L);
        RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41994_})}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42594_)}).add("smooth_stone_to_cobble", 10L, 16L);
        RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)Tags.Items.COBBLESTONE, (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_41832_)}).add("gravel", 10L, 16L);
        RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_41905_, (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42594_)}).add("cobblestone", 10L, 16L);
        RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)Tags.Items.GRAVEL, (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_41830_)}).add("sand", 10L, 16L);
        RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)Tags.Items.GLASS, (int)1)}).io(new Item[]{GTMaterialTypes.DUST.get(Materials.Glass)}).add("glass_dust", 10L, 16L);
        RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42460_, (int)1)}).io(new ItemStack[]{GTMaterialTypes.SMALL_DUST.get(Materials.Brick, 2)}).add("brick_dust_small", 10L, 16L);
        RecipeMaps.FORGE_HAMMER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_41995_, (int)1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Brick, 2)}).add("brick_dust", 40L, 16L);
    }
}

