/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.crafting;

import com.google.common.collect.ImmutableMap;
import com.gtnewhorizon.structurelib.Registry;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gt5r.GT5Reimagined;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.GT5RCovers;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.TierMaps;
import org.gtreimagined.gt5r.data.ToolTypes;
import org.gtreimagined.gtcore.data.GTCoreCables;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.ForgeTags;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.item.ItemCover;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.recipe.ingredient.PropertyIngredient;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;

public class Parts {
    public static void loadRecipes(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        Parts.tieredItems(output, provider);
        Parts.molds(output, provider);
        provider.shapeless(output, "nether_quartz_from_milky_quartz", "parts", new ItemStack((ItemLike)Items.f_42692_), new Object[]{GTMaterialTypes.GEM.getMaterialTag(Materials.MilkyQuartz)});
        if (!GTAPI.isModLoaded((String)"tfc")) {
            provider.shapeless(output, "fire_clay_dust", "parts", GTMaterialTypes.DUST.get(Materials.Fireclay, 2), new Object[]{GTMaterialTypes.DUST.getMaterialTag(Materials.Brick), GTMaterialTypes.DUST.getMaterialTag(Materials.Clay)});
        }
        provider.addItemRecipe(output, "gt5r", "", "buckets", (ItemLike)GT5RItems.WOODEN_BUCKET, ImmutableMap.of((Object)Character.valueOf('W'), (Object)ItemTags.f_13168_, (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Copper), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"WPW", " WH"});
        provider.addStackRecipe(output, "gt5r", "drain_expensive", "parts", new ItemStack((ItemLike)GT5Reimagined.get(ItemCover.class, "drain"), 1), ImmutableMap.of((Object)Character.valueOf('A'), (Object)GTCoreTags.PLATES_IRON_ALUMINIUM, (Object)Character.valueOf('B'), (Object)Items.f_42025_), new String[]{"ABA", "B B", "ABA"});
        provider.addItemRecipe(output, "gtparts", (ItemLike)GTCoreItems.SELECTOR_TAG_ITEMS.get((Object)0), ImmutableMap.of((Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.Iron), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.getMaterialTag(Materials.Iron), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"GHG", "RRR", "GWG"});
        provider.shapeless(output, "gt5r", "", "carbon", new ItemStack((ItemLike)GTCoreItems.CarbonMesh), new Object[]{GTCoreItems.CarbonFibre, GTCoreItems.CarbonFibre});
        provider.addItemRecipe(output, "gt5r", "", "carbon", (ItemLike)GTCoreItems.CoalBall, ImmutableMap.of((Object)Character.valueOf('F'), (Object)Items.f_42484_, (Object)Character.valueOf('C'), (Object)GTMaterialTypes.DUST.getMaterialTag(Materials.Coal)), new String[]{"CCC", "CFC", "CCC"});
        provider.addItemRecipe(output, "gt5r", "", "carbon", (ItemLike)GTCoreItems.CoalChunk, ImmutableMap.of((Object)Character.valueOf('F'), (Object)Items.f_41999_, (Object)Character.valueOf('C'), (Object)GTCoreItems.CompressedCoalBall), new String[]{"CCC", "CFC", "CCC"});
        provider.addItemRecipe(output, "gt5r", "", "batteries", GT5RItems.BatteryHullSmall, ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.get(Materials.BatteryAlloy), (Object)Character.valueOf('C'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.LV, (Object)false)), new String[]{"C", "P", "P"});
        provider.addItemRecipe(output, "gt5r", "", "batteries", GT5RItems.BatteryHullMedium, ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.get(Materials.BatteryAlloy), (Object)Character.valueOf('C'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.MV, (Object)false)), new String[]{"C C", "PPP", "PPP"});
        provider.addStackRecipe(output, "gt5r", "", "batteries", GTMaterialTypes.DUST.get(Materials.Energium, 9), ImmutableMap.of((Object)Character.valueOf('R'), (Object)GTMaterialTypes.DUST.getMaterialTag(Materials.Redstone), (Object)Character.valueOf('r'), (Object)GTMaterialTypes.DUST.getMaterialTag(Materials.Ruby)), new String[]{"RrR", "rRr", "RrR"});
        provider.addItemRecipe(output, "gt5r", "front_rotation_tool", "gtparts", (ItemLike)Registry.FRONT_ROTATION_TOOL, ImmutableMap.of((Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.getMaterialTag(Materials.Wood), (Object)Character.valueOf('C'), (Object)GTMaterialTypes.ROD.getMaterialTag(Materials.Cobalt), (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Cobalt), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"FPC", " CP", "R H"});
        provider.addItemRecipe(output, "gt5r", "diamondsaw_blade", "gtparts", (ItemLike)GTCoreItems.DiamondSawBlade, ImmutableMap.of((Object)Character.valueOf('G'), (Object)GTMaterialTypes.GEAR.get(Materials.CobaltBrass), (Object)Character.valueOf('D'), (Object)GTMaterialTypes.SMALL_DUST.get(Materials.Diamond)), new String[]{" D ", "DGD", " D "});
        provider.addItemRecipe(output, "mining_pipes", (ItemLike)GT5RBlocks.MINING_PIPE_THIN, ImmutableMap.of((Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('P'), (Object)GT5RBlocks.FLUID_PIPE_STEEL.getBlockItem(PipeSize.SMALL), (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"HPF"});
        provider.addStackRecipe(output, "gt5r", "", "matches", new ItemStack((ItemLike)GTCoreItems.Match, 4), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.DUST.getMaterialTag(Materials.Phosphor), (Object)Character.valueOf('S'), (Object)GTMaterialTypes.ROD.getMaterialTag(Materials.Wood)), new String[]{"P", "S"});
        provider.shapeless(output, "gt5r", "tape_from_empty", "tapes", new ItemStack((ItemLike)GTCoreItems.Tape), new Object[]{GTCoreItems.TapeEmpty, GTCoreItems.TapeEmpty, GTCoreItems.TapeEmpty, GTCoreItems.TapeEmpty});
        provider.shapeless(output, "gt5r", "duct_tape_from_empty", "tapes", new ItemStack((ItemLike)GTCoreItems.DuctTape), new Object[]{GTCoreItems.DuctTapeEmpty, GTCoreItems.DuctTapeEmpty, GTCoreItems.DuctTapeEmpty, GTCoreItems.DuctTapeEmpty});
        provider.shapeless(output, "gt5r", "fal_duct_tape_from_empty", "tapes", new ItemStack((ItemLike)GTCoreItems.FALDuctTape), new Object[]{GTCoreItems.FALDuctTapeEmpty, GTCoreItems.FALDuctTapeEmpty, GTCoreItems.FALDuctTapeEmpty, GTCoreItems.FALDuctTapeEmpty});
        provider.addItemRecipe(output, "gt5r", "", "tapes", (ItemLike)GTCoreItems.Tape, ImmutableMap.of((Object)Character.valueOf('P'), (Object)Items.f_42516_, (Object)Character.valueOf('G'), (Object)Materials.Glue.getLiquid().m_6859_()), new String[]{"PPP", " G "});
        provider.addItemRecipe(output, "gt5r", "", "tapes", (ItemLike)GTCoreItems.DuctTape, ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.FOIL.getMaterialTag(Materials.Plastic), (Object)Character.valueOf('G'), (Object)Materials.Glue.getLiquid().m_6859_()), new String[]{"PPP", " G "});
        provider.addItemRecipe(output, "gt5r", "", "tapes", (ItemLike)GTCoreItems.FALDuctTape, ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.FOIL.getMaterialTag(Materials.Tungsten), (Object)Character.valueOf('G'), (Object)Materials.Glue.getLiquid().m_6859_()), new String[]{"PPP", " G "});
        provider.shapeless(output, "gt5r", "data_stick_clearing", "data_sticks", new ItemStack(GT5RItems.DataStick), new Object[]{GT5RItems.DataStick});
        provider.shapeless(output, "gt5r", "fluid_filter_reset", "filters", GT5RCovers.COVER_FLUID_FILTER.getItem(), new Object[]{GT5RCovers.COVER_FLUID_FILTER.getItem().m_41720_()});
        provider.shapeless(output, "gt5r", "item_filter_reset", "filters", GT5RCovers.COVER_ITEM_FILTER.getItem(), new Object[]{GT5RCovers.COVER_ITEM_FILTER.getItem().m_41720_()});
        provider.shapeless(output, "gt5r", "item_retriever_reset", "filters", GT5RCovers.COVER_ITEM_RETRIEVER.getItem(), new Object[]{GT5RCovers.COVER_ITEM_RETRIEVER.getItem().m_41720_()});
        provider.addItemRecipe(output, "covers", (ItemLike)GT5RCovers.COVER_PROGRESS_SENSOR.getItem().m_41720_(), ImmutableMap.of((Object)Character.valueOf('W'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.LV, (Object)false), (Object)Character.valueOf('A'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium), (Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.Brass), (Object)Character.valueOf('C'), (Object)GTCoreTags.CIRCUITS_GOOD), new String[]{"WAW", "GCG"});
        provider.addItemRecipe(output, "covers", (ItemLike)GT5RCovers.COVER_REDSTONE_CONDUCTOR_ACCEPT.getItem().m_41720_(), ImmutableMap.of((Object)Character.valueOf('W'), (Object)GTCoreCables.WIRE_RED_ALLOY.getBlock(PipeSize.VTINY), (Object)Character.valueOf('A'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium)), new String[]{"W", "A"});
        provider.addItemRecipe(output, "covers", (ItemLike)GT5RCovers.COVER_REDSTONE_CONDUCTOR_EMIT.getItem().m_41720_(), ImmutableMap.of((Object)Character.valueOf('W'), (Object)GTCoreCables.WIRE_RED_ALLOY.getBlock(PipeSize.VTINY), (Object)Character.valueOf('A'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium)), new String[]{"A", "W"});
        provider.shapeless(output, "gt5r", "redstone_conductor_accept_conversion", "covers", GT5RCovers.COVER_REDSTONE_CONDUCTOR_EMIT.getItem(), new Object[]{GT5RCovers.COVER_REDSTONE_CONDUCTOR_ACCEPT.getItem().m_41720_()});
        provider.shapeless(output, "gt5r", "redstone_conductor_emit_conversion", "covers", GT5RCovers.COVER_REDSTONE_CONDUCTOR_ACCEPT.getItem(), new Object[]{GT5RCovers.COVER_REDSTONE_CONDUCTOR_EMIT.getItem().m_41720_()});
        provider.addItemRecipe(output, "covers", (ItemLike)GT5RCovers.COVER_ITEM_RETRIEVER.getItem().m_41720_(), ImmutableMap.of((Object)Character.valueOf('C'), (Object)GTCoreTags.CIRCUITS_ADVANCED, (Object)Character.valueOf('F'), (Object)GT5RCovers.COVER_ITEM_FILTER.getItem().m_41720_(), (Object)Character.valueOf('E'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Electrum), (Object)Character.valueOf('P'), GT5RItems.PistonLV), new String[]{"EPE", "CFC"});
        provider.addItemRecipe(output, "misc", (ItemLike)GTCoreItems.DiamondGrindHead, ImmutableMap.of((Object)Character.valueOf('D'), (Object)GTMaterialTypes.DUST.getMaterialTag(Materials.Diamond), (Object)Character.valueOf('G'), (Object)GTMaterialTypes.GEM.getMaterialTag(Materials.Diamond), (Object)Character.valueOf('S'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Steel)), new String[]{"DSD", "SGS", "DSD"});
        provider.addItemRecipe(output, "misc", (ItemLike)GTCoreItems.TungstenGrindHead, ImmutableMap.of((Object)Character.valueOf('D'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Tungsten), (Object)Character.valueOf('G'), (Object)GTMaterialTypes.GEM.getMaterialTag(Materials.Diamond), (Object)Character.valueOf('S'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Steel)), new String[]{"DSD", "SGS", "DSD"});
        provider.addItemRecipe(output, "hazmat", (ItemLike)GTCoreItems.UniversalHazardSuitMask, ImmutableMap.of((Object)Character.valueOf('L'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Lead), (Object)Character.valueOf('A'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium), (Object)Character.valueOf('C'), (Object)Items.f_42464_, (Object)Character.valueOf('G'), (Object)Items.f_42027_), new String[]{"ALA", "LCL", "AGA"});
        provider.addItemRecipe(output, "hazmat", (ItemLike)GTCoreItems.UniversalHazardSuitShirt, ImmutableMap.of((Object)Character.valueOf('L'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Lead), (Object)Character.valueOf('A'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium), (Object)Character.valueOf('C'), (Object)Items.f_42465_), new String[]{"ALA", "LCL", "ALA"});
        provider.addItemRecipe(output, "hazmat", (ItemLike)GTCoreItems.UniversalHazardSuitPants, ImmutableMap.of((Object)Character.valueOf('L'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Lead), (Object)Character.valueOf('A'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium), (Object)Character.valueOf('C'), (Object)Items.f_42466_), new String[]{"ALA", "LCL", "ALA"});
        provider.addItemRecipe(output, "hazmat", (ItemLike)GTCoreItems.UniversalHazardSuitBoots, ImmutableMap.of((Object)Character.valueOf('L'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Lead), (Object)Character.valueOf('A'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium), (Object)Character.valueOf('C'), (Object)Items.f_42467_), new String[]{"ALA", "LCL", "ALA"});
        provider.addItemRecipe(output, "misc", GT5RItems.EmptyGeigerCounter, ImmutableMap.of((Object)Character.valueOf('S'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Aluminium), (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium), (Object)Character.valueOf('C'), (Object)GT5RItems.CellTin, (Object)Character.valueOf('c'), TierMaps.TIER_CIRCUITS.apply(Tier.LV), (Object)Character.valueOf('s'), (Object)GTTools.SCREWDRIVER.getTag()), new String[]{"SCS", "PcP", "SsS"});
        provider.addToolRecipe(ToolTypes.SCANNER_BUILDER.get("portable-scanner"), output, "gt5r", "scanner", "misc", new ItemStack((ItemLike)GT5RItems.PortableScanner), ImmutableMap.of((Object)Character.valueOf('E'), GT5RItems.EmitterHV, (Object)Character.valueOf('A'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium), (Object)Character.valueOf('S'), GT5RItems.SensorHV, (Object)Character.valueOf('C'), (Object)GTCoreTags.CIRCUITS_ADVANCED, (Object)Character.valueOf('c'), GT5RItems.ComputerMonitor, (Object)Character.valueOf('B'), (Object)PropertyIngredient.builder((String)"battery").itemStacks(new ItemLike[]{GT5RItems.BatteryMediumLithium}).build()), new String[]{"EAS", "CcC", "ABA"});
        provider.addItemRecipe(output, "misc", GT5RItems.ComputerMonitor, ImmutableMap.of((Object)Character.valueOf('A'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Aluminium), (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Glass), (Object)Character.valueOf('g'), (Object)ForgeTags.DYES_GREEN, (Object)Character.valueOf('b'), (Object)ForgeTags.DYES_BLUE, (Object)Character.valueOf('r'), (Object)ForgeTags.DYES_RED, (Object)Character.valueOf('G'), (Object)GTMaterialTypes.DUST.getMaterialTag(Materials.Glowstone)), new String[]{"AgA", "rPb", "AGA"});
    }

    private static void tieredItems(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        Arrays.stream(Tier.getStandardWithIV()).forEach(t -> {
            Material magnet = t == Tier.ULV || t == Tier.LV ? Materials.IronMagnetic : (t == Tier.EV || t == Tier.IV ? Materials.NeodymiumMagnetic : Materials.SteelMagnetic);
            Object cable = TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, t, (Object)false);
            Material mat = (Material)TierMaps.TIER_MATERIALS.get(t);
            if (mat == null) {
                return;
            }
            TagKey smallGear = GTMaterialTypes.SMALL_GEAR.getMaterialTag(mat);
            TagKey plate = GTMaterialTypes.PLATE.getMaterialTag(mat);
            TagKey rod = GTMaterialTypes.ROD.getMaterialTag(mat);
            TagKey<Item> circuit = TierMaps.TIER_CIRCUITS.apply((Tier)t);
            Item motor = (Item)GTAPI.get(ItemBasic.class, (String)("motor_" + t.getId()), (String)"gtcore");
            Item piston = (Item)GT5Reimagined.get(ItemBasic.class, "piston_" + t.getId());
            Item robotArm = (Item)GT5Reimagined.get(ItemCover.class, "robot_arm_" + t.getId());
            Item emitter = (Item)GT5Reimagined.get(ItemBasic.class, "emitter_" + t.getId());
            Item sensor = (Item)GT5Reimagined.get(ItemBasic.class, "sensor_" + t.getId());
            Item pump = (Item)GT5Reimagined.get(ItemCover.class, "pump_" + t.getId());
            Item conveyor = (Item)GT5Reimagined.get(ItemCover.class, "conveyor_" + t.getId());
            Item fieldGen = (Item)GT5Reimagined.get(ItemBasic.class, "field_gen_" + t.getId());
            TagKey emitterRod = GTMaterialTypes.ROD.getMaterialTag((Material)TierMaps.EMITTER_RODS.get(t));
            Block wire = t == Tier.EV || t == Tier.IV ? GT5RBlocks.WIRE_ANNEALED_COPPER.getBlock(Parts.fromTier(t)) : TierMaps.WIRE_GETTER.apply(Parts.fromTier(t), Tier.LV);
            TagKey motorRod = t == Tier.LV ? RecipeIngredient.ofIngredient((int)1, (TagKey[])new TagKey[]{rod, GTMaterialTypes.ROD.getMaterialTag(Materials.Iron)}) : rod;
            provider.addItemRecipe(output, "gtparts", (ItemLike)motor, ImmutableMap.of((Object)Character.valueOf('M'), (Object)GTMaterialTypes.ROD.get(magnet), (Object)Character.valueOf('C'), (Object)cable, (Object)Character.valueOf('W'), (Object)wire, (Object)Character.valueOf('R'), (Object)motorRod), new String[]{"CWR", "WMW", "RWC"});
            provider.addItemRecipe(output, "gtparts", (ItemLike)piston, ImmutableMap.of((Object)Character.valueOf('M'), (Object)motor, (Object)Character.valueOf('C'), (Object)cable, (Object)Character.valueOf('G'), (Object)smallGear, (Object)Character.valueOf('P'), (Object)plate, (Object)Character.valueOf('R'), (Object)rod), new String[]{"PPP", "CRR", "CMG"});
            provider.addItemRecipe(output, "gtparts", (ItemLike)conveyor, ImmutableMap.of((Object)Character.valueOf('M'), (Object)motor, (Object)Character.valueOf('C'), (Object)cable, (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.get(Materials.Rubber)), new String[]{"PPP", "MCM", "PPP"});
            provider.addItemRecipe(output, "gtparts", (ItemLike)robotArm, ImmutableMap.of((Object)Character.valueOf('M'), (Object)motor, (Object)Character.valueOf('C'), (Object)cable, (Object)Character.valueOf('P'), (Object)piston, (Object)Character.valueOf('I'), circuit, (Object)Character.valueOf('R'), (Object)rod), new String[]{"CCC", "MRM", "PIR"});
            provider.addItemRecipe(output, "gtparts", (ItemLike)emitter, ImmutableMap.of((Object)Character.valueOf('R'), (Object)emitterRod, (Object)Character.valueOf('G'), (Object)ForgeTags.GEMS_QUARTZ_ALL, (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('C'), circuit), new String[]{"RRC", "LGR", "CLR"});
            provider.addItemRecipe(output, "gtparts", (ItemLike)sensor, ImmutableMap.of((Object)Character.valueOf('R'), (Object)emitterRod, (Object)Character.valueOf('G'), (Object)ForgeTags.GEMS_QUARTZ_ALL, (Object)Character.valueOf('C'), circuit, (Object)Character.valueOf('P'), (Object)plate), new String[]{"P G", "PR ", "CPP"});
            PipeSize osmium = t == Tier.IV ? PipeSize.HUGE : PipeSize.values()[t.getIntegerId() - 1];
            provider.addItemRecipe(output, "gtparts", (ItemLike)fieldGen, ImmutableMap.of((Object)Character.valueOf('O'), (Object)GT5RBlocks.WIRE_OSMIUM.getBlockItem(osmium), (Object)Character.valueOf('C'), circuit, (Object)Character.valueOf('G'), (Object)GTMaterialTypes.LONG_ROD.getMaterialTag(Materials.NeodymiumMagnetic)), new String[]{"OCO", "CGC", "OCO"});
            Material rotorMat = (Material)TierMaps.TIER_ROTORS.get(t);
            provider.addItemRecipe(output, "gtparts", (ItemLike)pump, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('C'), cable).put((Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()).put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('R'), (Object)GTMaterialTypes.SCREW.getMaterialTag(rotorMat)).put((Object)Character.valueOf('T'), (Object)GTMaterialTypes.ROTOR.getMaterialTag(rotorMat)).put((Object)Character.valueOf('O'), (Object)GTMaterialTypes.RING.get(Materials.Rubber)).put((Object)Character.valueOf('P'), TierMaps.PIPE_GETTER.apply(PipeSize.NORMAL, (Tier)t)).build(), new String[]{"RTO", "SPW", "OMC"});
        });
    }

    private static void molds(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        provider.addItemRecipe(output, "gt5r", "empty_shape", "gtparts", (ItemLike)GTCoreItems.EmptyShape, ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.get(Materials.Steel), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"HF", "PP", "PP"});
        Parts.moldRecipe(output, provider, (Item)GTCoreItems.PlateMold, "H", "P");
        Parts.moldRecipe(output, provider, (Item)GTCoreItems.IngotMold, "P", "H");
        Parts.moldRecipe(output, provider, (Item)GTCoreItems.CasingMold, " H", "P ");
        Parts.moldRecipe(output, provider, (Item)GTCoreItems.GearMold, "PH");
        Parts.moldRecipe(output, provider, (Item)GTCoreItems.CoinageMold, "H ", " P");
        Parts.moldRecipe(output, provider, (Item)GTCoreItems.BottleMold, "P ", " H");
        Parts.moldRecipe(output, provider, (Item)GTCoreItems.BallMold, " P", "H ");
        Parts.moldRecipe(output, provider, (Item)GTCoreItems.BlockMold, "HP");
        Parts.moldRecipe(output, provider, (Item)GTCoreItems.NuggetMold, "P H");
        Parts.moldRecipe(output, provider, (Item)GTCoreItems.AnvilMold, " P", "  ", "H ");
        Parts.moldRecipe(output, provider, (Item)GTCoreItems.SmallGearMold, "H P");
        Parts.moldRecipe(output, provider, (Item)GTCoreItems.LongRodMold, "  H", "P  ");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.FoilShape, (Item)GTCoreItems.PlateShape, "H ", " P");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.RodShape, (Item)GTCoreItems.LongRodShape, " H", "P ");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.RodShape, "PH");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.RodShape, (Item)GTCoreItems.BoltShape, "H ", " P");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.RingShape, "P", "H");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.RingShape, (Item)GTCoreItems.CellShape, "PH");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.IngotShape, "H ", " P");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.RodShape, (Item)GTCoreItems.WireShape, "H", "P");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.FoilShape, (Item)GTCoreItems.CasingShape, "H", "P");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.TinyPipeShape, " H", "  ", "P ");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.SmallPipeShape, "P  ", "  H");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.NormalPipeShape, "P ", "  ", " H");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.LargePipeShape, "P  ", "   ", "  H");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.HugePipeShape, "  H", "   ", "P  ");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.IngotShape, (Item)GTCoreItems.BlockShape, "H ", " P");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.TinyPlateShape, (Item)GTCoreItems.SwordBladeShape, "PH");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.IngotShape, (Item)GTCoreItems.PickaxeHeadShape, "H", "P");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.TinyPlateShape, (Item)GTCoreItems.ShovelHeadShape, "H", "P");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.TinyPlateShape, (Item)GTCoreItems.AxeHeadShape, "H ", " P");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.IngotShape, (Item)GTCoreItems.HoeHeadShape, "PH");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.IngotShape, (Item)GTCoreItems.HammerHeadShape, " H", "P ");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.TinyPlateShape, (Item)GTCoreItems.FileHeadShape, " H", "P ");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.TinyPlateShape, (Item)GTCoreItems.SawBladeShape, "P ", " H");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.RingShape, (Item)GTCoreItems.GearShape, "H ", " P");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.RingShape, (Item)GTCoreItems.BottleShape, " H", "P ");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.RingShape, (Item)GTCoreItems.SmallGearShape, "H", "P");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.FoilShape, "P ", " H");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.TinyPlateShape, "H", "P");
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.RodShape, (Item)GTCoreItems.FineWireShape, "PH");
    }

    private static void moldRecipe(Consumer<FinishedRecipe> output, GTRecipeProvider provider, Item mold, String ... shapes) {
        provider.addItemRecipe(output, "gt5r", "", "gtparts", (ItemLike)mold, ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTCoreItems.EmptyShape, (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), shapes);
    }

    private static void shapeRecipe(Consumer<FinishedRecipe> output, GTRecipeProvider provider, Item inputMold, Item mold, String ... shapes) {
        provider.addItemRecipe(output, "gt5r", "", "gtparts", (ItemLike)mold, ImmutableMap.of((Object)Character.valueOf('P'), (Object)inputMold, (Object)Character.valueOf('H'), (Object)GTTools.WIRE_CUTTER.getTag()), shapes);
    }

    private static void shapeRecipe(Consumer<FinishedRecipe> output, GTRecipeProvider provider, Item mold, String ... shapes) {
        Parts.shapeRecipe(output, provider, (Item)GTCoreItems.EmptyShape, mold, shapes);
    }

    public static PipeSize fromTier(Tier tier) {
        if (tier == Tier.LV) {
            return PipeSize.VTINY;
        }
        if (tier == Tier.MV) {
            return PipeSize.TINY;
        }
        if (tier == Tier.HV) {
            return PipeSize.SMALL;
        }
        if (tier == Tier.IV) {
            return PipeSize.HUGE;
        }
        return PipeSize.NORMAL;
    }
}

