/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.crafting;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.ToolTypes;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtcore.data.GTCoreTools;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.material.data.ToolData;
import org.gtreimagined.gtlib.recipe.ingredient.PropertyIngredient;
import org.gtreimagined.gtlib.tool.IGTTool;

public class ElectricToolRecipes {
    public static void loadRecipes(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        MaterialTags.TOOLS.getAll().forEach((m, d) -> {
            if (d.toolTypes().contains(ToolTypes.PINCERS) && (m.has(new IMaterialTag[]{GTMaterialTypes.GEM}) || m.has(new IMaterialTag[]{GTMaterialTypes.PLATE}))) {
                TagKey plateGem = m.has(new IMaterialTag[]{GTMaterialTypes.GEM}) ? GTMaterialTypes.GEM.getMaterialTag(m) : (m.has(new IMaterialTag[]{GTMaterialTypes.PLATE}) ? GTMaterialTypes.PLATE.getMaterialTag(m) : GTMaterialTypes.INGOT.getMaterialTag(m));
                TagKey rod = d.handleMaterial().has(new IMaterialTag[]{GTMaterialTypes.ROD}) ? GTMaterialTypes.ROD.getMaterialTag(d.handleMaterial()) : GTMaterialTypes.ROD.getMaterialTag(Materials.Wood);
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)Character.valueOf('R'), (Object)rod).put((Object)Character.valueOf('P'), (Object)plateGem).put((Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()).put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag());
                if (m.has(new IMaterialTag[]{GTMaterialTypes.SCREW})) {
                    builder.put((Object)Character.valueOf('W'), (Object)GTMaterialTypes.SCREW.getMaterialTag(m));
                }
                String last = m.has(new IMaterialTag[]{GTMaterialTypes.SCREW}) ? " W " : " R ";
                provider.addStackRecipe(output, "gtcore", "", "", ToolTypes.PINCERS.getToolStack(m), builder.build(), new String[]{"PHP", last, "RSR"});
            }
        });
        provider.addItemRecipe(output, "tools", (ItemLike)GTCoreItems.GlassMagnifyingGlass, ImmutableMap.of((Object)Character.valueOf('G'), (Object)GTMaterialTypes.LENS.getMaterialTag(Materials.Glass), (Object)Character.valueOf('S'), (Object)Tags.Items.RODS_WOODEN), new String[]{"G", "S"});
        provider.addItemRecipe(output, "tools", (ItemLike)GTCoreItems.DiamondMagnifyingGlass, ImmutableMap.of((Object)Character.valueOf('G'), (Object)GTMaterialTypes.LENS.getMaterialTag(Materials.Diamond), (Object)Character.valueOf('S'), (Object)Tags.Items.RODS_WOODEN), new String[]{"G", "S"});
        GTMaterialTypes.PLATE.all().forEach(m -> {
            if (m.has(new IMaterialTag[]{GTMaterialTypes.DRILL_BIT})) {
                provider.addItemRecipe(output, "bits", (ItemLike)GTMaterialTypes.DRILL_BIT.get(m), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m), (Object)Character.valueOf('S'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Steel), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"PSP", "PSP", "SHS"});
            }
            if (m.has(new IMaterialTag[]{GTMaterialTypes.WRENCH_BIT})) {
                provider.addItemRecipe(output, "bits", (ItemLike)GTMaterialTypes.WRENCH_BIT.get(m), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.RING.getMaterialTag(Materials.Steel), (Object)Character.valueOf('S'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('s'), (Object)GTTools.SCREWDRIVER.getTag()), new String[]{"HPS", "PRP", "SPs"});
            }
            if (m.has(new IMaterialTag[]{GTMaterialTypes.CHAINSAW_BIT})) {
                provider.addItemRecipe(output, "bits", (ItemLike)GTMaterialTypes.CHAINSAW_BIT.get(m), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.RING.getMaterialTag(Materials.Steel), (Object)Character.valueOf('S'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Steel), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"SRS", "PHP", "SRS"});
            }
            if (m.has(new IMaterialTag[]{GTMaterialTypes.BUZZSAW_BLADE})) {
                provider.addItemRecipe(output, "bits", (ItemLike)GTMaterialTypes.BUZZSAW_BLADE.get(m), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('C'), (Object)GTTools.WIRE_CUTTER.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()), new String[]{"WPH", "P P", "FPC"});
            }
        });
        CriterionTriggerInstance in = provider.hasSafeItem(GTTools.SCREWDRIVER.getTag());
        IGTTool drill_lv = (IGTTool)GTAPI.get(IGTTool.class, (String)"drill_lv", (String)"gtcore");
        IGTTool drill_mv = (IGTTool)GTAPI.get(IGTTool.class, (String)"drill_mv", (String)"gtcore");
        IGTTool drill_hv = (IGTTool)GTAPI.get(IGTTool.class, (String)"drill_hv", (String)"gtcore");
        provider.addToolRecipe(ToolTypes.POWERED_TOOL_BUILDER.get(GTCoreTools.DRILL.getId() + "-lv"), output, "gt5r", GTCoreTools.DRILL.getId() + "_lv_recipe", "gt_drills", ElectricToolRecipes.resolveStack(drill_lv, Material.NULL, Materials.Aluminium, 0L, 100000L), ImmutableMap.builder().put((Object)Character.valueOf('W'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.DRILL_BIT, (String)"primary")).put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"battery").itemTags(new TagKey[]{GTCoreTags.BATTERIES_LV}).build()).put((Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").mats(new Material[]{Materials.Aluminium}).types(new MaterialTypeItem[]{GTMaterialTypes.PLATE}).build()).put((Object)Character.valueOf('s'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.Aluminium)).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorLV).build(), new String[]{"sWS", "GMG", "PbP"});
        provider.addToolRecipe(ToolTypes.POWERED_TOOL_BUILDER.get(GTCoreTools.DRILL.getId() + "-mv"), output, "gt5r", GTCoreTools.DRILL.getId() + "_mv_recipe", "gt_drills", ElectricToolRecipes.resolveStack(drill_mv, Material.NULL, Materials.StainlessSteel, 0L, 200000L), ImmutableMap.builder().put((Object)Character.valueOf('W'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.DRILL_BIT, (String)"primary")).put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"battery").itemTags(new TagKey[]{GTCoreTags.BATTERIES_MV}).build()).put((Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").mats(new Material[]{Materials.StainlessSteel}).types(new MaterialTypeItem[]{GTMaterialTypes.PLATE}).build()).put((Object)Character.valueOf('s'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.StainlessSteel)).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorMV).build(), new String[]{"sWS", "GMG", "PbP"});
        provider.addToolRecipe(ToolTypes.POWERED_TOOL_BUILDER.get(GTCoreTools.DRILL.getId() + "-hv"), output, "gt5r", GTCoreTools.DRILL.getId() + "_hv_recipe", "gt_drills", ElectricToolRecipes.resolveStack(drill_hv, Material.NULL, Materials.Titanium, 0L, 800000L), ImmutableMap.builder().put((Object)Character.valueOf('W'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.DRILL_BIT, (String)"primary")).put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"battery").itemTags(new TagKey[]{GTCoreTags.BATTERIES_HV}).build()).put((Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").mats(new Material[]{Materials.Titanium}).types(new MaterialTypeItem[]{GTMaterialTypes.PLATE}).build()).put((Object)Character.valueOf('s'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.Titanium)).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorHV).build(), new String[]{"sWS", "GMG", "PbP"});
        provider.addToolRecipe(ToolTypes.UNIT_POWERED_TOOL_BUILDER.get(GTCoreTools.DRILL.getId() + "-lv"), output, "gt5r", GTCoreTools.DRILL.getId() + "_lv_power_unit_recipe", "gt_drills", ElectricToolRecipes.resolveStack(drill_lv, Material.NULL, Materials.Aluminium, 0L, 100000L), ImmutableMap.of((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.DRILL_BIT, (String)"primary"), (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").itemTags(new TagKey[]{GTCoreTags.POWER_UNIT_LV}).build()), new String[]{"BS", "P "});
        provider.addToolRecipe(ToolTypes.UNIT_POWERED_TOOL_BUILDER.get(GTCoreTools.DRILL.getId() + "-mv"), output, "gt5r", GTCoreTools.DRILL.getId() + "_mv_power_unit_recipe", "gt_drills", ElectricToolRecipes.resolveStack(drill_mv, Material.NULL, Materials.StainlessSteel, 0L, 100000L), ImmutableMap.of((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.DRILL_BIT, (String)"primary"), (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").itemTags(new TagKey[]{GTCoreTags.POWER_UNIT_MV}).build()), new String[]{"BS", "P "});
        provider.addToolRecipe(ToolTypes.UNIT_POWERED_TOOL_BUILDER.get(GTCoreTools.DRILL.getId() + "-hv"), output, "gt5r", GTCoreTools.DRILL.getId() + "_hv_power_unit_recipe", "gt_drills", ElectricToolRecipes.resolveStack(drill_hv, Material.NULL, Materials.Titanium, 0L, 100000L), ImmutableMap.of((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.DRILL_BIT, (String)"primary"), (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").itemTags(new TagKey[]{GTCoreTags.POWER_UNIT_HV}).build()), new String[]{"BS", "P "});
        IGTTool chainsaw_lv = (IGTTool)GTAPI.get(IGTTool.class, (String)"chainsaw_lv", (String)"gtcore");
        IGTTool chainsaw_mv = (IGTTool)GTAPI.get(IGTTool.class, (String)"chainsaw_mv", (String)"gtcore");
        IGTTool chainsaw_hv = (IGTTool)GTAPI.get(IGTTool.class, (String)"chainsaw_hv", (String)"gtcore");
        provider.addToolRecipe(ToolTypes.POWERED_TOOL_BUILDER.get(GTCoreTools.CHAINSAW.getId() + "-lv"), output, "gt5r", GTCoreTools.CHAINSAW.getId() + "_lv_recipe", "gt_chainsaws", ElectricToolRecipes.resolveStack(chainsaw_lv, Material.NULL, Materials.Aluminium, 0L, 100000L), ImmutableMap.builder().put((Object)Character.valueOf('W'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.CHAINSAW_BIT, (String)"primary")).put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"battery").itemTags(new TagKey[]{GTCoreTags.BATTERIES_LV}).build()).put((Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").mats(new Material[]{Materials.Aluminium}).types(new MaterialTypeItem[]{GTMaterialTypes.PLATE}).build()).put((Object)Character.valueOf('s'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.Aluminium)).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorLV).build(), new String[]{"sWS", "GMG", "PbP"});
        provider.addToolRecipe(ToolTypes.POWERED_TOOL_BUILDER.get(GTCoreTools.CHAINSAW.getId() + "-mv"), output, "gt5r", GTCoreTools.CHAINSAW.getId() + "_mv_recipe", "gt_chainsaws", ElectricToolRecipes.resolveStack(chainsaw_mv, Material.NULL, Materials.StainlessSteel, 0L, 200000L), ImmutableMap.builder().put((Object)Character.valueOf('W'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.CHAINSAW_BIT, (String)"primary")).put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"battery").itemTags(new TagKey[]{GTCoreTags.BATTERIES_MV}).build()).put((Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").mats(new Material[]{Materials.StainlessSteel}).types(new MaterialTypeItem[]{GTMaterialTypes.PLATE}).build()).put((Object)Character.valueOf('s'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.StainlessSteel)).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorMV).build(), new String[]{"sWS", "GMG", "PbP"});
        provider.addToolRecipe(ToolTypes.POWERED_TOOL_BUILDER.get(GTCoreTools.CHAINSAW.getId() + "-hv"), output, "gt5r", GTCoreTools.CHAINSAW.getId() + "_hv_recipe", "gt_chainsaws", ElectricToolRecipes.resolveStack(chainsaw_hv, Material.NULL, Materials.Titanium, 0L, 800000L), ImmutableMap.builder().put((Object)Character.valueOf('W'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.CHAINSAW_BIT, (String)"primary")).put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"battery").itemTags(new TagKey[]{GTCoreTags.BATTERIES_HV}).build()).put((Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").mats(new Material[]{Materials.Titanium}).types(new MaterialTypeItem[]{GTMaterialTypes.PLATE}).build()).put((Object)Character.valueOf('s'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.Titanium)).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorHV).build(), new String[]{"sWS", "GMG", "PbP"});
        provider.addToolRecipe(ToolTypes.UNIT_POWERED_TOOL_BUILDER.get(GTCoreTools.CHAINSAW.getId() + "-lv"), output, "gt5r", GTCoreTools.CHAINSAW.getId() + "_lv_power_unit_recipe", "gt_chainsaws", ElectricToolRecipes.resolveStack(chainsaw_lv, Material.NULL, Materials.Aluminium, 0L, 100000L), ImmutableMap.of((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.CHAINSAW_BIT, (String)"primary"), (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").itemTags(new TagKey[]{GTCoreTags.POWER_UNIT_LV}).build()), new String[]{"BS", "P "});
        provider.addToolRecipe(ToolTypes.UNIT_POWERED_TOOL_BUILDER.get(GTCoreTools.CHAINSAW.getId() + "-mv"), output, "gt5r", GTCoreTools.CHAINSAW.getId() + "_mv_power_unit_recipe", "gt_chainsaws", ElectricToolRecipes.resolveStack(chainsaw_mv, Material.NULL, Materials.StainlessSteel, 0L, 100000L), ImmutableMap.of((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.CHAINSAW_BIT, (String)"primary"), (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").itemTags(new TagKey[]{GTCoreTags.POWER_UNIT_MV}).build()), new String[]{"BS", "P "});
        provider.addToolRecipe(ToolTypes.UNIT_POWERED_TOOL_BUILDER.get(GTCoreTools.CHAINSAW.getId() + "-hv"), output, "gt5r", GTCoreTools.CHAINSAW.getId() + "_hv_power_unit_recipe", "gt_chainsaws", ElectricToolRecipes.resolveStack(chainsaw_hv, Material.NULL, Materials.Titanium, 0L, 100000L), ImmutableMap.of((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.CHAINSAW_BIT, (String)"primary"), (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").itemTags(new TagKey[]{GTCoreTags.POWER_UNIT_HV}).build()), new String[]{"BS", "P "});
        IGTTool electric_wrench_lv = (IGTTool)GTAPI.get(IGTTool.class, (String)"electric_wrench_lv", (String)"gtcore");
        IGTTool electric_wrench_mv = (IGTTool)GTAPI.get(IGTTool.class, (String)"electric_wrench_mv", (String)"gtcore");
        IGTTool electric_wrench_hv = (IGTTool)GTAPI.get(IGTTool.class, (String)"electric_wrench_hv", (String)"gtcore");
        provider.addToolRecipe(ToolTypes.POWERED_TOOL_BUILDER.get(GTCoreTools.ELECTRIC_WRENCH.getId() + "-lv"), output, "gt5r", GTCoreTools.ELECTRIC_WRENCH.getId() + "_lv_recipe", "gt_electric_wrenches", ElectricToolRecipes.resolveStack(electric_wrench_lv, Material.NULL, Materials.Aluminium, 0L, 100000L), ImmutableMap.builder().put((Object)Character.valueOf('W'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.WRENCH_BIT, (String)"primary")).put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"battery").itemTags(new TagKey[]{GTCoreTags.BATTERIES_LV}).build()).put((Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").mats(new Material[]{Materials.Aluminium}).types(new MaterialTypeItem[]{GTMaterialTypes.PLATE}).build()).put((Object)Character.valueOf('s'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.Aluminium)).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorLV).build(), new String[]{"sWS", "GMG", "PbP"});
        provider.addToolRecipe(ToolTypes.POWERED_TOOL_BUILDER.get(GTCoreTools.ELECTRIC_WRENCH.getId() + "-mv"), output, "gt5r", GTCoreTools.ELECTRIC_WRENCH.getId() + "_mv_recipe", "gt_electric_wrenches", ElectricToolRecipes.resolveStack(electric_wrench_mv, Material.NULL, Materials.StainlessSteel, 0L, 200000L), ImmutableMap.builder().put((Object)Character.valueOf('W'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.WRENCH_BIT, (String)"primary")).put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"battery").itemTags(new TagKey[]{GTCoreTags.BATTERIES_MV}).build()).put((Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").mats(new Material[]{Materials.StainlessSteel}).types(new MaterialTypeItem[]{GTMaterialTypes.PLATE}).build()).put((Object)Character.valueOf('s'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.StainlessSteel)).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorMV).build(), new String[]{"sWS", "GMG", "PbP"});
        provider.addToolRecipe(ToolTypes.POWERED_TOOL_BUILDER.get(GTCoreTools.ELECTRIC_WRENCH.getId() + "-hv"), output, "gt5r", GTCoreTools.ELECTRIC_WRENCH.getId() + "_hv_recipe", "gt_electric_wrenches", ElectricToolRecipes.resolveStack(electric_wrench_hv, Material.NULL, Materials.Titanium, 0L, 800000L), ImmutableMap.builder().put((Object)Character.valueOf('W'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.WRENCH_BIT, (String)"primary")).put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"battery").itemTags(new TagKey[]{GTCoreTags.BATTERIES_HV}).build()).put((Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").mats(new Material[]{Materials.Titanium}).types(new MaterialTypeItem[]{GTMaterialTypes.PLATE}).build()).put((Object)Character.valueOf('s'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.Titanium)).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorHV).build(), new String[]{"sWS", "GMG", "PbP"});
        provider.addToolRecipe(ToolTypes.UNIT_POWERED_TOOL_BUILDER.get(GTCoreTools.ELECTRIC_WRENCH.getId() + "-lv"), output, "gt5r", GTCoreTools.ELECTRIC_WRENCH.getId() + "_lv_power_unit_recipe", "electric_wrenches", ElectricToolRecipes.resolveStack(electric_wrench_lv, Material.NULL, Materials.Aluminium, 0L, 100000L), ImmutableMap.of((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.WRENCH_BIT, (String)"primary"), (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").itemTags(new TagKey[]{GTCoreTags.POWER_UNIT_LV}).build()), new String[]{"BS", "P "});
        provider.addToolRecipe(ToolTypes.UNIT_POWERED_TOOL_BUILDER.get(GTCoreTools.ELECTRIC_WRENCH.getId() + "-mv"), output, "gt5r", GTCoreTools.ELECTRIC_WRENCH.getId() + "_mv_power_unit_recipe", "electric_wrenches", ElectricToolRecipes.resolveStack(electric_wrench_mv, Material.NULL, Materials.StainlessSteel, 0L, 100000L), ImmutableMap.of((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.WRENCH_BIT, (String)"primary"), (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").itemTags(new TagKey[]{GTCoreTags.POWER_UNIT_MV}).build()), new String[]{"BS", "P "});
        provider.addToolRecipe(ToolTypes.UNIT_POWERED_TOOL_BUILDER.get(GTCoreTools.ELECTRIC_WRENCH.getId() + "-hv"), output, "gt5r", GTCoreTools.ELECTRIC_WRENCH.getId() + "_hv_power_unit_recipe", "electric_wrenches", ElectricToolRecipes.resolveStack(electric_wrench_hv, Material.NULL, Materials.Titanium, 0L, 100000L), ImmutableMap.of((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.WRENCH_BIT, (String)"primary"), (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").itemTags(new TagKey[]{GTCoreTags.POWER_UNIT_HV}).build()), new String[]{"BS", "P "});
        IGTTool buzzsaw_lv = (IGTTool)GTAPI.get(IGTTool.class, (String)"buzzsaw_lv", (String)"gtcore");
        IGTTool buzzsaw_mv = (IGTTool)GTAPI.get(IGTTool.class, (String)"buzzsaw_mv", (String)"gtcore");
        IGTTool buzzsaw_hv = (IGTTool)GTAPI.get(IGTTool.class, (String)"buzzsaw_hv", (String)"gtcore");
        provider.addToolRecipe(ToolTypes.POWERED_TOOL_BUILDER.get(GTCoreTools.BUZZSAW.getId() + "-lv"), output, "gt5r", "", "gt_buzzsaws", ElectricToolRecipes.resolveStack(buzzsaw_lv, Material.NULL, Materials.Aluminium, 0L, 100000L), ImmutableMap.builder().put((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.BUZZSAW_BLADE, (String)"primary")).put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"battery").itemTags(new TagKey[]{GTCoreTags.BATTERIES_LV}).build()).put((Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").mats(new Material[]{Materials.Aluminium}).types(new MaterialTypeItem[]{GTMaterialTypes.PLATE}).build()).put((Object)Character.valueOf('s'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.Aluminium)).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorLV).build(), new String[]{"PbM", "SBG", "sGP"});
        provider.addToolRecipe(ToolTypes.POWERED_TOOL_BUILDER.get(GTCoreTools.BUZZSAW.getId() + "-mv"), output, "gt5r", "", "gt_buzzsaws", ElectricToolRecipes.resolveStack(buzzsaw_mv, Material.NULL, Materials.StainlessSteel, 0L, 200000L), ImmutableMap.builder().put((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.BUZZSAW_BLADE, (String)"primary")).put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"battery").itemTags(new TagKey[]{GTCoreTags.BATTERIES_MV}).build()).put((Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").mats(new Material[]{Materials.StainlessSteel}).types(new MaterialTypeItem[]{GTMaterialTypes.PLATE}).build()).put((Object)Character.valueOf('s'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.StainlessSteel)).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorMV).build(), new String[]{"PbM", "SBG", "sGP"});
        provider.addToolRecipe(ToolTypes.POWERED_TOOL_BUILDER.get(GTCoreTools.BUZZSAW.getId() + "-hv"), output, "gt5r", "", "gt_buzzsaws", ElectricToolRecipes.resolveStack(buzzsaw_hv, Material.NULL, Materials.Titanium, 0L, 800000L), ImmutableMap.builder().put((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.BUZZSAW_BLADE, (String)"primary")).put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"battery").itemTags(new TagKey[]{GTCoreTags.BATTERIES_HV}).build()).put((Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").mats(new Material[]{Materials.Titanium}).types(new MaterialTypeItem[]{GTMaterialTypes.PLATE}).build()).put((Object)Character.valueOf('s'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.Titanium)).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorHV).build(), new String[]{"PbM", "SBG", "sGP"});
        provider.addToolRecipe(ToolTypes.UNIT_POWERED_TOOL_BUILDER.get(GTCoreTools.BUZZSAW.getId() + "-lv"), output, "gt5r", GTCoreTools.BUZZSAW.getId() + "_lv_power_unit_recipe", "gt_buzzsaws", ElectricToolRecipes.resolveStack(buzzsaw_lv, Material.NULL, Materials.Aluminium, 0L, 100000L), ImmutableMap.of((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.BUZZSAW_BLADE, (String)"primary"), (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").itemTags(new TagKey[]{GTCoreTags.POWER_UNIT_LV}).build()), new String[]{"PS", "B "});
        provider.addToolRecipe(ToolTypes.UNIT_POWERED_TOOL_BUILDER.get(GTCoreTools.BUZZSAW.getId() + "-mv"), output, "gt5r", GTCoreTools.BUZZSAW.getId() + "_mv_power_unit_recipe", "gt_buzzsaws", ElectricToolRecipes.resolveStack(buzzsaw_mv, Material.NULL, Materials.StainlessSteel, 0L, 100000L), ImmutableMap.of((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.BUZZSAW_BLADE, (String)"primary"), (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").itemTags(new TagKey[]{GTCoreTags.POWER_UNIT_MV}).build()), new String[]{"PS", "B "});
        provider.addToolRecipe(ToolTypes.UNIT_POWERED_TOOL_BUILDER.get(GTCoreTools.BUZZSAW.getId() + "-hv"), output, "gt5r", GTCoreTools.BUZZSAW.getId() + "_hv_power_unit_recipe", "gt_buzzsaws", ElectricToolRecipes.resolveStack(buzzsaw_hv, Material.NULL, Materials.Titanium, 0L, 100000L), ImmutableMap.of((Object)Character.valueOf('B'), (Object)PropertyIngredient.of((MaterialTypeItem)GTMaterialTypes.BUZZSAW_BLADE, (String)"primary"), (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").itemTags(new TagKey[]{GTCoreTags.POWER_UNIT_HV}).build()), new String[]{"PS", "B "});
        IGTTool electric_screwdriver_lv = (IGTTool)GTAPI.get(IGTTool.class, (String)"electric_screwdriver_lv", (String)"gtcore");
        provider.addToolRecipe(ToolTypes.POWERED_TOOL_BUILDER.get(GTCoreTools.ELECTRIC_SCREWDRIVER.getId() + "-lv"), output, "gt5r", "electric_screwdriver_lv", "gt_electric_screwdrivers", electric_screwdriver_lv.resolveStack(Material.NULL, Materials.Aluminium, 0L, 100000L), ImmutableMap.builder().put((Object)Character.valueOf('R'), (Object)PropertyIngredient.builder((String)"primary").types(new MaterialTypeItem[]{GTMaterialTypes.LONG_ROD}).tool(GTCoreTools.ELECTRIC_SCREWDRIVER, true).build()).put((Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"battery").itemTags(new TagKey[]{GTCoreTags.BATTERIES_LV}).build()).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorLV).put((Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").mats(new Material[]{Materials.Aluminium}).types(new MaterialTypeItem[]{GTMaterialTypes.PLATE}).build()).put((Object)Character.valueOf('S'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.SMALL_GEAR.getMaterialTag(Materials.Aluminium)).put((Object)Character.valueOf('s'), (Object)GTTools.SCREWDRIVER.getTag()).build(), new String[]{"PsR", "MGS", "GbP"});
        provider.addToolRecipe(ToolTypes.UNIT_POWERED_TOOL_BUILDER.get(GTCoreTools.ELECTRIC_SCREWDRIVER.getId() + "-lv"), output, "gt5r", GTCoreTools.ELECTRIC_SCREWDRIVER.getId() + "_power_unit_lv", "gt_electric_screwdrivers", electric_screwdriver_lv.resolveStack(Material.NULL, Materials.Aluminium, 0L, 100000L), ImmutableMap.of((Object)Character.valueOf('R'), (Object)PropertyIngredient.builder((String)"primary").types(new MaterialTypeItem[]{GTMaterialTypes.LONG_ROD}).tool(GTCoreTools.ELECTRIC_SCREWDRIVER, true).build(), (Object)Character.valueOf('S'), (Object)PropertyIngredient.builder((String)"secondary").itemTags(new TagKey[]{GTCoreTags.POWER_UNIT_SMALL}).build(), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()), new String[]{"R ", "WS"});
        IGTTool jackhammer_lv = (IGTTool)GTAPI.get(IGTTool.class, (String)"jackhammer_hv", (String)"gtcore");
        provider.addToolRecipe(ToolTypes.POWERED_TOOL_BUILDER.get(GTCoreTools.JACKHAMMER.getId() + "-hv"), output, "gt5r", "jackhammer_hv", "gt_jackhammers", jackhammer_lv.resolveStack(Material.NULL, Materials.Titanium, 0L, 100000L), ImmutableMap.builder().put((Object)Character.valueOf('R'), (Object)PropertyIngredient.builder((String)"primary").types(new MaterialTypeItem[]{GTMaterialTypes.LONG_ROD}).tool(GTCoreTools.JACKHAMMER, true).build()).put((Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"battery").itemTags(new TagKey[]{GTCoreTags.BATTERIES_HV}).build()).put((Object)Character.valueOf('E'), GT5RItems.PistonHV).put((Object)Character.valueOf('S'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Steel)).put((Object)Character.valueOf('P'), (Object)PropertyIngredient.builder((String)"secondary").mats(new Material[]{Materials.Titanium}).types(new MaterialTypeItem[]{GTMaterialTypes.PLATE}).build()).put((Object)Character.valueOf('T'), (Object)GTMaterialTypes.SPRING.getMaterialTag(Materials.Titanium)).put((Object)Character.valueOf('s'), (Object)GTTools.SCREWDRIVER.getTag()).build(), new String[]{"SRs", "PTP", "EPb"});
        provider.addToolRecipe(ToolTypes.UNIT_POWERED_TOOL_BUILDER.get(GTCoreTools.JACKHAMMER.getId() + "-hv"), output, "gt5r", GTCoreTools.JACKHAMMER.getId() + "_hv_from_pu", "gt_jackhammers", jackhammer_lv.resolveStack(Material.NULL, Materials.Titanium, 0L, 100000L), ImmutableMap.of((Object)Character.valueOf('R'), (Object)PropertyIngredient.builder((String)"primary").types(new MaterialTypeItem[]{GTMaterialTypes.LONG_ROD}).tool(GTCoreTools.JACKHAMMER, true).build(), (Object)Character.valueOf('b'), (Object)PropertyIngredient.builder((String)"secondary").itemTags(new TagKey[]{GTCoreTags.POWER_UNIT_JACKHAMMER}).build(), (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()), new String[]{"RS", "b "});
    }

    public static ItemStack resolveStack(IGTTool tool, Material primary, Material secondary, long startingEnergy, long maxEnergy) {
        ItemStack stack = new ItemStack((ItemLike)tool.getItem());
        tool.validateTag(stack, primary, secondary, startingEnergy, maxEnergy);
        if (!primary.has(new IMaterialTag[]{MaterialTags.TOOLS})) {
            return stack;
        }
        ImmutableMap mainEnchants = ((ToolData)MaterialTags.TOOLS.get(primary)).toolEnchantment();
        if (!mainEnchants.isEmpty()) {
            mainEnchants.entrySet().stream().filter(e -> ((Enchantment)e.getKey()).m_6081_(stack)).forEach(e -> stack.m_41663_((Enchantment)e.getKey(), ((Integer)e.getValue()).intValue()));
        }
        return stack;
    }
}

