/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.integration.tfc.recipes;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Consumer;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.fluids.FlowingFluidRegistryObject;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.ChiselRecipe;
import net.dries007.tfc.util.Metal;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.integration.tfc.finishedrecipes.ChiselFinishedRecipe;
import org.gtreimagined.gt5r.integration.tfc.finishedrecipes.HeatingFinishedRecipe;
import org.gtreimagined.gt5r.integration.tfc.finishedrecipes.QuernFinishedRecipe;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.util.TagUtils;

public class MiscTFCRecipes {
    public static void initRecipes(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider) {
        consumer.accept(new QuernFinishedRecipe(new ResourceLocation("gt5r", "quern/raw_redstone"), Ingredient.m_204132_((TagKey)GTMaterialTypes.RAW_ORE.getMaterialTag(Materials.Redstone)), new ItemStack((ItemLike)Items.f_42451_, 8)));
        consumer.accept(new QuernFinishedRecipe(new ResourceLocation("gt5r", "quern/raw_graphite"), Ingredient.m_204132_((TagKey)GTMaterialTypes.RAW_ORE.getMaterialTag(Materials.Graphite)), new ItemStack((ItemLike)((RegistryObject)TFCItems.POWDERS.get(Powder.GRAPHITE)).get(), 4)));
        for (Ore ore : Ore.values()) {
            if (!ore.isGraded()) continue;
            TFCMetal tfcMetal = MiscTFCRecipes.metalFromOre(ore);
            FlowingFluid fluid = ((FlowingFluidRegistryObject)TFCFluids.METALS.get(tfcMetal.metal)).getSource();
            for (Ore.Grade grade : Ore.Grade.values()) {
                consumer.accept(new HeatingFinishedRecipe(new ResourceLocation("tfc", "heating/ore/" + grade.name().toLowerCase() + "_" + ore.name().toLowerCase()), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)((RegistryObject)((Map)TFCItems.GRADED_ORES.get(ore)).get(grade)).get()}), new FluidStack((Fluid)fluid, grade == Ore.Grade.POOR ? 25 : (grade == Ore.Grade.NORMAL ? 50 : 100)), tfcMetal.temperature));
            }
        }
        consumer.accept(new ChiselFinishedRecipe(new ResourceLocation("gt5r", "chisel/firebricks"), (Block)TFCBlocks.FIRE_BRICKS.get(), (Block)GT5RBlocks.FIRE_BRICKS, ChiselRecipe.Mode.SMOOTH));
        provider.shapeless(consumer, "gt5r", "firebricks", "bricks", new ItemStack((ItemLike)GT5RBlocks.FIRE_BRICKS), new Object[]{TFCBlocks.FIRE_BRICKS.get(), TFCTags.Items.CHISELS});
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)RecipeIngredient.of((ItemLike)((ItemLike)TFCItems.UNFIRED_FIRE_BRICK.get()), (int)1), (ItemLike)((ItemLike)TFCItems.FIRE_BRICK.get()), (float)0.5f, (int)200).m_142284_("has_unfired_fire_brick", provider.hasSafeItem((ItemLike)TFCItems.UNFIRED_FIRE_BRICK.get())).m_176500_(consumer, "gt5r:firebrick");
        provider.addItemRecipe(consumer, "gt5r", "plantball_from_tfc_fruits", "misc", (ItemLike)GTCoreItems.Plantball, ImmutableMap.of((Object)Character.valueOf('C'), (Object)TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "foods/fruits"))), new String[]{"CCC", "C C", "CCC"});
        provider.addItemRecipe(consumer, "gt5r", "plantball_from_tfc_seeds", "misc", (ItemLike)GTCoreItems.Plantball, ImmutableMap.of((Object)Character.valueOf('S'), (Object)TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "seeds"))), new String[]{"SSS", "S S", "SSS"});
        provider.addStackRecipe(consumer, "gt5r", "plantball_from_tfc_saplings", "misc", new ItemStack((ItemLike)GTCoreItems.Plantball, 2), ImmutableMap.of((Object)Character.valueOf('S'), (Object)TagUtils.getItemTag((ResourceLocation)new ResourceLocation("tfc", "saplings"))), new String[]{"SSS", "S S", "SSS"});
    }

    private static TFCMetal metalFromOre(Ore ore) {
        return switch (ore) {
            case Ore.BISMUTHINITE -> TFCMetal.BISMUTH;
            case Ore.HEMATITE, Ore.LIMONITE, Ore.MAGNETITE -> TFCMetal.CAST_IRON;
            case Ore.NATIVE_COPPER, Ore.MALACHITE, Ore.TETRAHEDRITE -> TFCMetal.COPPER;
            case Ore.GARNIERITE -> TFCMetal.NICKEL;
            case Ore.SPHALERITE -> TFCMetal.ZINC;
            case Ore.CASSITERITE -> TFCMetal.TIN;
            case Ore.NATIVE_GOLD -> TFCMetal.GOLD;
            case Ore.NATIVE_SILVER -> TFCMetal.SILVER;
            default -> TFCMetal.UNKNOWN;
        };
    }

    private static enum TFCMetal {
        BISMUTH(Metal.Default.BISMUTH, 270),
        CAST_IRON(Metal.Default.CAST_IRON, 1535),
        COPPER(Metal.Default.COPPER, 1080),
        NICKEL(Metal.Default.NICKEL, 1453),
        ZINC(Metal.Default.ZINC, 420),
        TIN(Metal.Default.TIN, 230),
        GOLD(Metal.Default.GOLD, 1060),
        SILVER(Metal.Default.SILVER, 961),
        UNKNOWN(Metal.Default.UNKNOWN, -1);

        private final Metal.Default metal;
        private final int temperature;

        private TFCMetal(Metal.Default metal, int temperature) {
            this.metal = metal;
            this.temperature = temperature;
        }
    }
}

