/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.gtreimagined.gt5r.cover.CoverConveyor;
import org.gtreimagined.gt5r.cover.ImportExportMode;
import org.gtreimagined.gt5r.cover.RedstoneMode;
import org.gtreimagined.gt5r.cover.base.CoverBasicTransport;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.widget.SyncableTextWidget;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class CoverItemRegulator
extends CoverBasicTransport {
    int slotLimit = 0;
    boolean transferring = false;

    public CoverItemRegulator(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        this.addGuiCallback(t -> {
            t.addButton(52, 53, ButtonOverlay.MINUS, true);
            t.addButton(106, 53, ButtonOverlay.PLUS, true);
            t.addWidget(SyncableTextWidget.build(i -> {
                CoverItemRegulator itemRegulator = (CoverItemRegulator)i;
                if (itemRegulator.slotLimit == 0) {
                    return "N/A";
                }
                return String.valueOf(itemRegulator.slotLimit);
            }, (int)0x404040, (boolean)true).setSize(61, 58, 36, 18));
        });
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverItemRegulator.getBasicDepthModel();
    }

    @Override
    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        super.onGuiEvent(event, playerEntity);
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            GuiEvents.GuiEvent ev = (GuiEvents.GuiEvent)event;
            int button = ev.data[1];
            if (button == 2 && this.slotLimit > 0) {
                --this.slotLimit;
                this.handler.getTile().m_6596_();
            }
            if (button == 3 && this.slotLimit < 64) {
                ++this.slotLimit;
                this.handler.getTile().m_6596_();
            }
        }
    }

    public boolean onTransfer(Object object, boolean inputSide, boolean simulate) {
        if (this.transferring) {
            return false;
        }
        if (object instanceof ItemStack) {
            BlockEntity blockEntity;
            ItemStack stack = (ItemStack)object;
            if (!this.exportMode.isExport() && (blockEntity = this.handler.getTile()) instanceof BlockEntityMachine) {
                BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
                if (inputSide && machine.itemHandler.isPresent()) {
                    if (stack.m_41619_()) {
                        return true;
                    }
                    if (this.slotLimit > 0 && stack.m_41613_() < this.slotLimit) {
                        return true;
                    }
                    this.transferring = true;
                    ItemStack toInsert = this.slotLimit > 0 ? Utils.ca((int)this.slotLimit, (ItemStack)stack) : stack.m_41777_();
                    ItemStack inserted = machine.itemHandler.side(this.side).map(i -> Utils.insertItem((IItemHandler)i, (ItemStack)toInsert, (boolean)true)).orElse(toInsert);
                    if (inserted.m_41619_()) {
                        if (!simulate) {
                            machine.itemHandler.side(this.side).ifPresent(i -> Utils.insertItem((IItemHandler)i, (ItemStack)toInsert, (boolean)false));
                        }
                        stack.m_41764_(0);
                    } else if (inserted.m_41613_() < toInsert.m_41613_()) {
                        if (!simulate) {
                            machine.itemHandler.side(this.side).ifPresent(i -> Utils.insertItem((IItemHandler)i, (ItemStack)toInsert, (boolean)false));
                        }
                        stack.m_41764_(stack.m_41613_() - inserted.m_41613_());
                    }
                    this.transferring = false;
                    return true;
                }
            }
        }
        return false;
    }

    public void onUpdate() {
        boolean isImporting;
        BlockEntityBase base;
        block10: {
            block9: {
                BlockEntity blockEntity;
                if (this.handler.getTile().m_58904_().f_46443_ || !((blockEntity = this.handler.getTile()) instanceof BlockEntityBase)) break block9;
                base = (BlockEntityBase)blockEntity;
                if (this.handler.getTile().m_58904_().m_46467_() % (long)CoverConveyor.speeds.get(this.tier).intValue() == 0L) break block10;
            }
            return;
        }
        BlockState state = this.handler.getTile().m_58904_().m_8055_(this.handler.getTile().m_58899_().m_142300_(this.side));
        if (state == Blocks.f_50016_.m_49966_() && this.exportMode.isExport()) {
            Level world = this.handler.getTile().m_58904_();
            BlockPos pos = this.handler.getTile().m_58899_();
            ItemStack stack = this.handler.getTile().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.side).map(this::extractAny).orElse(ItemStack.f_41583_);
            if (stack.m_41619_()) {
                return;
            }
            world.m_7967_((Entity)new ItemEntity(world, (double)(pos.m_123341_() + this.side.m_122429_()), (double)(pos.m_123342_() + this.side.m_122430_()), (double)(pos.m_123343_() + this.side.m_122431_()), stack));
        }
        if (!state.m_155947_()) {
            return;
        }
        BlockEntity adjTile = base.getCachedBlockEntity(this.side);
        if (adjTile == null) {
            return;
        }
        BlockEntity from = this.handler.getTile();
        BlockEntity to = adjTile;
        Direction fromSide = this.side;
        boolean bl = isImporting = this.exportMode == ImportExportMode.IMPORT || this.exportMode == ImportExportMode.IMPORT_EXPORT;
        if (isImporting) {
            from = adjTile;
            to = this.handler.getTile();
            fromSide = this.side.m_122424_();
        }
        BlockEntity finalTo = to;
        if (this.canMove(this.side)) {
            Direction finalFromSide = fromSide;
            from.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, fromSide).ifPresent(ih -> finalTo.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, finalFromSide.m_122424_()).ifPresent(oh -> {
                Predicate<ItemStack> filter = s -> {
                    if (this.slotLimit == 0) {
                        return true;
                    }
                    if (s.m_41613_() < this.slotLimit) {
                        return false;
                    }
                    s.m_41764_(this.slotLimit);
                    return true;
                };
                Utils.transferItems((IItemHandler)ih, (IItemHandler)oh, (boolean)true, filter);
            }));
        }
    }

    public ItemStack extractAny(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.extractItem(i, this.slotLimit > 0 ? this.slotLimit : 64, true);
            if (stack.m_41619_() || this.slotLimit != 0 && stack.m_41613_() != this.slotLimit) continue;
            handler.extractItem(i, this.slotLimit > 0 ? this.slotLimit : 64, false);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    protected boolean canMove(Direction side) {
        if (this.redstoneMode != RedstoneMode.NO_WORK) {
            boolean powered = this.isPowered(side);
            return this.redstoneMode == RedstoneMode.INVERTED != powered;
        }
        return true;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128405_("slotLimit", this.slotLimit);
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.slotLimit = nbt.m_128451_("slotLimit");
    }
}

