/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.worldgen.OilSpoutEntry;
import org.gtreimagined.gt5r.worldgen.OilSpoutSavedData;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.worldgen.vein.VeinSavedData;
import org.jetbrains.annotations.Nullable;

public class BlockEntitySeismicProspector
extends BlockEntityMachine<BlockEntitySeismicProspector> {
    int progress;
    int maxProgress;
    OilSpoutEntry entry = null;
    Map<Material, LongList> ores;

    public BlockEntitySeismicProspector(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public InteractionResult onInteractServer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable GTToolType type) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_41996_ && stack.m_41613_() >= 4 && this.entry == null) {
            this.maxProgress = 120;
            if (!player.m_7500_()) {
                stack.m_41774_(4);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() == GT5RItems.DataStick && (this.entry != null || this.ores != null)) {
            CompoundTag prospectData = stack.m_41698_("prospectData");
            prospectData.m_128356_("pos", pos.m_121878_());
            prospectData.m_128359_("dimension", this.f_58857_.m_46472_().m_135782_().toString());
            if (this.entry != null) {
                if (this.entry.getFluid() != null) {
                    CompoundTag fluid = new CompoundTag();
                    fluid.m_128359_("name", RegistryUtils.getIdFromFluid((Fluid)this.entry.getFluid().fluid()).toString());
                    fluid.m_128356_("maxYield", (long)this.entry.getFluid().getMaxYield());
                    prospectData.m_128365_("fluid", (Tag)fluid);
                } else {
                    prospectData.m_128379_("no_fluid", true);
                }
            }
            if (this.ores != null && !this.ores.isEmpty()) {
                CompoundTag ores = new CompoundTag();
                this.ores.forEach((m, l) -> {
                    if (!l.isEmpty()) {
                        ListTag positions = new ListTag();
                        l.forEach(l2 -> positions.add((Object)LongTag.m_128882_((long)l2)));
                        ores.m_128365_(m.getId(), (Tag)positions);
                    }
                });
                if (!ores.m_128456_()) {
                    prospectData.m_128365_("ores", (Tag)ores);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.onInteractServer(state, world, pos, player, hand, hit, type);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.maxProgress > 0) {
            if (this.getMachineState() != MachineState.ACTIVE) {
                this.setMachineState(MachineState.ACTIVE);
            }
            if (this.progress < this.maxProgress) {
                ++this.progress;
            } else {
                this.maxProgress = 0;
                this.progress = 0;
                this.setMachineState(MachineState.IDLE);
                ChunkPos pos1 = level.m_46865_(pos).m_7697_();
                this.entry = OilSpoutSavedData.getOrCreate((ServerLevel)level).getFluidVeinWorldEntry(pos1.f_45578_, pos1.f_45579_);
                this.ores = VeinSavedData.getOrCreate((ServerLevel)((ServerLevel)level)).geOresInChunk(pos1.f_45578_, pos1.f_45579_);
            }
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.entry != null) {
            tag.m_128405_("progress", 120);
            tag.m_128405_("maxProgress", 120);
        } else {
            tag.m_128405_("progress", this.progress);
            tag.m_128405_("maxProgress", this.maxProgress);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("progress");
        this.maxProgress = tag.m_128451_("maxProgress");
    }
}

