/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.multi;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.items.ItemTurbineRotor;
import org.gtreimagined.gtlib.block.BlockBasic;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.widget.InfoRenderWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.renderer.IInfoRenderer;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.util.Utils;

public class BlockEntityLargeTurbine
extends BlockEntityMultiMachine<BlockEntityLargeTurbine> {
    protected int baseEfficiency;
    protected int optFlow;
    protected double realOptFlow = 0.0;
    protected long lastEU = 0L;

    public BlockEntityLargeTurbine(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new MachineRecipeHandler<BlockEntityLargeTurbine>(this){
            float water;

            protected boolean validateRecipe(IRecipe r) {
                boolean hasRotor = BlockEntityLargeTurbine.this.itemHandler.map(i -> i.getHandler(SlotType.STORAGE).getStackInSlot(0).m_41720_() instanceof ItemTurbineRotor).orElse(false);
                boolean inputFluids = r.hasInputFluids();
                return hasRotor && inputFluids;
            }

            public void checkRecipe() {
                ItemTurbineRotor rotor1;
                ItemTurbineRotor rotor;
                super.checkRecipe();
                ItemStack stack = BlockEntityLargeTurbine.this.itemHandler.map(i -> i.getHandler(SlotType.STORAGE).getStackInSlot(0)).orElse(ItemStack.f_41583_);
                Item item = stack.m_41720_();
                ItemTurbineRotor itemTurbineRotor = rotor = item instanceof ItemTurbineRotor ? (rotor1 = (ItemTurbineRotor)item) : null;
                if (rotor != null) {
                    BlockEntityLargeTurbine.this.baseEfficiency = (int)(rotor.getEfficiency() * 100.0f);
                    BlockEntityLargeTurbine.this.optFlow = (int)(rotor.getSpeed() * 50.0f);
                } else if (this.lastRecipe != null) {
                    this.resetRecipe();
                }
            }

            public void onMachineEvent(IMachineEvent event, Object ... data) {
                super.onMachineEvent(event, data);
                if (event == SlotType.STORAGE) {
                    ItemTurbineRotor rotor1;
                    ItemTurbineRotor rotor;
                    ItemStack stack = BlockEntityLargeTurbine.this.itemHandler.map(i -> i.getHandler(SlotType.STORAGE).getStackInSlot(0)).orElse(ItemStack.f_41583_);
                    Item item = stack.m_41720_();
                    ItemTurbineRotor itemTurbineRotor = rotor = item instanceof ItemTurbineRotor ? (rotor1 = (ItemTurbineRotor)item) : null;
                    if (rotor == null) {
                        this.resetRecipe();
                        BlockEntityLargeTurbine.this.setMachineState(MachineState.IDLE);
                    } else {
                        this.checkRecipe();
                    }
                }
            }

            public void resetRecipe() {
                super.resetRecipe();
                BlockEntityLargeTurbine.this.baseEfficiency = 0;
                BlockEntityLargeTurbine.this.optFlow = 0;
                BlockEntityLargeTurbine.this.realOptFlow = 0.0;
            }

            public boolean consumeGeneratorInputs(boolean simulate) {
                long newPower = this.fluidIntoPower(BlockEntityLargeTurbine.this.optFlow, BlockEntityLargeTurbine.this.baseEfficiency, simulate);
                if (newPower == 0L) {
                    BlockEntityLargeTurbine.this.lastEU = newPower;
                    return false;
                }
                if (simulate) {
                    return true;
                }
                long difference = newPower - BlockEntityLargeTurbine.this.lastEU;
                int maxChangeAllowed = Math.max(10, (int)Math.ceil((double)Math.abs(difference) * 0.01));
                if (Math.abs(difference) > (long)maxChangeAllowed) {
                    long change = maxChangeAllowed * (difference > 0L ? 1 : -1);
                    BlockEntityLargeTurbine.this.lastEU += change;
                } else {
                    BlockEntityLargeTurbine.this.lastEU = newPower;
                }
                BlockEntityLargeTurbine.this.energyHandler.ifPresent(e -> {
                    if (BlockEntityLargeTurbine.this.lastEU > e.getOutputVoltage()) {
                        BlockEntityLargeTurbine.this.explodeMultiblock();
                        return;
                    }
                    e.insertInternal(BlockEntityLargeTurbine.this.lastEU, false);
                });
                if (BlockEntityLargeTurbine.this.m_58904_() != null && BlockEntityLargeTurbine.this.m_58904_().m_46467_() % 1000L == 0L && BlockEntityLargeTurbine.this.m_58904_().f_46441_.nextInt(2) == 0) {
                    BlockEntityLargeTurbine.this.itemHandler.ifPresent(i -> {
                        ItemStack stack = i.getHandler(SlotType.STORAGE).getStackInSlot(0);
                        ItemStack compare = stack.m_41777_();
                        Item patt6487$temp = stack.m_41720_();
                        if (patt6487$temp instanceof ItemTurbineRotor) {
                            ItemTurbineRotor rotor = (ItemTurbineRotor)patt6487$temp;
                            if (stack.m_41629_(1, BlockEntityLargeTurbine.this.m_58904_().f_46441_, null)) {
                                MaterialTypeItem materialType = rotor.getGTToolType().getMaterialTypeItem();
                                Material material = rotor.getPrimaryMaterial(compare);
                                ItemStack broken = materialType != null && material.has(new IMaterialTag[]{materialType}) ? materialType.get(material, 1) : GTMaterialTypes.LONG_ROD.get(rotor.getRodMaterial(), 1);
                                i.getHandler(SlotType.STORAGE).setStackInSlot(0, broken);
                            }
                        }
                    });
                }
                return true;
            }

            long fluidIntoPower(int aOptFlow, int aBaseEff, boolean simulate) {
                int multiplier;
                int tEU = 0;
                long fuelValue = this.activeRecipe.getPower();
                long actualOptimalFlow = ((BlockEntityLargeTurbine)this.tile).getMachineTier() == Tier.EV ? (long)aOptFlow / fuelValue : (long)aOptFlow;
                long totalFlow = 0L;
                int flow = 0;
                int remainingFlow = (int)((float)actualOptimalFlow * 1.25f);
                BlockEntityLargeTurbine.this.realOptFlow = ((BlockEntityLargeTurbine)this.tile).getMachineTier() == Tier.HV ? (double)(actualOptimalFlow / 2L) / 0.5 : (double)actualOptimalFlow;
                MachineFluidHandler handler = (MachineFluidHandler)BlockEntityLargeTurbine.this.fluidHandler.orElse(null);
                if (handler == null) {
                    return 0L;
                }
                boolean empty = true;
                for (int i = 0; i < handler.getInputTanks().getTanks() && remainingFlow > 0; ++i) {
                    FluidStack fluidHolder = handler.getInputTanks().getFluidInTank(i);
                    if (!((FluidIngredient)this.activeRecipe.getInputFluids().get(0)).matches(fluidHolder)) continue;
                    flow = fluidHolder.getAmount();
                    flow = Math.min(flow, Math.min(remainingFlow, (int)((float)actualOptimalFlow * 1.25f)));
                    if (!simulate) {
                        handler.getInputTanks().drain(Utils.ca((int)flow, (FluidStack)fluidHolder), IFluidHandler.FluidAction.EXECUTE);
                    }
                    remainingFlow -= flow;
                    totalFlow += (long)flow;
                    empty = false;
                }
                if (empty) {
                    return 0L;
                }
                tEU = (int)Math.min((float)actualOptimalFlow, (float)totalFlow);
                if (((BlockEntityLargeTurbine)this.tile).getMachineTier() != Tier.EV) {
                    FluidStack fluid;
                    int waterToOutput = ((BlockEntityLargeTurbine)this.tile).getMachineTier() == Tier.HV ? this.useWater((float)totalFlow / 160.0f) : (int)totalFlow;
                    FluidStack fluidStack = fluid = ((BlockEntityLargeTurbine)this.tile).getMachineTier() == Tier.HV ? Materials.DistilledWater.getLiquid(waterToOutput) : Materials.Steam.getGas(waterToOutput);
                    if (!simulate) {
                        handler.fillOutput(fluid, IFluidHandler.FluidAction.EXECUTE);
                    }
                } else {
                    tEU = (int)((long)tEU * fuelValue);
                }
                int n = multiplier = ((BlockEntityLargeTurbine)this.tile).getMachineTier() == Tier.HV ? 2 : 1;
                if ((totalFlow > 0L || ((BlockEntityLargeTurbine)this.tile).getMachineTier() == Tier.EV) && totalFlow != actualOptimalFlow) {
                    float efficiency = 1.0f - Math.abs(((float)totalFlow - (float)actualOptimalFlow) / (float)actualOptimalFlow);
                    if (totalFlow > actualOptimalFlow) {
                        efficiency = 1.0f;
                    }
                    if (efficiency < 0.0f) {
                        efficiency = 0.0f;
                    }
                    tEU = (int)((float)tEU * efficiency);
                    tEU = Math.max(1, (int)((long)tEU * (long)aBaseEff / (10000L * (long)multiplier)));
                } else {
                    tEU = (int)((long)tEU * (long)aBaseEff / (10000L * (long)multiplier));
                }
                return tEU;
            }

            private int useWater(float input) {
                this.water += input;
                int usage = (int)this.water;
                this.water -= (float)usage;
                return usage;
            }
        });
    }

    public BlockBasic getCasing() {
        if (this.tier == Tier.HV) {
            return GT5RBlocks.STEEL_TURBINE_CASING;
        }
        if (this.tier == Tier.EV) {
            return GT5RBlocks.STAINLESS_STEEL_TURBINE_CASING;
        }
        return GT5RBlocks.TITANIUM_TURBINE_CASING;
    }

    public BlockBasic getHatchBlock(BlockPos pos) {
        return this.getCasing();
    }

    public int drawInfo(InfoRenderWidget.MultiRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        int size = super.drawInfo(instance, stack, renderer, left, top);
        if (this.getMachineState() == MachineState.ACTIVE) {
            LargeTurbineWidget wid = (LargeTurbineWidget)instance;
            renderer.m_92883_(stack, "Current: " + wid.currentConsumption + " mb/t", (float)left, (float)(top + size), 0xFAFAFF);
            renderer.m_92883_(stack, "Optimal: " + wid.recommendedConsumption + " mb/t", (float)left, (float)(top + size + 8), 0xFAFAFF);
            renderer.m_92883_(stack, "EU generation: " + wid.lastEU, (float)left, (float)(top + size + 16), 0xFAFAFF);
            return size + 24;
        }
        return size;
    }

    public WidgetSupplier getInfoWidget() {
        return LargeTurbineWidget.build().setPos(10, 10);
    }

    public static class LargeTurbineWidget
    extends InfoRenderWidget.MultiRenderWidget {
        public long currentConsumption = 0L;
        public long lastEU = 0L;
        public long recommendedConsumption = 0L;

        protected LargeTurbineWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<InfoRenderWidget.MultiRenderWidget> renderer) {
            super(gui, parent, renderer);
        }

        public void init() {
            super.init();
            BlockEntityLargeTurbine turbine = (BlockEntityLargeTurbine)this.gui.handler;
            this.gui.syncLong(() -> (long)turbine.realOptFlow, i -> {
                this.currentConsumption = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncLong(() -> turbine.optFlow, i -> {
                this.recommendedConsumption = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncLong(() -> turbine.lastEU, i -> {
                this.lastEU = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return LargeTurbineWidget.builder((a, b) -> new LargeTurbineWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer<InfoRenderWidget.MultiRenderWidget>)((IInfoRenderer)a.handler)));
        }

        public boolean drawActiveInfo() {
            return false;
        }
    }
}

