/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.definitions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.context.CompilingPackage;
import org.openzen.zenscript.codemodel.context.CompilingType;
import org.openzen.zenscript.codemodel.context.LocalTypeResolutionContext;
import org.openzen.zenscript.codemodel.context.TypeResolutionContext;
import org.openzen.zenscript.codemodel.scope.BaseScope;
import org.openzen.zenscript.codemodel.scope.DefinitionScope;
import org.openzen.zenscript.parser.ParsedAnnotation;
import org.openzen.zenscript.parser.ParsedDefinition;
import org.openzen.zenscript.parser.PrecompilationState;
import org.openzen.zenscript.parser.member.ParsedDefinitionMember;

public abstract class BaseParsedDefinition
extends ParsedDefinition {
    protected final List<ParsedDefinitionMember> members = new ArrayList<ParsedDefinitionMember>();
    private final Map<String, ParsedDefinition> innerTypes = new HashMap<String, ParsedDefinition>();
    private boolean typesCompiled = false;
    private boolean isCompiled = false;

    public BaseParsedDefinition(CodePosition position, int modifiers, CompilingPackage pkg, ParsedAnnotation[] annotations) {
        super(position, modifiers, pkg, annotations);
    }

    public void addMember(ParsedDefinitionMember member) {
        this.members.add(member);
        member.registerInnerTypes(this.innerTypes);
    }

    @Override
    public void linkTypes(TypeResolutionContext context) {
        if (this.typesCompiled) {
            return;
        }
        this.typesCompiled = true;
        this.linkTypesLocal(context);
    }

    protected void linkTypesLocal(TypeResolutionContext localContext) {
        for (ParsedDefinitionMember member : this.members) {
            member.linkTypes(localContext);
            this.getCompiled().addMember(member.getCompiled());
        }
    }

    @Override
    public void registerMembers(BaseScope scope, PrecompilationState state) {
        DefinitionScope innerScope = new DefinitionScope(scope, this.getCompiled());
        for (ParsedDefinitionMember member : this.members) {
            state.register(innerScope, member);
            member.registerMembers(innerScope, state);
        }
    }

    @Override
    public void compile(BaseScope scope) throws CompileException {
        if (this.isCompiled) {
            return;
        }
        this.isCompiled = true;
        this.getCompiled().annotations = ParsedAnnotation.compileForDefinition(this.annotations, this.getCompiled(), scope);
        DefinitionScope innerScope = new DefinitionScope(scope, this.getCompiled());
        for (ParsedDefinitionMember member : this.members) {
            member.compile(innerScope);
        }
    }

    @Override
    public CompilingType getCompiling(TypeResolutionContext context) {
        return new Compiling(context);
    }

    private class Compiling
    implements CompilingType {
        private final TypeResolutionContext context;

        private Compiling(TypeResolutionContext context) {
            this.context = new LocalTypeResolutionContext(context, this, BaseParsedDefinition.this.getCompiled().typeParameters);
        }

        @Override
        public HighLevelDefinition load() {
            BaseParsedDefinition.this.linkTypes(this.context);
            return BaseParsedDefinition.this.getCompiled();
        }

        @Override
        public CompilingType getInner(String name) {
            if (!BaseParsedDefinition.this.innerTypes.containsKey(name)) {
                return null;
            }
            return BaseParsedDefinition.this.innerTypes.get(name).getCompiling(this.context);
        }
    }
}

