/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.replacement.rule;

import com.blamejared.crafttweaker.api.recipe.handler.ITargetingRule;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;

public final class ExcludingModsAndDelegatingTargetingRule
implements ITargetingRule {
    private final ITargetingRule delegate;
    private final Collection<String> exclusions;

    private ExcludingModsAndDelegatingTargetingRule(ITargetingRule delegate, Collection<String> exclusions) {
        this.delegate = delegate;
        this.exclusions = exclusions;
    }

    public static ExcludingModsAndDelegatingTargetingRule of(ITargetingRule delegate, Collection<String> exclusions) {
        Objects.requireNonNull(delegate);
        if (exclusions.isEmpty()) {
            throw new IllegalArgumentException("Unable to create an exclusion for mods without any mods to exclude");
        }
        if (delegate instanceof ExcludingModsAndDelegatingTargetingRule) {
            ExcludingModsAndDelegatingTargetingRule delegatingRule = (ExcludingModsAndDelegatingTargetingRule)delegate;
            return ExcludingModsAndDelegatingTargetingRule.of(delegatingRule.delegate, (Collection)Util.m_137469_(new HashSet<String>(exclusions), it -> it.addAll(delegatingRule.exclusions)));
        }
        return new ExcludingModsAndDelegatingTargetingRule(delegate, exclusions);
    }

    public static ExcludingModsAndDelegatingTargetingRule of(ITargetingRule delegate, String ... exclusions) {
        return ExcludingModsAndDelegatingTargetingRule.of(delegate, new HashSet<String>(Arrays.asList(exclusions)));
    }

    public static ExcludingModsAndDelegatingTargetingRule of(ITargetingRule delegate, Recipe ... exclusions) {
        return ExcludingModsAndDelegatingTargetingRule.of(delegate, Arrays.stream(exclusions).map(Recipe::m_6423_).map(ResourceLocation::m_135827_).collect(Collectors.toSet()));
    }

    @Override
    public boolean shouldBeReplaced(Recipe<?> recipe, IRecipeManager<?> manager) {
        return !this.exclusions.contains(recipe.m_6423_().m_135827_()) && this.delegate.shouldBeReplaced(recipe, manager);
    }

    @Override
    public String describe() {
        return String.format("%s, but excluding mods {%s}", this.delegate.describe(), String.join((CharSequence)", ", this.exclusions));
    }
}

