/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientEmpty;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientList;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientCraftTweakerBase;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientSingleton;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.expand.ExpandItemTag;
import com.blamejared.crafttweaker.mixin.common.access.item.AccessIngredient;
import com.blamejared.crafttweaker.mixin.common.access.item.AccessIngredientTagValue;
import com.blamejared.crafttweaker.platform.Services;
import java.util.Arrays;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientConverter {
    public static IIngredient fromIngredient(Ingredient ingredient) {
        Ingredient ingredient2 = ingredient;
        if (ingredient2 instanceof IngredientCraftTweakerBase) {
            IngredientCraftTweakerBase base = (IngredientCraftTweakerBase)ingredient2;
            return base.getCrTIngredient();
        }
        ingredient2 = ingredient;
        if (ingredient2 instanceof IngredientSingleton) {
            IngredientSingleton single = (IngredientSingleton)ingredient2;
            return single.getInstance();
        }
        if (ingredient == Ingredient.f_43901_) {
            return IngredientConverter.empty();
        }
        return IngredientConverter.fromIItemLists(((AccessIngredient)ingredient).crafttweaker$getValues());
    }

    private static IIngredient fromIItemLists(Ingredient.Value ... itemLists) {
        IIngredient[] ingredients = (IIngredient[])Arrays.stream(itemLists).map(IngredientConverter::fromIItemList).filter(IngredientConverter::notEmptyStack).toArray(IIngredient[]::new);
        return IngredientConverter.mergeIngredients(ingredients);
    }

    private static IIngredient fromIItemList(Ingredient.Value value) {
        if (value instanceof Ingredient.TagValue) {
            return IngredientConverter.fromTagList((Ingredient.TagValue)value);
        }
        IIngredient[] ingredients = (IItemStack[])value.m_6223_().stream().filter(stack -> !stack.m_41619_()).map(Services.PLATFORM::createMCItemStack).toArray(IItemStack[]::new);
        return IngredientConverter.mergeIngredients(ingredients);
    }

    private static IIngredient fromTagList(Ingredient.TagValue value) {
        ResourceLocation location = ((AccessIngredientTagValue)value).crafttweaker$getTag().f_203868_();
        return CraftTweakerTagRegistry.INSTANCE.findKnownManager(Registry.f_122904_).map(mcTags -> mcTags.tag(location)).map(ExpandItemTag::asIIngredient).orElseThrow(() -> new RuntimeException("Error while converting ingredient: '" + value + "' to an IIngredient!"));
    }

    private static IIngredient empty() {
        return IIngredientEmpty.INSTANCE;
    }

    private static IIngredient mergeIngredients(IIngredient ... ingredients) {
        if (ingredients.length == 0) {
            return IngredientConverter.empty();
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        return new IIngredientList(ingredients);
    }

    private static boolean notEmptyStack(IIngredient iIngredient) {
        return !(iIngredient instanceof IItemStack) || !((IItemStack)iIngredient).isEmpty();
    }
}

