/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.recipe.replace;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.action.recipe.replace.ActionReplaceRecipe;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.handler.ITargetingRule;
import com.blamejared.crafttweaker.api.recipe.manager.GenericRecipesManager;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.replacement.rule.SpecificRecipesTargetingRule;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.Logger;

public final class ReplacerAction
implements IRuntimeAction {
    private final ITargetingRule targetingRule;
    private final boolean isSimple;
    private final List<IReplacementRule> replacementRules;
    private final Collection<ResourceLocation> defaultExclusions;
    private final Function<ResourceLocation, ResourceLocation> generatorFunction;
    private final boolean suppressWarnings;

    public ReplacerAction(ITargetingRule targetingRule, boolean isSimple, List<IReplacementRule> replacementRules, Collection<ResourceLocation> defaultExclusions, Function<ResourceLocation, ResourceLocation> generatorFunction, boolean suppressWarnings) {
        this.targetingRule = targetingRule;
        this.isSimple = isSimple;
        this.replacementRules = replacementRules;
        this.defaultExclusions = ReplacerAction.filter(targetingRule, defaultExclusions);
        this.generatorFunction = generatorFunction;
        this.suppressWarnings = suppressWarnings;
    }

    private static Collection<ResourceLocation> filter(ITargetingRule rule, Collection<ResourceLocation> fullExclusions) {
        Map<ResourceLocation, Recipe<?>> map = GenericRecipesManager.INSTANCE.getRecipeMap();
        return (Collection)Util.m_137469_(new HashSet<ResourceLocation>(fullExclusions), set -> set.removeIf(it -> {
            Recipe recipe = (Recipe)map.get(it);
            return recipe == null || !rule.shouldBeReplaced(recipe, RecipeTypeBracketHandler.getOrDefault(recipe.m_6671_()));
        }));
    }

    @Override
    public void apply() {
        this.specificRecipesOrElse(GenericRecipesManager.INSTANCE::getAllRecipes).stream().filter(it -> !this.defaultExclusions.contains(it.m_6423_())).map(it -> Pair.of((Object)it, RecipeTypeBracketHandler.getOrDefault(it.m_6671_()))).filter(pair -> this.targetingRule.shouldBeReplaced((Recipe)pair.getFirst(), (IRecipeManager)pair.getSecond())).map(pair -> this.execute((IRecipeManager)pair.getSecond(), (Recipe)pair.getFirst(), this.replacementRules)).filter(Optional::isPresent).map(Optional::get).forEach(CraftTweakerAPI::apply);
        CraftTweakerAPI.LOGGER.info("Batch replacement completed");
    }

    @Override
    public String describe() {
        return String.format("Batching%s replacement for %s according to replacement rules %s%s%s", this.stringifySimplicity(), this.stringifyTargets(), this.stringifyReplacementRules(), this.stringifyExclusionsIfPresent(), this.stringifySuppressWarnings());
    }

    @Override
    public boolean validate(Logger logger) {
        if (this.replacementRules.isEmpty()) {
            logger.error("Invalid replacer action: no rules available");
            return false;
        }
        return true;
    }

    private Collection<Recipe<?>> specificRecipesOrElse(Supplier<Collection<Recipe<?>>> ifComplex) {
        return this.isSimple ? ((SpecificRecipesTargetingRule)this.targetingRule).recipes() : ifComplex.get();
    }

    private String stringifySimplicity() {
        return this.isSimple ? " simple" : "";
    }

    private String stringifyTargets() {
        return this.targetingRule.describe();
    }

    private String stringifyReplacementRules() {
        return this.replacementRules.stream().map(IReplacementRule::describe).collect(Collectors.joining(", ", "{", "}"));
    }

    private String stringifyExclusionsIfPresent() {
        if (this.defaultExclusions.isEmpty()) {
            return "";
        }
        return ", while also automatically excluding {" + this.stringifyDefaultExclusionsIfPresent() + "} due to mod requests";
    }

    private String stringifyDefaultExclusionsIfPresent() {
        return this.defaultExclusions.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
    }

    private String stringifySuppressWarnings() {
        return this.suppressWarnings ? " (Warnings are suppressed for this batch replacement)" : "";
    }

    private <T extends Container, U extends Recipe<T>> Optional<ActionReplaceRecipe<?>> execute(IRecipeManager<?> manager, U recipe, List<IReplacementRule> rules) {
        try {
            IRecipeHandler<U> handler = IRecipeHandlerRegistry.getHandlerFor(recipe);
            Optional newRecipeMaybe = handler.replaceIngredients(manager, recipe, rules);
            if (newRecipeMaybe.isPresent()) {
                return Optional.of(new ActionReplaceRecipe<Recipe>(manager, this.generatorFunction, recipe, name -> (Recipe)((Function)newRecipeMaybe.get()).apply(name)));
            }
        }
        catch (IRecipeHandler.ReplacementNotSupportedException e) {
            if (!this.suppressWarnings) {
                CraftTweakerAPI.LOGGER.warn("Unable to replace ingredients in recipe {}: {}", (Object)recipe.m_6423_(), (Object)e.getMessage());
            }
        }
        catch (Throwable t) {
            CraftTweakerAPI.LOGGER.error("An error has occurred while trying to replace ingredients in recipe {}", (Object)recipe.m_6423_(), (Object)t);
        }
        return Optional.empty();
    }
}

