/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.brewing;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.brewing.ActionBrewingBase;
import com.blamejared.crafttweaker.mixin.common.access.brewing.AccessPotionBrewing;
import com.blamejared.crafttweaker.natives.item.alchemy.ExpandPotion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.registries.IRegistryDelegate;

public class ActionRemoveBrewingRecipeByPotionInput
extends ActionBrewingBase {
    private final List<PotionBrewing.Mix<Potion>> removed = new ArrayList<PotionBrewing.Mix<Potion>>();
    private final Potion input;

    public ActionRemoveBrewingRecipeByPotionInput(List<IBrewingRecipe> recipes, Potion input) {
        super(recipes);
        this.input = input;
    }

    @Override
    public void apply() {
        Iterator<PotionBrewing.Mix<Potion>> iterator = AccessPotionBrewing.crafttweaker$getPOTION_MIXES().iterator();
        while (iterator.hasNext()) {
            PotionBrewing.Mix<Potion> mix = iterator.next();
            IRegistryDelegate potionInput = mix.f_43532_;
            if (potionInput == null) {
                throw new RuntimeException("Error getting potion from mix: " + mix + "! Please make an issue on the issue tracker!");
            }
            if (!((Potion)potionInput.get()).getRegistryName().equals((Object)this.input.getRegistryName())) continue;
            this.removed.add(mix);
            iterator.remove();
        }
    }

    @Override
    public void undo() {
        for (PotionBrewing.Mix<Potion> potion : this.removed) {
            Ingredient itemReagent = potion.f_43533_;
            IRegistryDelegate potionOutput = potion.f_43534_;
            if (potion.f_43532_ == null || itemReagent == null || potionOutput == null) {
                CraftTweakerAPI.LOGGER.error("Error getting mix entries! potionInput: {}, itemReagent: {}, potionOutput: {}", (Object)potion.f_43532_, (Object)itemReagent, (Object)potionOutput);
                continue;
            }
            AccessPotionBrewing.crafttweaker$callAddMix((Potion)potion.f_43532_.get(), itemReagent.m_43908_()[0].m_41720_(), (Potion)potionOutput.get());
        }
    }

    @Override
    public String describe() {
        return "Removing Brewing recipes that have an input of: " + ExpandPotion.getCommandString(this.input);
    }

    @Override
    public String describeUndo() {
        return "Undoing removal of Brewing recipes that have an input of: " + ExpandPotion.getCommandString(this.input);
    }
}

