/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.simple;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.api.simple.ConfigProperty;
import com.mrcrayfish.configured.api.simple.SimpleConfig;
import com.mrcrayfish.configured.api.simple.SimpleProperty;
import com.mrcrayfish.configured.api.simple.event.SimpleConfigEvent;
import com.mrcrayfish.configured.client.SessionData;
import com.mrcrayfish.configured.impl.simple.SimpleFolderEntry;
import com.mrcrayfish.configured.impl.simple.SimpleValue;
import com.mrcrayfish.configured.network.HandshakeMessages;
import com.mrcrayfish.configured.network.PacketHandler;
import com.mrcrayfish.configured.network.message.MessageRequestSimpleConfig;
import com.mrcrayfish.configured.network.message.MessageResponseSimpleConfig;
import com.mrcrayfish.configured.network.message.MessageSyncSimpleConfig;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.Type;

public class SimpleConfigManager {
    private static final Predicate<String> NAME_PATTERN = Pattern.compile("^[a-z_]+$").asMatchPredicate();
    private static final LevelResource WORLD_CONFIG = new LevelResource("serverconfig");
    private static final Type SIMPLE_CONFIG = Type.getType(SimpleConfig.class);
    private static SimpleConfigManager instance;
    private final Map<ResourceLocation, SimpleConfigImpl> configs;

    public static SimpleConfigManager getInstance() {
        if (instance == null) {
            instance = new SimpleConfigManager();
        }
        return instance;
    }

    private SimpleConfigManager() {
        HashMap configs = new HashMap();
        SimpleConfigManager.getAllSimpleConfigs().forEach(pair -> {
            ConfigScanData data = ConfigScanData.analyze((SimpleConfig)pair.getLeft(), pair.getRight());
            SimpleConfigImpl entry = new SimpleConfigImpl(data);
            configs.put(entry.getName(), entry);
        });
        this.configs = ImmutableMap.copyOf(configs);
    }

    public List<SimpleConfigImpl> getConfigs() {
        return ImmutableList.copyOf(this.configs.values());
    }

    @Nullable
    public SimpleConfigImpl getConfig(ResourceLocation id) {
        return this.configs.get(id);
    }

    public List<Pair<String, HandshakeMessages.S2CConfigData>> getMessagesForLogin(boolean local) {
        if (local) {
            return Collections.emptyList();
        }
        return this.configs.values().stream().filter(entry -> entry.getType().isSync()).map(entry -> {
            ResourceLocation key = entry.getName();
            byte[] data = ConfigHelper.getBytes(entry.config);
            return Pair.of((Object)("SimpleConfig " + key), (Object)new HandshakeMessages.S2CConfigData(key, data));
        }).collect(Collectors.toList());
    }

    public boolean processConfigData(HandshakeMessages.S2CConfigData message) {
        Configured.LOGGER.info("Loading synced config from server: " + message.getKey());
        SimpleConfigImpl entry = this.configs.get(message.getKey());
        if (entry != null && entry.getType().isSync()) {
            return entry.loadFromData(message.getData());
        }
        return false;
    }

    public boolean processSyncData(MessageSyncSimpleConfig message, boolean server) {
        SimpleConfigImpl simpleConfig = this.configs.get(message.id());
        if (simpleConfig == null) {
            Configured.LOGGER.error("No simple config exists for the id: {}", (Object)message.id());
            return false;
        }
        if (server) {
            if (!simpleConfig.getType().isServer()) {
                Configured.LOGGER.error("Received sync update for incorrect config: {}", (Object)message.id());
                return false;
            }
        } else if (!simpleConfig.getType().isSync()) {
            Configured.LOGGER.error("Received sync update for a non-sync config: {}", (Object)message.id());
            return false;
        }
        if (simpleConfig.isReadOnly() || !simpleConfig.isLoaded()) {
            Configured.LOGGER.error("Received sync update for incorrect config: {}", (Object)message.id());
            return false;
        }
        try {
            CommentedConfig config = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(message.data()));
            if (!simpleConfig.isCorrect((UnmodifiableConfig)config)) {
                Configured.LOGGER.error("Received incorrect config data");
                return false;
            }
            UnmodifiableConfig unmodifiableConfig = simpleConfig.config;
            if (unmodifiableConfig instanceof Config) {
                Config c = (Config)unmodifiableConfig;
                c.putAll((UnmodifiableConfig)config);
                simpleConfig.allProperties.forEach(ConfigProperty::invalidateCache);
                simpleConfig.sendEvent(new SimpleConfigEvent.Reload(simpleConfig.source));
                Configured.LOGGER.debug("Successfully processed sync update for config: {}", (Object)message.id());
                return true;
            }
        }
        catch (ParsingException e) {
            Configured.LOGGER.error("Received malformed config data");
        }
        catch (Exception e) {
            Configured.LOGGER.error("An exception was thrown when processing config data: {}", (Object)e.toString());
        }
        return false;
    }

    public boolean processResponseData(MessageResponseSimpleConfig message) {
        Configured.LOGGER.debug("Processing Loading config from server: " + message.id());
        SimpleConfigImpl entry = this.configs.get(message.id());
        if (entry != null && entry.getType().isServer() && entry.getType() != ConfigType.DEDICATED_SERVER) {
            return entry.loadFromData(message.data());
        }
        return false;
    }

    public void onClientDisconnect(@Nullable Connection connection) {
        if (connection != null && !connection.m_129531_()) {
            Configured.LOGGER.info("Unloading synced configs from server");
            this.configs.values().stream().filter(entry -> entry.getType().isSync()).forEach(entry -> entry.unload(true));
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerAboutToStartEvent event) {
        Configured.LOGGER.info("Loading server configs...");
        Path serverConfig = event.getServer().m_129843_(WORLD_CONFIG);
        FileUtils.getOrCreateDirectory((Path)serverConfig, (String)"serverconfig");
        this.configs.values().forEach(entry -> {
            switch (entry.configType) {
                case WORLD: 
                case WORLD_SYNC: {
                    entry.load(serverConfig);
                    break;
                }
                case SERVER: 
                case SERVER_SYNC: {
                    entry.load(FMLPaths.CONFIGDIR.get());
                    break;
                }
                case DEDICATED_SERVER: {
                    if (!FMLEnvironment.dist.isDedicatedServer()) break;
                    entry.load(FMLPaths.CONFIGDIR.get());
                }
            }
        });
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        Configured.LOGGER.info("Unloading server configs...");
        this.configs.values().stream().filter(entry -> entry.configType.isServer()).forEach(entry -> entry.unload(true));
    }

    private static boolean isValidSeparator(char c) {
        return c == '.' || c == '-';
    }

    public static List<Pair<SimpleConfig, Object>> getAllSimpleConfigs() {
        List<ModFileScanData.AnnotationData> annotations = ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> SIMPLE_CONFIG.equals((Object)a.annotationType())).toList();
        ArrayList<Pair<SimpleConfig, Object>> configs = new ArrayList<Pair<SimpleConfig, Object>>();
        annotations.forEach(data -> {
            try {
                Class<?> configClass = Class.forName(data.clazz().getClassName());
                Field field = configClass.getDeclaredField(data.memberName());
                field.setAccessible(true);
                Object object = field.get(null);
                Optional.ofNullable(field.getDeclaredAnnotation(SimpleConfig.class)).ifPresent(simpleConfig -> configs.add(Pair.of((Object)simpleConfig, (Object)object)));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        });
        return configs;
    }

    public static CommentedConfig createSimpleConfig(@Nullable Path folder, String id, char separator, String name) {
        if (folder != null) {
            String fileName = String.format("%s%s%s.toml", id, Character.valueOf(separator), name);
            File file = new File(folder.toFile(), fileName);
            return (CommentedConfig)CommentedFileConfig.builder((File)file).autosave().sync().onFileNotFound((file1, configFormat) -> SimpleConfigManager.initConfig(file1, configFormat, fileName)).build();
        }
        return CommentedConfig.inMemory();
    }

    public static UnmodifiableCommentedConfig createReadOnlyConfig(Path folder, String id, char separator, String name, Consumer<Config> corrector) {
        CommentedFileConfig temp = SimpleConfigManager.createTempConfig(folder, id, separator, name);
        ConfigHelper.loadConfig((UnmodifiableConfig)temp);
        corrector.accept((Config)temp);
        CommentedConfig config = CommentedConfig.inMemory();
        config.putAll((UnmodifiableConfig)temp);
        ConfigHelper.closeConfig((UnmodifiableConfig)temp);
        return config.unmodifiable();
    }

    public static CommentedFileConfig createTempConfig(Path folder, String id, char separator, String name) {
        String fileName = String.format("%s%s%s.toml", id, Character.valueOf(separator), name);
        File file = new File(folder.toFile(), fileName);
        return (CommentedFileConfig)CommentedFileConfig.builder((File)file).sync().onFileNotFound((file1, configFormat) -> SimpleConfigManager.initConfig(file1, configFormat, fileName)).build();
    }

    private static boolean initConfig(Path file, ConfigFormat<?> format, String fileName) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Path defaultConfigPath = FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath());
        Path defaultConfigFile = defaultConfigPath.resolve(fileName);
        if (Files.exists(defaultConfigFile, new LinkOption[0])) {
            Files.copy(defaultConfigFile, file, new CopyOption[0]);
            return true;
        }
        Files.createFile(file, new FileAttribute[0]);
        format.initEmptyFile(file);
        return false;
    }

    public static ConfigSpec createSpec(Set<ConfigProperty<?>> properties) {
        ConfigSpec spec = new ConfigSpec();
        properties.forEach(p -> p.defineSpec(spec));
        return spec;
    }

    public static CommentedConfig createComments(ConfigSpec spec, Map<List<String>, String> comments) {
        CommentedConfig config = CommentedConfig.inMemory();
        spec.correct((Config)config);
        comments.forEach((arg_0, arg_1) -> ((CommentedConfig)config).setComment(arg_0, arg_1));
        return config;
    }

    public static final class SimpleConfigImpl
    implements IModConfig {
        private final Object source;
        private final String id;
        private final String name;
        private final boolean readOnly;
        private final char separator;
        private final ConfigType configType;
        private final Set<ConfigProperty<?>> allProperties;
        private final PropertyMap propertyMap;
        private final ConfigSpec spec;
        private final ClassLoader classLoader;
        private final CommentedConfig comments;
        @Nullable
        private UnmodifiableConfig config;

        private SimpleConfigImpl(ConfigScanData data) {
            Preconditions.checkArgument((!data.getConfig().id().trim().isEmpty() ? 1 : 0) != 0, (Object)"The 'id' of the config cannot be empty");
            Preconditions.checkArgument((boolean)ModList.get().isLoaded(data.getConfig().id()), (Object)"The 'id' of the config must match a mod id");
            Preconditions.checkArgument((!data.getConfig().name().trim().isEmpty() ? 1 : 0) != 0, (Object)"The 'name' of the config cannot be empty");
            Preconditions.checkArgument((data.getConfig().name().length() <= 64 ? 1 : 0) != 0, (Object)"The 'name' of the config must be 64 characters or less");
            Preconditions.checkArgument((boolean)NAME_PATTERN.test(data.getConfig().name()), (Object)"The 'name' of the config is invalid. It can only contain 'a-z' and '_'");
            Preconditions.checkArgument((boolean)SimpleConfigManager.isValidSeparator(data.getConfig().separator()), (Object)"The 'separator' of the config is invalid. It can only be '.' or '-'");
            this.source = data.getSource();
            this.id = data.getConfig().id();
            this.name = data.getConfig().name();
            this.readOnly = data.getConfig().readOnly();
            this.configType = data.getConfig().type();
            this.separator = data.getConfig().separator();
            this.allProperties = ImmutableSet.copyOf(data.getProperties());
            this.propertyMap = new PropertyMap(this.allProperties);
            this.spec = SimpleConfigManager.createSpec(this.allProperties);
            this.comments = SimpleConfigManager.createComments(this.spec, data.getComments());
            this.classLoader = Thread.currentThread().getContextClassLoader();
            if (!this.configType.isServer()) {
                if (this.configType == ConfigType.MEMORY) {
                    this.load(null);
                } else {
                    this.load(FMLPaths.CONFIGDIR.get());
                }
            }
        }

        private void load(@Nullable Path configDir) {
            Optional<Dist> dist = this.getType().getDist();
            if (dist.isPresent() && !FMLEnvironment.dist.equals((Object)dist.get())) {
                return;
            }
            Preconditions.checkState((this.config == null ? 1 : 0) != 0, (Object)"Config is already loaded. Unload before loading again.");
            UnmodifiableConfig config = this.createConfig(configDir);
            ConfigHelper.loadConfig(config);
            this.correct(config);
            this.allProperties.forEach(p -> p.updateProxy(new ValueProxy(config, p.getPath(), this.readOnly)));
            this.config = config;
            ConfigHelper.watchConfig(config, this::changeCallback);
            this.sendEvent(new SimpleConfigEvent.Load(this.source));
        }

        private boolean loadFromData(byte[] data) {
            this.unload(false);
            try {
                Preconditions.checkState((boolean)this.configType.isServer(), (Object)"Only server configs can be loaded from data");
                CommentedConfig commentedConfig = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(data));
                if (!this.isCorrect((UnmodifiableConfig)commentedConfig)) {
                    return false;
                }
                this.correct((UnmodifiableConfig)commentedConfig);
                CommentedConfig config = this.isReadOnly() ? commentedConfig.unmodifiable() : commentedConfig;
                this.allProperties.forEach(arg_0 -> this.lambda$loadFromData$1((UnmodifiableConfig)config, arg_0));
                this.config = config;
                this.sendEvent(new SimpleConfigEvent.Load(this.source));
                return true;
            }
            catch (ParsingException e) {
                Configured.LOGGER.info("Failed to parse config data: {}", (Object)e.toString());
                return false;
            }
            catch (Exception e) {
                Configured.LOGGER.info("An exception occurred when loading config data: {}", (Object)e.toString());
                this.unload(false);
                return false;
            }
        }

        private UnmodifiableConfig createConfig(@Nullable Path configDir) {
            if (this.readOnly) {
                Preconditions.checkArgument((configDir != null ? 1 : 0) != 0, (Object)"Config dir must not be null for read only configs");
                return SimpleConfigManager.createReadOnlyConfig(configDir, this.id, this.separator, this.name, this::correct);
            }
            return SimpleConfigManager.createSimpleConfig(configDir, this.id, this.separator, this.name);
        }

        private void unload(boolean sendEvent) {
            if (this.config != null) {
                this.allProperties.forEach(p -> p.updateProxy(ValueProxy.EMPTY));
                ConfigHelper.closeConfig(this.config);
                this.config = null;
                if (sendEvent) {
                    Configured.LOGGER.info("Sending config unload event for {}", (Object)this.getFileName());
                    this.sendEvent(new SimpleConfigEvent.Unload(this.source));
                }
            }
        }

        private void changeCallback() {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            if (this.config != null && !this.isReadOnly()) {
                ConfigHelper.loadConfig(this.config);
                this.correct(this.config);
                this.allProperties.forEach(ConfigProperty::invalidateCache);
                ((BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(FMLEnvironment.dist.isClient() ? LogicalSide.CLIENT : LogicalSide.SERVER)).m_18707_(() -> this.sendEvent(new SimpleConfigEvent.Reload(this.source)));
            }
        }

        private boolean isCorrect(UnmodifiableConfig config) {
            if (config instanceof Config) {
                return this.spec.isCorrect((Config)config);
            }
            return true;
        }

        private void correct(UnmodifiableConfig config) {
            if (config instanceof Config && !this.isCorrect(config)) {
                ConfigHelper.createBackup(config);
                this.spec.correct((Config)config);
                if (config instanceof CommentedConfig) {
                    CommentedConfig c = (CommentedConfig)config;
                    c.putAllComments((UnmodifiableCommentedConfig)this.comments);
                }
                ConfigHelper.saveConfig(config);
            }
        }

        @Override
        public void update(IConfigEntry entry) {
            Preconditions.checkState((this.config != null ? 1 : 0) != 0, (Object)"Tried to update a config that is not loaded");
            if (this.readOnly || !(this.config instanceof Config)) {
                return;
            }
            Set<IConfigValue<?>> changedValues = ConfigHelper.getChangedValues(entry);
            if (changedValues.isEmpty()) {
                return;
            }
            CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableConfig)this.config);
            changedValues.forEach(value -> {
                if (value instanceof SimpleValue) {
                    SimpleValue simpleValue = (SimpleValue)value;
                    newConfig.set(simpleValue.getPath(), simpleValue.get());
                }
            });
            this.correct((UnmodifiableConfig)newConfig);
            ((Config)this.config).putAll((UnmodifiableConfig)newConfig);
            this.allProperties.forEach(ConfigProperty::invalidateCache);
            if (this.getType().isServer()) {
                if (!ConfigHelper.isPlayingGame()) {
                    this.unload(false);
                    return;
                }
                this.syncToServer();
                if (!ConfigHelper.isRunningLocalServer() && !this.getType().isSync()) {
                    this.unload(false);
                    return;
                }
            }
            Configured.LOGGER.info("Sending config reloading event for {}", (Object)this.getFileName());
            this.sendEvent(new SimpleConfigEvent.Reload(this.source));
        }

        public ResourceLocation getName() {
            return new ResourceLocation(this.id, this.name);
        }

        @Nullable
        public Path getFilePath() {
            return this.config instanceof FileConfig ? ((FileConfig)this.config).getNioPath() : null;
        }

        @Override
        public IConfigEntry getRoot() {
            return new SimpleFolderEntry("Root", this.propertyMap, true);
        }

        @Override
        public ConfigType getType() {
            return this.configType;
        }

        @Override
        public String getFileName() {
            return String.format("%s%s%s.toml", this.id, Character.valueOf(this.separator), this.name);
        }

        @Override
        public String getTranslationKey() {
            return String.format("simpleconfig.%s.%s", this.id, this.name);
        }

        @Override
        public String getModId() {
            return this.id;
        }

        @Override
        public boolean isReadOnly() {
            return this.readOnly;
        }

        public boolean isLoaded() {
            return this.config != null;
        }

        @Override
        public void startEditing() {
            if (!ConfigHelper.isPlayingGame() && ConfigHelper.isServerConfig(this)) {
                this.load(FMLPaths.CONFIGDIR.get());
            }
        }

        @Override
        public void stopEditing() {
            if (this.config != null && this.getType().isServer() && (!ConfigHelper.isPlayingGame() || !ConfigHelper.isRunningLocalServer() && !this.getType().isSync())) {
                this.unload(false);
            }
        }

        @Override
        public void loadWorldConfig(Path configDir, Consumer<IModConfig> result) {
            if (!ConfigHelper.isWorldConfig(this)) {
                return;
            }
            Preconditions.checkState((this.config == null ? 1 : 0) != 0, (Object)"Something went wrong and tried to load the server config again!");
            UnmodifiableConfig config = this.createConfig(configDir);
            ConfigHelper.loadConfig(config);
            this.correct(config);
            if (config instanceof CommentedConfig) {
                CommentedConfig c = (CommentedConfig)config;
                c.putAllComments((UnmodifiableCommentedConfig)this.comments);
            }
            this.allProperties.forEach(p -> p.updateProxy(new ValueProxy(config, p.getPath(), this.readOnly)));
            this.config = config;
            result.accept(this);
        }

        @Override
        public boolean isChanged() {
            if (ConfigHelper.isWorldConfig(this) && this.config == null) {
                return false;
            }
            if (this.getType() == ConfigType.MEMORY && this.config == null) {
                return false;
            }
            if (this.config != null) {
                return this.allProperties.stream().anyMatch(property -> !property.isDefault());
            }
            CommentedFileConfig tempConfig = SimpleConfigManager.createTempConfig(FMLPaths.CONFIGDIR.get(), this.id, this.separator, this.name);
            ConfigHelper.loadConfig((UnmodifiableConfig)tempConfig);
            this.correct((UnmodifiableConfig)tempConfig);
            tempConfig.putAllComments((UnmodifiableCommentedConfig)this.comments);
            this.allProperties.forEach(p -> p.updateProxy(new ValueProxy((UnmodifiableConfig)tempConfig, p.getPath(), this.readOnly)));
            boolean changed = this.allProperties.stream().anyMatch(property -> !property.isDefault());
            this.allProperties.forEach(p -> p.updateProxy(ValueProxy.EMPTY));
            tempConfig.close();
            return changed;
        }

        @Override
        public void restoreDefaults() {
            if (this.readOnly) {
                return;
            }
            if (ConfigHelper.isWorldConfig(this) && this.config == null) {
                return;
            }
            if (this.config != null) {
                this.allProperties.forEach(ConfigProperty::restoreDefault);
                return;
            }
            CommentedFileConfig tempConfig = SimpleConfigManager.createTempConfig(FMLPaths.CONFIGDIR.get(), this.id, this.separator, this.name);
            ConfigHelper.loadConfig((UnmodifiableConfig)tempConfig);
            this.correct((UnmodifiableConfig)tempConfig);
            tempConfig.putAllComments((UnmodifiableCommentedConfig)this.comments);
            this.allProperties.forEach(property -> tempConfig.set(property.getPath(), property.getDefaultValue()));
            ConfigHelper.saveConfig((UnmodifiableConfig)tempConfig);
            tempConfig.close();
        }

        private void syncToServer() {
            if (!EffectiveSide.get().isClient()) {
                return;
            }
            if (this.config == null) {
                return;
            }
            if (!ConfigHelper.isPlayingGame()) {
                return;
            }
            if (!ConfigHelper.isConfiguredInstalledOnServer()) {
                return;
            }
            if (!this.getType().isServer() || this.getType() == ConfigType.DEDICATED_SERVER) {
                return;
            }
            Player player = ConfigHelper.getClientPlayer();
            if (!ConfigHelper.isOperator(player) || !SessionData.isDeveloper(player)) {
                return;
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            TomlFormat.instance().createWriter().write(this.config, (OutputStream)stream);
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageSyncSimpleConfig(this.getName(), stream.toByteArray()));
        }

        @Override
        public void requestFromServer() {
            if (!this.getType().isServer()) {
                return;
            }
            if (!ConfigHelper.isPlayingGame()) {
                return;
            }
            if (!ConfigHelper.isConfiguredInstalledOnServer()) {
                return;
            }
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageRequestSimpleConfig(this.getName()));
        }

        private void sendEvent(SimpleConfigEvent event) {
            ModList.get().getModContainerById(this.id).ifPresent(container -> {
                if (container instanceof FMLModContainer) {
                    FMLModContainer modContainer = (FMLModContainer)container;
                    modContainer.getEventBus().post((Event)event);
                }
            });
        }

        @Nullable
        public byte[] getData() {
            return this.config != null ? ConfigHelper.getBytes(this.config) : null;
        }

        private /* synthetic */ void lambda$loadFromData$1(UnmodifiableConfig config, ConfigProperty p) {
            p.updateProxy(new ValueProxy(config, p.getPath(), this.readOnly));
        }
    }

    private static class ConfigScanData {
        private final SimpleConfig config;
        private final Object source;
        private final Set<ConfigProperty<?>> properties = new HashSet();
        private final Map<List<String>, String> comments = new HashMap<List<String>, String>();

        private ConfigScanData(SimpleConfig config, Object source) {
            this.config = config;
            this.source = source;
        }

        public SimpleConfig getConfig() {
            return this.config;
        }

        public Object getSource() {
            return this.source;
        }

        public Set<ConfigProperty<?>> getProperties() {
            return this.properties;
        }

        public Map<List<String>, String> getComments() {
            return this.comments;
        }

        private static ConfigScanData analyze(SimpleConfig config, Object source) {
            Preconditions.checkArgument((!source.getClass().isPrimitive() ? 1 : 0) != 0, (Object)"SimpleConfig annotation can only be attached");
            ConfigScanData data = new ConfigScanData(config, source);
            data.scan(new Stack<String>(), source);
            return data;
        }

        private void scan(Stack<String> stack, Object instance) {
            Field[] fields = instance.getClass().getDeclaredFields();
            Stream.of(fields).forEach(field -> Optional.ofNullable(field.getDeclaredAnnotation(SimpleProperty.class)).ifPresent(sp -> {
                stack.push(sp.name());
                try {
                    Object obj;
                    field.setAccessible(true);
                    if (!sp.comment().isEmpty()) {
                        this.comments.put(new ArrayList(stack), sp.comment());
                    }
                    if ((obj = field.get(instance)) instanceof ConfigProperty) {
                        ConfigProperty property = (ConfigProperty)obj;
                        ArrayList<String> path = new ArrayList<String>(stack);
                        String key = String.format("simpleconfig.%s.%s.%s", this.config.id(), this.config.name(), StringUtils.join(path, (char)'.'));
                        property.initProperty(new PropertyData(sp.name(), path, key, sp.comment(), sp.worldRestart(), sp.gameRestart()));
                        this.properties.add(property);
                    } else {
                        this.scan(stack, obj);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                stack.pop();
            }));
        }
    }

    public static interface IMapEntry {
    }

    public static class PropertyData {
        private final String name;
        private final List<String> path;
        private final String translationKey;
        private final String comment;
        private final boolean worldRestart;
        private final boolean gameRestart;

        private PropertyData(String name, List<String> path, String translationKey, String comment, boolean worldRestart, boolean gameRestart) {
            this.name = name;
            this.path = ImmutableList.copyOf(path);
            this.translationKey = translationKey;
            this.comment = comment;
            this.worldRestart = worldRestart;
            this.gameRestart = gameRestart;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getPath() {
            return this.path;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean requiresWorldRestart() {
            return this.worldRestart;
        }

        public boolean requiresGameRestart() {
            return this.gameRestart;
        }
    }

    public static class ValueProxy {
        private static final ValueProxy EMPTY = new ValueProxy();
        private final UnmodifiableConfig config;
        private final List<String> path;
        private final boolean readOnly;

        private ValueProxy() {
            this.config = null;
            this.path = null;
            this.readOnly = true;
        }

        private ValueProxy(UnmodifiableConfig config, List<String> path, boolean readOnly) {
            this.config = config;
            this.path = path;
            this.readOnly = readOnly;
        }

        public boolean isLinked() {
            return this != EMPTY;
        }

        public boolean isWritable() {
            return !this.readOnly;
        }

        @Nullable
        public <T> T get(BiFunction<UnmodifiableConfig, List<String>, T> function) {
            if (this.isLinked() && this.config != null) {
                return function.apply(this.config, this.path);
            }
            return null;
        }

        public <T> void set(T value) {
            UnmodifiableConfig unmodifiableConfig;
            if (this.isLinked() && this.isWritable() && (unmodifiableConfig = this.config) instanceof Config) {
                Config c = (Config)unmodifiableConfig;
                c.set(this.path, value);
            }
        }
    }

    public static class PropertyMap
    implements IMapEntry {
        private final Map<String, IMapEntry> map = new HashMap<String, IMapEntry>();
        private final List<String> path;

        private PropertyMap(List<String> path) {
            this.path = path;
        }

        private PropertyMap(Set<ConfigProperty<?>> properties) {
            this.path = null;
            properties.forEach(p -> {
                PropertyMap current = this;
                List<String> path = p.getPath();
                for (int i = 0; i < path.size() - 1; ++i) {
                    int finalI = i;
                    current = (PropertyMap)current.map.computeIfAbsent(path.get(i), s -> new PropertyMap(path.subList(0, finalI)));
                }
                current.map.put(path.get(path.size() - 1), (IMapEntry)p);
            });
        }

        public List<Pair<String, PropertyMap>> getConfigMaps() {
            return this.map.entrySet().stream().filter(entry -> entry.getValue() instanceof PropertyMap).map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((PropertyMap)entry.getValue()))).toList();
        }

        public List<ConfigProperty<?>> getConfigProperties() {
            ArrayList properties = new ArrayList();
            this.map.forEach((name, entry) -> {
                if (entry instanceof ConfigProperty) {
                    ConfigProperty property = (ConfigProperty)entry;
                    properties.add(property);
                }
            });
            return properties;
        }

        public List<String> getPath() {
            return this.path;
        }
    }
}

