/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.forge;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.ValueEntry;
import com.mrcrayfish.configured.impl.forge.ForgeEnumValue;
import com.mrcrayfish.configured.impl.forge.ForgeListValue;
import com.mrcrayfish.configured.impl.forge.ForgeValue;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeFolderEntry
implements IConfigEntry {
    protected final String label;
    protected final UnmodifiableConfig config;
    protected final ForgeConfigSpec spec;
    protected final boolean root;
    protected List<IConfigEntry> entries;

    public ForgeFolderEntry(String label, UnmodifiableConfig config, ForgeConfigSpec spec, boolean root) {
        this.label = label;
        this.config = config;
        this.spec = spec;
        this.root = root;
    }

    @Override
    public List<IConfigEntry> getChildren() {
        if (this.entries == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.config.valueMap().forEach((s, o) -> {
                if (o instanceof UnmodifiableConfig) {
                    builder.add((Object)new ForgeFolderEntry((String)s, (UnmodifiableConfig)o, this.spec, false));
                } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                    ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                    if (configValue.get() instanceof List) {
                        builder.add((Object)new ValueEntry(new ForgeListValue((ForgeConfigSpec.ConfigValue<List<?>>)configValue, (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath()))));
                    } else if (configValue.get() instanceof Enum) {
                        builder.add((Object)new ValueEntry(new ForgeEnumValue((ForgeConfigSpec.EnumValue)configValue, (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath()))));
                    } else {
                        builder.add((Object)new ValueEntry(new ForgeValue(configValue, (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath()))));
                    }
                }
            });
            this.entries = builder.build();
        }
        return this.entries;
    }

    @Override
    public boolean isRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public IConfigValue<?> getValue() {
        return null;
    }

    @Override
    public String getEntryName() {
        return this.label;
    }
}

