/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.configured.Config;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ActiveConfirmationScreen;
import com.mrcrayfish.configured.client.screen.ChangeEnumScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.EditListScreen;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.IEditing;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.widget.CheckBoxButton;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigScreen
extends ListMenuScreen
implements IEditing {
    public static final Comparator<ListMenuScreen.Item> SORT_ALPHABETICALLY = (o1, o2) -> {
        if (o1 instanceof FolderItem && o2 instanceof FolderItem) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
        if (!(o1 instanceof FolderItem) && o2 instanceof FolderItem) {
            return 1;
        }
        if (o1 instanceof FolderItem) {
            return -1;
        }
        return o1.getLabel().compareTo(o2.getLabel());
    };
    protected final IConfigEntry folderEntry;
    protected final IModConfig config;
    protected final Map<String, String> cachedTextMap = new HashMap<String, String>();
    protected Button saveButton;
    protected Button restoreButton;
    protected CheckBoxButton deepSearchCheckBox;

    private ConfigScreen(Screen parent, Component title, IModConfig config, ResourceLocation background, IConfigEntry folderEntry) {
        super(parent, title, background, 24);
        this.config = config;
        this.folderEntry = folderEntry;
    }

    public ConfigScreen(Screen parent, Component title, IModConfig config, ResourceLocation background) {
        super(parent, title, background, 24);
        this.config = config;
        this.folderEntry = config.getRoot();
    }

    @Override
    public IModConfig getActiveConfig() {
        return this.config;
    }

    public void m_7861_() {
        this.cachedTextMap.clear();
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        ArrayList<ListMenuScreen.Item> configEntries = new ArrayList<ListMenuScreen.Item>();
        this.folderEntry.getChildren().forEach(entry -> {
            ListMenuScreen.Item item = this.createItemFromEntry((IConfigEntry)entry);
            if (item != null) {
                configEntries.add(item);
            }
        });
        configEntries.sort(SORT_ALPHABETICALLY);
        entries.addAll(configEntries);
    }

    @Nullable
    private ListMenuScreen.Item createItemFromEntry(IConfigEntry entry) {
        if (entry.isLeaf()) {
            IConfigValue<Boolean> value = entry.getValue();
            if (value != null) {
                Object object = value.get();
                if (object instanceof Boolean) {
                    return new BooleanItem(value);
                }
                if (object instanceof Integer) {
                    return new IntegerItem((IConfigValue<Integer>)value);
                }
                if (object instanceof Double) {
                    return new DoubleItem((IConfigValue<Double>)value);
                }
                if (object instanceof Long) {
                    return new LongItem((IConfigValue<Long>)value);
                }
                if (object instanceof Enum) {
                    return new EnumItem((IConfigValue<Enum<?>>)value);
                }
                if (object instanceof String) {
                    return new StringItem((IConfigValue<String>)value);
                }
                if (object instanceof List) {
                    return new ListItem((IConfigValue<List<?>>)value);
                }
                Configured.LOGGER.info("Unsupported config value: " + value.getName());
            }
            return null;
        }
        return new FolderItem(entry);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (this.folderEntry.isRoot()) {
            this.saveButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ / 2 - 140, this.f_96544_ - 29, 22, 0, 90, (Component)new TranslatableComponent("configured.gui.save"), button -> {
                this.saveConfig();
                if (ConfigHelper.getChangedValues(this.folderEntry).stream().anyMatch(IConfigValue::requiresGameRestart)) {
                    ConfirmationScreen confirm = new ConfirmationScreen(this.parent, (Component)new TranslatableComponent("configured.gui.game_restart_needed"), ConfirmationScreen.Icon.INFO, result -> true);
                    confirm.setPositiveText((Component)new TranslatableComponent("configured.gui.close"));
                    confirm.setNegativeText(null);
                    this.f_96541_.m_91152_((Screen)confirm);
                } else if (this.f_96541_.f_91073_ != null && ConfigHelper.getChangedValues(this.folderEntry).stream().anyMatch(IConfigValue::requiresWorldRestart)) {
                    ConfirmationScreen confirm = new ConfirmationScreen(this.parent, (Component)new TranslatableComponent("configured.gui.world_restart_needed"), ConfirmationScreen.Icon.INFO, result -> true);
                    confirm.setPositiveText((Component)new TranslatableComponent("configured.gui.close"));
                    confirm.setNegativeText(null);
                    this.f_96541_.m_91152_((Screen)confirm);
                } else {
                    this.f_96541_.m_91152_(this.parent);
                }
            }));
            this.restoreButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ / 2 - 45, this.f_96544_ - 29, 0, 0, 90, (Component)new TranslatableComponent("configured.gui.reset_all"), button -> {
                if (this.folderEntry.isRoot()) {
                    this.showRestoreScreen();
                }
            }));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 50, this.f_96544_ - 29, 90, 20, CommonComponents.f_130656_, button -> {
                if (this.isChanged(this.folderEntry)) {
                    this.f_96541_.m_91152_((Screen)new ActiveConfirmationScreen(this, this.config, (Component)new TranslatableComponent("configured.gui.unsaved_changes"), ConfirmationScreen.Icon.WARNING, result -> {
                        if (!result.booleanValue()) {
                            return true;
                        }
                        this.f_96541_.m_91152_(this.parent);
                        return false;
                    }).setBackground(this.background));
                } else {
                    this.f_96541_.m_91152_(this.parent);
                }
            }));
            this.updateButtons();
        } else {
            this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ / 2 - 130, this.f_96544_ - 29, 22, 44, 128, (Component)new TranslatableComponent("configured.gui.home"), button -> {
                ConfigScreen target = this;
                while (target.parent instanceof ConfigScreen) {
                    target = (ConfigScreen)target.parent;
                }
                this.f_96541_.m_91152_((Screen)target);
            }));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 2, this.f_96544_ - 29, 128, 20, CommonComponents.f_130660_, button -> this.f_96541_.m_91152_(this.parent)));
        }
        this.deepSearchCheckBox = new CheckBoxButton(this.f_96543_ / 2 + 115, 25, button -> this.updateSearchResults());
        this.m_142416_((GuiEventListener)this.deepSearchCheckBox);
    }

    private void saveConfig() {
        if (!this.isChanged(this.folderEntry) || this.config == null) {
            return;
        }
        this.config.update(this.folderEntry);
    }

    private void showRestoreScreen() {
        ActiveConfirmationScreen confirmScreen = new ActiveConfirmationScreen(this, this.config, (Component)new TranslatableComponent("configured.gui.restore_message"), ConfirmationScreen.Icon.WARNING, result -> {
            if (!result.booleanValue()) {
                return true;
            }
            this.restoreDefaults(this.folderEntry);
            this.updateButtons();
            return true;
        });
        confirmScreen.setBackground(this.background);
        confirmScreen.setPositiveText((Component)new TranslatableComponent("configured.gui.reset_all").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        confirmScreen.setNegativeText(CommonComponents.f_130656_);
        Minecraft.m_91087_().m_91152_((Screen)confirmScreen);
    }

    private void restoreDefaults(IConfigEntry entry) {
        for (IConfigEntry child : entry.getChildren()) {
            if (child.isLeaf()) {
                IConfigValue<?> value = child.getValue();
                if (value == null) continue;
                value.restore();
                continue;
            }
            this.restoreDefaults(child);
        }
    }

    private void updateButtons() {
        if (this.folderEntry.isRoot()) {
            if (this.saveButton != null) {
                boolean bl = this.saveButton.f_93623_ = !this.config.isReadOnly() && this.isChanged(this.folderEntry);
            }
            if (this.restoreButton != null) {
                this.restoreButton.f_93623_ = !this.config.isReadOnly() && this.isModified(this.folderEntry);
            }
        }
    }

    @Override
    protected void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.config.isReadOnly()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)IconButton.ICONS);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Screen.m_93160_((PoseStack)poseStack, (int)(this.f_96543_ - 30), (int)14, (int)20, (int)20, (float)0.0f, (float)33.0f, (int)10, (int)10, (int)64, (int)64);
            if (ScreenUtil.isMouseWithin(this.f_96543_ - 30, 14, 20, 20, mouseX, mouseY)) {
                this.setActiveTooltip((Component)new TranslatableComponent("configured.gui.read_only_config"), -14785178);
            }
        }
        if (this.deepSearchCheckBox.m_5953_(mouseX, mouseY)) {
            this.setActiveTooltip((Component)new TranslatableComponent("configured.gui.deep_search"));
        }
    }

    @Override
    protected Collection<ListMenuScreen.Item> getSearchResults(String s) {
        ArrayList<ListMenuScreen.Item> entries = this.entries;
        if (this.deepSearchCheckBox.m_93840_()) {
            ArrayList<ListMenuScreen.Item> allEntries = new ArrayList<ListMenuScreen.Item>();
            ConfigHelper.gatherAllConfigEntries(this.folderEntry).forEach(entry -> {
                ListMenuScreen.Item item = this.createItemFromEntry((IConfigEntry)entry);
                if (item instanceof ConfigItem) {
                    allEntries.add(item);
                }
            });
            allEntries.sort(SORT_ALPHABETICALLY);
            entries = allEntries;
        }
        return entries.stream().filter(item -> {
            if (item instanceof ListMenuScreen.IIgnoreSearch) {
                return false;
            }
            if (item instanceof FolderItem && !((Boolean)Config.CLIENT.includeFoldersInSearch.get()).booleanValue()) {
                return false;
            }
            return item.getLabel().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH));
        }).collect(Collectors.toList());
    }

    private static String createLabelFromHolder(IConfigValue<?> holder) {
        if (holder.getTranslationKey() != null && I18n.m_118936_((String)holder.getTranslationKey())) {
            return new TranslatableComponent(holder.getTranslationKey()).getString();
        }
        return ConfigScreen.createLabel(holder.getName());
    }

    public static String createLabel(String input) {
        int i;
        String valueName = input;
        String[] words = valueName.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        valueName = Strings.join((String[])words, (String)" ");
        words = valueName.split("_");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        return Strings.join((String[])words, (String)" ").replaceAll("\\s++", " ");
    }

    public boolean m_6913_() {
        return this.config == null || this.config.getType() != ConfigType.WORLD;
    }

    public boolean isModified(IConfigEntry entry) {
        if (entry.isLeaf()) {
            IConfigValue<?> value = entry.getValue();
            return value != null && !value.isDefault();
        }
        for (IConfigEntry child : entry.getChildren()) {
            if (!this.isModified(child)) continue;
            return true;
        }
        return false;
    }

    public boolean isChanged(IConfigEntry entry) {
        if (entry.isLeaf()) {
            IConfigValue<?> value = entry.getValue();
            return value != null && value.isChanged();
        }
        for (IConfigEntry child : entry.getChildren()) {
            if (!this.isChanged(child)) continue;
            return true;
        }
        return false;
    }

    public class BooleanItem
    extends ConfigItem<Boolean> {
        private final Button button;

        public BooleanItem(IConfigValue<Boolean> holder) {
            super(holder);
            this.button = new Button(10, 5, 46, 20, CommonComponents.m_130666_((boolean)holder.get()), button -> {
                holder.set((Boolean)holder.get() == false);
                button.m_93666_(CommonComponents.m_130666_((boolean)((Boolean)holder.get())));
                ConfigScreen.this.updateButtons();
            });
            this.button.f_93623_ = !ConfigScreen.this.config.isReadOnly();
            this.eventListeners.add(this.button);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.f_93620_ = left + width - 69;
            this.button.f_93621_ = top;
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.button.m_93666_(CommonComponents.m_130666_((boolean)((Boolean)this.holder.get())));
        }
    }

    public class IntegerItem
    extends NumberItem<Integer> {
        public IntegerItem(IConfigValue<Integer> holder) {
            super(holder, Integer::parseInt);
        }
    }

    public class DoubleItem
    extends NumberItem<Double> {
        public DoubleItem(IConfigValue<Double> holder) {
            super(holder, Double::parseDouble);
        }
    }

    public class LongItem
    extends NumberItem<Long> {
        public LongItem(IConfigValue<Long> holder) {
            super(holder, Long::parseLong);
        }
    }

    public class EnumItem
    extends ConfigItem<Enum<?>> {
        private final Button button;

        public EnumItem(IConfigValue<Enum<?>> holder) {
            super(holder);
            TranslatableComponent buttonText = ConfigScreen.this.config.isReadOnly() ? new TranslatableComponent("configured.gui.view") : new TranslatableComponent("configured.gui.change");
            this.button = new Button(10, 5, 46, 20, (Component)buttonText, button -> Minecraft.m_91087_().m_91152_((Screen)new ChangeEnumScreen(ConfigScreen.this, ConfigScreen.this.config, this.label, ConfigScreen.this.background, (Enum)holder.get(), holder, e -> {
                holder.set((Enum<?>)e);
                ConfigScreen.this.updateButtons();
            })));
            this.eventListeners.add(this.button);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.f_93620_ = left + width - 69;
            this.button.f_93621_ = top;
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public class StringItem
    extends ConfigItem<String> {
        private final Button button;

        public StringItem(IConfigValue<String> holder) {
            super(holder);
            TranslatableComponent buttonText = ConfigScreen.this.config.isReadOnly() ? new TranslatableComponent("configured.gui.view") : new TranslatableComponent("configured.gui.edit");
            this.button = new Button(10, 5, 46, 20, (Component)buttonText, button -> Minecraft.m_91087_().m_91152_((Screen)new EditStringScreen(ConfigScreen.this, ConfigScreen.this.config, ConfigScreen.this.background, this.label, (String)holder.get(), s -> holder.isValid((String)s) ? Pair.of((Object)true, (Object)TextComponent.f_131282_) : Pair.of((Object)false, (Object)holder.getValidationHint()), s -> {
                holder.set((String)s);
                ConfigScreen.this.updateButtons();
            })));
            this.eventListeners.add(this.button);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.f_93620_ = left + width - 69;
            this.button.f_93621_ = top;
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public class ListItem
    extends ConfigItem<List<?>> {
        private final Button button;

        public ListItem(IConfigValue<List<?>> holder) {
            super(holder);
            TranslatableComponent buttonText = ConfigScreen.this.config.isReadOnly() ? new TranslatableComponent("configured.gui.view") : new TranslatableComponent("configured.gui.edit");
            this.button = new Button(10, 5, 46, 20, (Component)buttonText, button -> Minecraft.m_91087_().m_91152_((Screen)new EditListScreen(ConfigScreen.this, ConfigScreen.this.config, this.label, holder, ConfigScreen.this.background)));
            this.eventListeners.add(this.button);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.f_93620_ = left + width - 69;
            this.button.f_93621_ = top;
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public class FolderItem
    extends ListMenuScreen.Item {
        private final IconButton button;

        public FolderItem(IConfigEntry folderEntry) {
            super((ListMenuScreen)ConfigScreen.this, (Component)new TextComponent(ConfigScreen.createLabel(folderEntry.getEntryName())));
            this.button = new IconButton(10, 5, 11, 33, 0, (Component)new TextComponent(this.getLabel()).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.WHITE), onPress -> {
                MutableComponent newTitle = ConfigScreen.this.f_96539_.m_6881_().m_7220_((Component)new TextComponent(" > ").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_130946_(this.getLabel());
                ConfigScreen.this.f_96541_.m_91152_((Screen)new ConfigScreen(ConfigScreen.this, (Component)newTitle, ConfigScreen.this.config, ConfigScreen.this.background, folderEntry));
            });
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)((Object)this.button));
        }

        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.f_93620_ = left - 1;
            this.button.f_93621_ = top;
            this.button.m_93674_(width);
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public abstract class ConfigItem<T>
    extends ListMenuScreen.Item {
        protected final IConfigValue<T> holder;
        protected final List<GuiEventListener> eventListeners;
        protected final Button resetButton;
        protected Component validationHint;

        public ConfigItem(IConfigValue<T> holder) {
            super((ListMenuScreen)ConfigScreen.this, ConfigScreen.createLabelFromHolder(holder));
            this.eventListeners = new ArrayList<GuiEventListener>();
            this.holder = holder;
            if (this.holder.getComment() != null) {
                this.tooltip = this.createToolTip(holder);
            }
            int maxTooltipWidth = Math.max(ConfigScreen.this.f_96543_ / 2 - 43, 170);
            Button.OnTooltip tooltip = ScreenUtil.createButtonTooltip(ConfigScreen.this, (Component)new TranslatableComponent("configured.gui.reset"), maxTooltipWidth);
            this.resetButton = new IconButton(0, 0, 0, 0, onPress -> {
                this.holder.restore();
                this.onResetValue();
                ConfigScreen.this.updateButtons();
            }, tooltip);
            this.resetButton.f_93623_ = !ConfigScreen.this.config.isReadOnly();
            this.eventListeners.add((GuiEventListener)this.resetButton);
        }

        protected void onResetValue() {
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return this.eventListeners;
        }

        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            boolean showValidationHint = this.validationHint != null;
            int trimLength = showValidationHint ? 100 : 80;
            ChatFormatting labelStyle = this.holder.isChanged() ? (ChatFormatting)Config.CLIENT.changedFormatting.get() : ChatFormatting.RESET;
            Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)this.getTrimmedLabel(width - trimLength).m_130940_(labelStyle), (float)left, (float)(top + 6), 0xFFFFFF);
            if (showValidationHint) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)IconButton.ICONS);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Screen.m_93160_((PoseStack)poseStack, (int)(left + width - 88), (int)(top + 3), (int)16, (int)16, (float)11.0f, (float)11.0f, (int)11, (int)11, (int)64, (int)64);
            }
            if (!ConfigScreen.this.config.isReadOnly() && (this.holder.requiresGameRestart() || this.holder.requiresWorldRestart())) {
                boolean gameRestart = this.holder.requiresGameRestart();
                RenderSystem.m_157456_((int)0, (ResourceLocation)IconButton.ICONS);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Screen.m_93160_((PoseStack)poseStack, (int)(left - 18), (int)(top + 5), (int)11, (int)11, (float)(gameRestart ? 51.0f : 11.0f), (float)22.0f, (int)11, (int)11, (int)64, (int)64);
                if (ScreenUtil.isMouseWithin(left - 18, top + 5, 11, 11, mouseX, mouseY)) {
                    String translationKey = gameRestart ? "configured.gui.requires_game_restart" : "configured.gui.requires_world_restart";
                    int outline = gameRestart ? -1438090048 : -1437158830;
                    ConfigScreen.this.setActiveTooltip((Component)new TranslatableComponent(translationKey), outline);
                }
            }
            if (this.m_5953_(mouseX, mouseY)) {
                if (showValidationHint && ScreenUtil.isMouseWithin(left + width - 92, top, 23, 20, mouseX, mouseY)) {
                    ConfigScreen.this.setActiveTooltip(this.validationHint, -1428357120);
                } else if (mouseX < ConfigScreen.this.list.m_5747_() + ConfigScreen.this.list.m_5759_() - 69) {
                    ConfigScreen.this.setTooltip(this.tooltip);
                }
            }
            this.resetButton.f_93623_ = !this.holder.isDefault() && !ConfigScreen.this.config.isReadOnly();
            this.resetButton.f_93620_ = left + width - 21;
            this.resetButton.f_93621_ = top;
            this.resetButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        private MutableComponent getTrimmedLabel(int maxWidth) {
            if (((ConfigScreen)ConfigScreen.this).f_96541_.f_91062_.m_92852_((FormattedText)this.label) > maxWidth) {
                return new TextComponent(((ConfigScreen)ConfigScreen.this).f_96541_.f_91062_.m_92854_((FormattedText)this.label, maxWidth).getString() + "...");
            }
            return this.label.m_6881_();
        }

        private List<FormattedCharSequence> createToolTip(IConfigValue<T> holder) {
            int i;
            Font font = Minecraft.m_91087_().f_91062_;
            List lines = font.m_92865_().m_92414_((FormattedText)new TextComponent(holder.getComment()), 200, Style.f_131099_);
            String name = holder.getName();
            lines.add(0, new TextComponent(name).m_130940_(ChatFormatting.YELLOW));
            int rangeIndex = -1;
            for (i = 0; i < lines.size(); ++i) {
                String text = ((FormattedText)lines.get(i)).getString();
                if (!text.startsWith("Range: ") && !text.startsWith("Allowed Values: ")) continue;
                rangeIndex = i;
                break;
            }
            if (rangeIndex != -1) {
                for (i = rangeIndex; i < lines.size(); ++i) {
                    lines.set(i, new TextComponent(((FormattedText)lines.get(i)).getString()).m_130940_(ChatFormatting.GRAY));
                }
            }
            return Language.m_128107_().m_128112_(lines);
        }

        public void setValidationHint(Component text) {
            this.validationHint = text;
        }
    }

    public abstract class NumberItem<T extends Number>
    extends ConfigItem<T> {
        private final ListMenuScreen.FocusedEditBox textField;
        private long lastTick;

        public NumberItem(IConfigValue<T> holder, Function<String, Number> parser) {
            super(holder);
            String text = ConfigScreen.this.cachedTextMap.getOrDefault(holder.getName(), ((Number)holder.get()).toString());
            this.textField = new ListMenuScreen.FocusedEditBox(ConfigScreen.this, ConfigScreen.this.f_96547_, 0, 0, 44, 18, this.label);
            this.textField.m_94151_(s -> {
                ConfigScreen.this.cachedTextMap.put(holder.getName(), (String)s);
                try {
                    Number n = (Number)parser.apply((String)s);
                    if (holder.isValid(n)) {
                        this.textField.m_94202_(0xE0E0E0);
                        holder.set(n);
                        ConfigScreen.this.updateButtons();
                        this.setValidationHint(null);
                    } else {
                        this.textField.m_94202_(0xFF0000);
                        this.setValidationHint(holder.getValidationHint());
                    }
                }
                catch (Exception ignored) {
                    this.textField.m_94202_(0xFF0000);
                    this.setValidationHint((Component)new TranslatableComponent("configured.validator.not_a_number"));
                }
            });
            this.textField.m_94144_(text);
            this.textField.m_94186_(!ConfigScreen.this.config.isReadOnly());
            this.eventListeners.add(this.textField);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            long time = Util.m_137550_();
            if (time - this.lastTick >= 50L) {
                this.textField.m_94120_();
                this.lastTick = time;
            }
            this.textField.f_93620_ = left + width - 68;
            this.textField.f_93621_ = top + 1;
            this.textField.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.textField.m_94144_(((Number)this.holder.get()).toString());
        }
    }
}

