/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.function.Function;
import net.dries007.tfc.common.blocks.SandstoneBlockType;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BadlandsSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory NORMAL = seed -> new BadlandsSurfaceBuilder(false, seed);
    public static final SurfaceBuilderFactory INVERTED = seed -> new BadlandsSurfaceBuilder(true, seed);
    private static final int PRIMARY_SIZE = 8;
    private static final int SECONDARY_SIZE = 5;
    private static final int UNCOMMON_SIZE = 3;
    private static final int LAYER_SIZE = 16;
    private final boolean inverted;
    private final BlockState[] sandLayers0;
    private final BlockState[] sandLayers1;
    private final BlockState[] sandstoneLayers0;
    private final BlockState[] sandstoneLayers1;
    private final float[] layerThresholds;
    private final Noise2D grassHeightVariationNoise;
    private final Noise2D sandHeightOffsetNoise;
    private final Noise2D sandStyleNoise;

    private static void fill(Random random, BlockState[] sandLayers, BlockState[] sandstoneLayers, SandBlockType primary, SandBlockType secondary, SandBlockType uncommon) {
        BadlandsSurfaceBuilder.fill(random, sandLayers, primary, secondary, uncommon, BadlandsSurfaceBuilder::sand);
        BadlandsSurfaceBuilder.fill(random, sandstoneLayers, primary, secondary, uncommon, BadlandsSurfaceBuilder::sandstone);
    }

    private static void fill(Random random, BlockState[] layers, SandBlockType primary, SandBlockType secondary, SandBlockType uncommon, Function<SandBlockType, BlockState> block) {
        Arrays.fill(layers, 0, 8, block.apply(primary));
        Arrays.fill(layers, 8, 13, block.apply(secondary));
        Arrays.fill(layers, 13, 16, block.apply(uncommon));
        Collections.shuffle(Arrays.asList(layers), random);
    }

    private static BlockState sand(SandBlockType color) {
        return ((Block)TFCBlocks.SAND.get((Object)color).get()).m_49966_();
    }

    private static BlockState sandstone(SandBlockType color) {
        return ((Block)TFCBlocks.SANDSTONE.get((Object)color).get((Object)SandstoneBlockType.RAW).get()).m_49966_();
    }

    public BadlandsSurfaceBuilder(boolean inverted, long seed) {
        this.inverted = inverted;
        Random random = new Random(seed);
        this.sandLayers0 = new BlockState[16];
        this.sandLayers1 = new BlockState[16];
        this.sandstoneLayers0 = new BlockState[16];
        this.sandstoneLayers1 = new BlockState[16];
        this.layerThresholds = new float[16];
        BadlandsSurfaceBuilder.fill(random, this.sandLayers0, this.sandstoneLayers0, SandBlockType.RED, SandBlockType.BROWN, SandBlockType.YELLOW);
        BadlandsSurfaceBuilder.fill(random, this.sandLayers1, this.sandstoneLayers1, SandBlockType.BROWN, SandBlockType.YELLOW, SandBlockType.WHITE);
        for (int i = 0; i < 16; ++i) {
            this.layerThresholds[i] = random.nextFloat();
        }
        this.grassHeightVariationNoise = new OpenSimplex2D(random.nextLong()).octaves(2).scaled(77.0f, 81.0f).spread(0.5f);
        this.sandHeightOffsetNoise = new OpenSimplex2D(random.nextLong()).octaves(2).scaled(0.0f, 6.0f).spread(0.0014f);
        this.sandStyleNoise = new OpenSimplex2D(random.nextLong()).octaves(2).scaled(-0.3f, 1.3f).spread(3.0E-4f);
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        float heightVariation = this.grassHeightVariationNoise.noise(context.pos().m_123341_(), context.pos().m_123343_());
        float weightVariation = (float)(1.0 - context.weight()) * 23.0f;
        if (this.inverted ? (float)(startY + 5) < heightVariation + weightVariation : (float)(startY - 5) > heightVariation - weightVariation) {
            NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, SurfaceStates.GRASS, SurfaceStates.DIRT, SurfaceStates.SANDSTONE_OR_GRAVEL);
        } else {
            this.buildSandySurface(context, startY, endY);
        }
    }

    private void buildSandySurface(SurfaceBuilderContext context, int startHeight, int minSurfaceHeight) {
        float style = this.sandStyleNoise.noise(context.pos().m_123341_(), context.pos().m_123343_());
        int height = (int)this.sandHeightOffsetNoise.noise(context.pos().m_123341_(), context.pos().m_123343_());
        int surfaceDepth = -1;
        for (int y = startHeight; y >= minSurfaceHeight; --y) {
            BlockState stateAt = context.getBlockState(y);
            if (stateAt.m_60795_()) {
                surfaceDepth = -1;
                continue;
            }
            if (!context.isDefaultBlock(stateAt)) continue;
            if (surfaceDepth == -1) {
                if (y < context.getSeaLevel() - 1) {
                    context.setBlockState(y, SurfaceStates.SAND_OR_GRAVEL);
                    continue;
                }
                context.setBlockState(y, this.sampleLayer(this.sandLayers0, this.sandLayers1, y + height, style));
                surfaceDepth = this.inverted ? 9 : 3;
                continue;
            }
            if (surfaceDepth <= 0) continue;
            --surfaceDepth;
            context.setBlockState(y, this.sampleLayer(this.sandstoneLayers0, this.sandstoneLayers1, y + height, style));
        }
    }

    private BlockState sampleLayer(BlockState[] layers0, BlockState[] layers1, int y, float threshold) {
        int index = Math.floorMod(y, 16);
        return (this.layerThresholds[index] < threshold ? layers0 : layers1)[index];
    }
}

