/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.settings;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.dries007.tfc.common.blocks.SandstoneBlockType;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.Codecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public record RockSettings(ResourceLocation id, Block raw, Block hardened, Block gravel, Block cobble, Block sand, Block sandstone, Optional<Block> spike, Optional<Block> loose, boolean topLayer, boolean middleLayer, boolean bottomLayer) {
    public static final Codec<RockSettings> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(c -> c.id), (App)Codecs.BLOCK.fieldOf("raw").forGetter(c -> c.raw), (App)Codecs.BLOCK.fieldOf("hardened").forGetter(c -> c.hardened), (App)Codecs.BLOCK.fieldOf("gravel").forGetter(c -> c.gravel), (App)Codecs.BLOCK.fieldOf("cobble").forGetter(c -> c.cobble), (App)Codecs.BLOCK.fieldOf("sand").forGetter(c -> c.sand), (App)Codecs.BLOCK.fieldOf("sandstone").forGetter(c -> c.sandstone), (App)Codecs.BLOCK.optionalFieldOf("spike").forGetter(c -> c.spike), (App)Codecs.BLOCK.optionalFieldOf("loose").forGetter(c -> c.loose), (App)Codec.BOOL.fieldOf("top_layer").forGetter(c -> c.topLayer), (App)Codec.BOOL.fieldOf("middle_layer").forGetter(c -> c.middleLayer), (App)Codec.BOOL.fieldOf("bottom_layer").forGetter(c -> c.bottomLayer)).apply((Applicative)instance, RockSettings::new));
    private static final Map<ResourceLocation, RockSettings> PRESETS = new ConcurrentHashMap<ResourceLocation, RockSettings>();
    public static final Codec<RockSettings> CODEC = Codec.either((Codec)ResourceLocation.f_135803_, DIRECT_CODEC).comapFlatMap(e -> (DataResult)e.map(id -> Codecs.requireNonNull(PRESETS.get(id), "No rock settings for id: " + id), DataResult::success), Either::right);

    public static RockSettings register(RockSettings settings) {
        PRESETS.put(settings.id(), settings);
        return settings;
    }

    public static void registerDefaultRocks() {
        for (Rock rock : Rock.values()) {
            ResourceLocation id = Helpers.identifier(rock.m_7912_());
            RockCategory category = rock.category();
            Map<Rock.BlockType, RegistryObject<Block>> blocks = TFCBlocks.ROCK_BLOCKS.get(rock);
            RockSettings.register(new RockSettings(id, (Block)blocks.get((Object)Rock.BlockType.RAW).get(), (Block)blocks.get((Object)Rock.BlockType.HARDENED).get(), (Block)blocks.get((Object)Rock.BlockType.GRAVEL).get(), (Block)blocks.get((Object)Rock.BlockType.COBBLE).get(), (Block)TFCBlocks.SAND.get((Object)rock.getSandType()).get(), (Block)TFCBlocks.SANDSTONE.get((Object)rock.getSandType()).get((Object)SandstoneBlockType.RAW).get(), Optional.of((Block)blocks.get((Object)Rock.BlockType.SPIKE).get()), Optional.of((Block)blocks.get((Object)Rock.BlockType.LOOSE).get()), category != RockCategory.IGNEOUS_INTRUSIVE, true, category == RockCategory.IGNEOUS_INTRUSIVE || category == RockCategory.METAMORPHIC));
        }
    }

    public static Map<ResourceLocation, RockSettings> getDefaults() {
        return ImmutableMap.copyOf(PRESETS);
    }

    public boolean isRawOrHardened(BlockState state) {
        return Helpers.isBlock(state, this.raw()) || Helpers.isBlock(state, this.hardened());
    }

    public Block get(Rock.BlockType type) {
        return switch (type) {
            case Rock.BlockType.RAW -> this.raw;
            case Rock.BlockType.HARDENED -> this.hardened;
            case Rock.BlockType.GRAVEL -> this.gravel;
            case Rock.BlockType.COBBLE -> this.cobble;
            case Rock.BlockType.SPIKE -> this.spike.orElseThrow();
            case Rock.BlockType.LOOSE -> this.loose.orElseThrow();
            default -> throw new IllegalArgumentException("Type " + type + " does not define a block");
        };
    }
}

