/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.settings;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.settings.RockLayer;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class RockLayerSettings {
    public static final Codec<RockLayerSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RockSettings.CODEC.listOf().comapFlatMap(RockLayerSettings::collect, RockLayerSettings::split).fieldOf("rocks").forGetter(c -> c.rocksById), (App)Codecs.POSITIVE_INT.comapFlatMap(RockLayerSettings::guardScale, RockLayerSettings::convertScale).fieldOf("rock_layer_scale").forGetter(c -> c.rockLayerScale)).apply((Applicative)instance, RockLayerSettings::new));
    public static final RockLayerSettings EMPTY = new RockLayerSettings(Collections.emptyMap(), 1);
    private final Map<ResourceLocation, RockSettings> rocksById;
    private final List<RockSettings> rocks;
    private final Map<Block, RockSettings> rockBlocks;
    private final Map<Block, Block> rawToHardened;
    private final int rockLayerScale;

    public static RockLayerSettings getDefault() {
        return new RockLayerSettings(RockSettings.getDefaults(), 7);
    }

    private static DataResult<Map<ResourceLocation, RockSettings>> collect(List<RockSettings> rocks) {
        HashSet<ResourceLocation> keys = new HashSet<ResourceLocation>();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (RockSettings rock : rocks) {
            if (keys.contains(rock.id())) {
                return DataResult.error((String)("Duplicate rock id: " + rock.id()));
            }
            keys.add(rock.id());
            builder.put((Object)rock.id(), (Object)rock);
        }
        if (keys.isEmpty()) {
            return DataResult.error((String)"Must contain at least one rock!");
        }
        return DataResult.success((Object)builder.build());
    }

    private static List<RockSettings> split(Map<ResourceLocation, RockSettings> rocks) {
        return new ArrayList<RockSettings>(rocks.values());
    }

    private static DataResult<Integer> guardScale(Integer scale) {
        if (!Mth.m_14152_((int)scale)) {
            return DataResult.error((String)"rock_layer_scale must be a multiple of 2!");
        }
        return DataResult.success((Object)Mth.m_14163_((int)scale));
    }

    private static Integer convertScale(Integer scale) {
        return 1 << scale;
    }

    public RockLayerSettings(Map<ResourceLocation, RockSettings> rocksById, int rockLayerScale) {
        this.rocksById = rocksById;
        this.rocks = rocksById.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).toList();
        this.rockBlocks = new IdentityHashMap<Block, RockSettings>();
        this.rockLayerScale = rockLayerScale;
        for (RockSettings rock : this.rocksById.values()) {
            this.rockBlocks.put(rock.raw(), rock);
            this.rockBlocks.put(rock.hardened(), rock);
            this.rockBlocks.put(rock.gravel(), rock);
            this.rockBlocks.put(rock.cobble(), rock);
            this.rockBlocks.put(rock.gravel(), rock);
            this.rockBlocks.put(rock.sand(), rock);
            this.rockBlocks.put(rock.sandstone(), rock);
            rock.loose().ifPresent(loose -> this.rockBlocks.put((Block)loose, rock));
            rock.spike().ifPresent(spike -> this.rockBlocks.put((Block)spike, rock));
        }
        this.rawToHardened = this.getRocks().stream().collect(Collectors.toMap(RockSettings::raw, RockSettings::hardened));
    }

    @Nullable
    public Block getHardened(Block raw) {
        return this.rawToHardened.get(raw);
    }

    @Nullable
    public RockSettings getRock(Block block) {
        return this.rockBlocks.get(block);
    }

    public RockSettings getRock(ResourceLocation id) {
        return this.rocksById.get(id);
    }

    public int getScale() {
        return this.rockLayerScale;
    }

    public List<RockSettings> getRocks() {
        return this.rocks;
    }

    public List<RockSettings> getRocksForLayer(RockLayer layer) {
        return this.rocks.stream().filter(rock -> switch (layer) {
            default -> throw new IncompatibleClassChangeError();
            case RockLayer.TOP -> rock.topLayer();
            case RockLayer.MIDDLE -> rock.middleLayer();
            case RockLayer.BOTTOM -> rock.bottomLayer();
        }).toList();
    }
}

