/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;

public enum ShrinkToCell implements RegionTask
{
    INSTANCE;


    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        int modifiedSizeX = 1 + context.maxX - context.minX;
        int modifiedSizeZ = 1 + context.maxZ - context.minZ;
        Region.Point[] modifiedPoints = new Region.Point[modifiedSizeX * modifiedSizeZ];
        int offsetX = context.minX - region.minX();
        int offsetZ = context.minZ - region.minZ();
        int prevSizeX = region.sizeX();
        for (int dx = 0; dx < modifiedSizeX; ++dx) {
            for (int dz = 0; dz < modifiedSizeZ; ++dz) {
                modifiedPoints[dx + modifiedSizeX * dz] = region.data()[offsetX + dx + prevSizeX * (offsetZ + dz)];
            }
        }
        context.region.setRegionArea(modifiedPoints, context.minX, context.minZ, context.maxX, context.maxZ);
    }
}

