/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.dries007.tfc.world.FastConcurrentCache;
import net.dries007.tfc.world.layer.PLayers;
import net.dries007.tfc.world.layer.framework.Area;
import net.dries007.tfc.world.layer.framework.AreaFactory;
import net.dries007.tfc.world.noise.Cellular2D;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.region.AddContinents;
import net.dries007.tfc.world.region.AddIslands;
import net.dries007.tfc.world.region.AddMountains;
import net.dries007.tfc.world.region.AddRiversAndLakes;
import net.dries007.tfc.world.region.AnnotateBaseLandHeight;
import net.dries007.tfc.world.region.AnnotateBiomeAltitude;
import net.dries007.tfc.world.region.AnnotateClimate;
import net.dries007.tfc.world.region.AnnotateDistanceToCellEdge;
import net.dries007.tfc.world.region.AnnotateDistanceToOcean;
import net.dries007.tfc.world.region.ChooseBiomes;
import net.dries007.tfc.world.region.FloodFillSmallOceans;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionPartition;
import net.dries007.tfc.world.region.RegionTask;
import net.dries007.tfc.world.region.RiverEdge;
import net.dries007.tfc.world.region.ShrinkToCell;
import net.dries007.tfc.world.region.Units;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import org.jetbrains.annotations.TestOnly;

public class RegionGenerator {
    final Noise2D continentNoise;
    final Noise2D temperatureNoise;
    final Noise2D rainfallNoise;
    final ThreadLocal<Area> biomeArea;
    final ThreadLocal<Area> rockArea;
    private final long seed;
    private final FastConcurrentCache<Region> cellCache;
    private final FastConcurrentCache<RegionPartition> partitionCache;
    private final Cellular2D cellNoise;

    private static float triangle(float frequency, float value) {
        return Math.abs(4.0f * frequency * value + 1.0f - 4.0f * (float)Mth.m_14143_((float)(frequency * value + 0.75f))) - 1.0f;
    }

    public RegionGenerator(long seed) {
        XoroshiroRandomSource random = new XoroshiroRandomSource(seed);
        this.seed = seed;
        this.cellNoise = new Cellular2D(random.nextLong()).spread(0.010416667f);
        this.cellCache = new FastConcurrentCache(256);
        this.partitionCache = new FastConcurrentCache(256);
        this.continentNoise = this.cellNoise.then(c -> 1.0f - c.f1() / (0.37f + c.f2())).lazyProduct(new OpenSimplex2D(random.nextLong()).spread(0.24f).scaled(2.5f, 8.7f).octaves(4));
        this.temperatureNoise = ((Noise2D)(x, z) -> RegionGenerator.triangle(0.0032f, z)).scaled(-20.0f, 30.0f).add(new OpenSimplex2D(random.nextInt()).octaves(2).spread(0.15f).scaled(-3.0f, 3.0f));
        this.rainfallNoise = ((Noise2D)(x, z) -> RegionGenerator.triangle(0.0032f, x)).scaled(0.0f, 500.0f).add(new OpenSimplex2D(random.nextInt()).octaves(2).spread(0.15f).scaled(-40.0f, 40.0f));
        AreaFactory biomeAreaFactory = PLayers.createUniformLayer((RandomSource)random, 2);
        AreaFactory rockAreaFactory = PLayers.createUniformLayer((RandomSource)random, 3);
        this.biomeArea = ThreadLocal.withInitial(biomeAreaFactory);
        this.rockArea = ThreadLocal.withInitial(rockAreaFactory);
    }

    public RegionPartition getOrCreatePartition(int gridX, int gridZ) {
        int cellZ;
        int cellX = Units.gridToCell(gridX);
        RegionPartition entry = this.partitionCache.getIfPresent(cellX, cellZ = Units.gridToCell(gridZ));
        if (entry == null) {
            entry = this.createPartition(cellX, cellZ);
            this.partitionCache.set(cellX, cellZ, entry);
        }
        return entry;
    }

    private RegionPartition createPartition(int cellX, int cellZ) {
        List<Region> nearbyRegions = this.getAllRegionsIn3x3CellArea(cellX, cellZ);
        RegionPartition partition = new RegionPartition(cellX, cellZ);
        for (Region region : nearbyRegions) {
            for (RiverEdge edge : region.rivers()) {
                for (int partX = edge.minPartX; partX <= edge.maxPartX; ++partX) {
                    for (int partZ = edge.minPartZ; partZ <= edge.maxPartZ; ++partZ) {
                        if (!partition.isIn(partX, partZ)) continue;
                        partition.getFromPart(partX, partZ).rivers().add(edge.fractal());
                    }
                }
            }
        }
        return partition;
    }

    private List<Region> getAllRegionsIn3x3CellArea(int cellX, int cellZ) {
        ArrayList<Region> regions = new ArrayList<Region>(9);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                Cellular2D.Cell regionCell = this.sampleCell(Units.cellToGrid(cellX + dx), Units.cellToGrid(cellZ + dz));
                regions.add(this.getOrCreateRegion(regionCell));
            }
        }
        return regions;
    }

    public Region getOrCreateRegion(int gridX, int gridZ) {
        return this.getOrCreateRegion(this.sampleCell(gridX, gridZ));
    }

    private Region getOrCreateRegion(Cellular2D.Cell cell) {
        int cellZ;
        int cellX = Float.floatToIntBits(cell.x());
        Region entry = this.cellCache.getIfPresent(cellX, cellZ = Float.floatToIntBits(cell.y()));
        if (entry == null) {
            entry = this.createRegion(cell, (id, r) -> {});
            this.cellCache.set(cellX, cellZ, entry);
        }
        return entry;
    }

    private Region createRegion(Cellular2D.Cell regionCell, BiConsumer<Task, Region> viewer) {
        return (RegionGenerator)this.new Context(viewer, (Cellular2D.Cell)regionCell, (long)this.seed).runTasks().region;
    }

    Cellular2D.Cell sampleCell(int gridX, int gridZ) {
        return this.cellNoise.cell(gridX, gridZ);
    }

    @TestOnly
    public void visualizeRegion(int gridX, int gridZ, BiConsumer<Task, Region> viewer) {
        this.createRegion(this.sampleCell(gridX, gridZ), viewer);
    }

    class Context {
        private final BiConsumer<Task, Region> viewer;
        final Cellular2D.Cell regionCell;
        final RandomSource random;
        final Region region;
        int minX;
        int maxX;
        int minZ;
        int maxZ;

        Context(BiConsumer<Task, Region> viewer, Cellular2D.Cell regionCell, long seed) {
            this.viewer = viewer;
            this.regionCell = regionCell;
            this.region = new Region(regionCell);
            long regionSeed = seed ^ (long)Float.floatToIntBits(regionCell.noise()) * 7189234123L;
            this.random = new XoroshiroRandomSource(regionSeed);
            this.minX = Integer.MAX_VALUE;
            this.minZ = Integer.MAX_VALUE;
            this.maxX = Integer.MIN_VALUE;
            this.maxZ = Integer.MIN_VALUE;
        }

        Context runTasks() {
            for (Task task : Task.VALUES) {
                this.run(task);
            }
            return this;
        }

        void run(Task task) {
            task.task.apply(this);
            this.viewer.accept(task, this.region);
        }

        RegionGenerator generator() {
            return RegionGenerator.this;
        }
    }

    public static enum Task {
        INIT(c -> {}),
        ADD_CONTINENTS(AddContinents.INSTANCE),
        SHRINK_TO_CELL(ShrinkToCell.INSTANCE),
        ANNOTATE_DISTANCE_TO_CELL_EDGE(AnnotateDistanceToCellEdge.INSTANCE),
        FLOOD_FILL_SMALL_OCEANS(FloodFillSmallOceans.INSTANCE),
        ADD_ISLANDS(AddIslands.INSTANCE),
        ANNOTATE_DISTANCE_TO_OCEAN(AnnotateDistanceToOcean.INSTANCE),
        ANNOTATE_BASE_LAND_HEIGHT(AnnotateBaseLandHeight.INSTANCE),
        ADD_MOUNTAINS(AddMountains.INSTANCE),
        ANNOTATE_BIOME_ALTITUDE(AnnotateBiomeAltitude.INSTANCE),
        ADD_RIVERS_AND_LAKES(AddRiversAndLakes.INSTANCE),
        ANNOTATE_CLIMATE(AnnotateClimate.INSTANCE),
        ANNOTATE_RAINFALL(c -> {}),
        CHOOSE_BIOMES(ChooseBiomes.INSTANCE);

        private static final Task[] VALUES;
        private final RegionTask task;

        private Task(RegionTask task) {
            this.task = task;
        }

        static {
            VALUES = Task.values();
        }
    }
}

