/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import java.util.HashMap;
import java.util.List;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;
import net.dries007.tfc.world.region.RiverEdge;
import net.dries007.tfc.world.river.RiverFractal;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import org.jetbrains.annotations.Nullable;

public final class AddRiversAndLakes
extends Enum<AddRiversAndLakes>
implements RegionTask {
    public static final /* enum */ AddRiversAndLakes INSTANCE = new AddRiversAndLakes();
    public static final float RIVER_LENGTH = 2.7f;
    public static final int RIVER_DEPTH = 17;
    public static final float RIVER_FEATHER = 0.8f;
    private static final /* synthetic */ AddRiversAndLakes[] $VALUES;

    public static AddRiversAndLakes[] values() {
        return (AddRiversAndLakes[])$VALUES.clone();
    }

    public static AddRiversAndLakes valueOf(String name) {
        return Enum.valueOf(AddRiversAndLakes.class, name);
    }

    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        RandomSource random = context.random;
        RegionRiverGenerator riverGenerator = new RegionRiverGenerator(region);
        this.createInitialDrains(context, region, riverGenerator);
        List<RiverEdge> rivers = riverGenerator.buildEdges(e -> new RiverEdge((RiverFractal.Edge)e, random));
        context.region.setRivers(rivers);
        this.annotateRiver(region, random, rivers);
    }

    private void createInitialDrains(RegionGenerator.Context context, Region region, RegionRiverGenerator riverGenerator) {
        for (int dx = 0; dx < region.sizeX(); ++dx) {
            for (int dz = 0; dz < region.sizeZ(); ++dz) {
                float bestAngle;
                int index = dx + region.sizeX() * dz;
                Region.Point point = region.data()[index];
                if (point == null || !point.shore() || context.random.nextInt(3) != 0 || Float.isNaN(bestAngle = this.findBestStartingAngle(region, context.random, index))) continue;
                XoroshiroRandomSource rng = new XoroshiroRandomSource(context.random.nextLong());
                riverGenerator.add(new RiverFractal.Builder((RandomSource)rng, (float)(region.minX() + dx) + 0.5f, (float)(region.minZ() + dz) + 0.5f, bestAngle, 2.7f, 17, 0.8f));
                point.setRiver();
            }
        }
    }

    private float findBestStartingAngle(Region region, RandomSource random, int index) {
        int bestDistanceMetric = Integer.MIN_VALUE;
        int bestDistanceCount = 0;
        float bestAngle = Float.NaN;
        for (int dirX = -1; dirX <= 1; ++dirX) {
            for (int dirZ = -1; dirZ <= 1; ++dirZ) {
                int dirDistanceMetric;
                Region.Point dirPoint;
                int dirIndex;
                if (dirX == 0 && dirZ == 0 || (dirIndex = region.offset(index, 2 * dirX, 2 * dirZ)) == -1 || (dirPoint = region.data()[dirIndex]) == null || !dirPoint.land() || (dirDistanceMetric = dirPoint.distanceToOcean - Math.abs(dirX) - Math.abs(dirZ)) <= bestDistanceMetric && random.nextInt(1 + bestDistanceCount) != 0) continue;
                if (dirDistanceMetric > bestDistanceMetric) {
                    bestDistanceMetric = dirDistanceMetric;
                    bestDistanceCount = 0;
                }
                ++bestDistanceCount;
                bestAngle = (float)Math.atan2(dirZ, dirX);
            }
        }
        return bestAngle;
    }

    private void annotateRiver(Region region, RandomSource random, List<RiverEdge> rivers) {
        HashMap<RiverFractal.Vertex, RiverEdge> map = new HashMap<RiverFractal.Vertex, RiverEdge>();
        for (RiverEdge edge : rivers) {
            edge.setSource(true);
            map.put(edge.source(), edge);
        }
        RiverEdge drain = null;
        for (RiverEdge edge : rivers) {
            RiverEdge downstreamEdge = (RiverEdge)map.get(edge.drain());
            edge.setDrainEdge(downstreamEdge);
            if (downstreamEdge == null) {
                drain = edge;
                continue;
            }
            downstreamEdge.setSource(false);
        }
        assert (drain != null) : "River was unable to locate a global drain edge";
        for (RiverEdge edge : rivers) {
            int gridZ;
            int gridX;
            Region.Point point;
            if (!edge.isSource() || (point = region.maybeAt(gridX = Math.round(edge.source().x()), gridZ = Math.round(edge.source().y()))) == null || point.distanceToOcean < 2 || !point.land() || random.nextInt(3) != 0) continue;
            point.setLake();
        }
    }

    private static /* synthetic */ AddRiversAndLakes[] $values() {
        return new AddRiversAndLakes[]{INSTANCE};
    }

    static {
        $VALUES = AddRiversAndLakes.$values();
    }

    static class RegionRiverGenerator
    extends RiverFractal.MultiParallelBuilder {
        private final Region region;

        RegionRiverGenerator(Region region) {
            this.region = region;
        }

        @Override
        protected boolean isLegal(RiverFractal.Vertex prev, RiverFractal.Vertex vertex) {
            Region.Point prevPoint = this.vertex2Point(prev);
            Region.Point newPoint = this.vertex2Point(vertex);
            return newPoint != null && prevPoint != null && newPoint.land() && newPoint.distanceToOcean >= prevPoint.distanceToOcean;
        }

        @Nullable
        private Region.Point vertex2Point(RiverFractal.Vertex vertex) {
            int gridX = Math.round(vertex.x());
            int gridZ = Math.round(vertex.y());
            return this.region.maybeAt(gridX, gridZ);
        }
    }
}

