/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;
import net.minecraft.world.level.levelgen.RandomSource;

public enum AddMountains implements RegionTask
{
    INSTANCE;


    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        RandomSource random = context.random;
        int placed = 0;
        for (int attempt = 0; attempt < 40 && placed < 3; ++attempt) {
            IntSet range;
            int originZ;
            int originX = region.minX() + random.nextInt(region.sizeX());
            Region.Point origin = region.maybeAt(originX, originZ = region.minZ() + random.nextInt(region.sizeZ()));
            if (origin == null || !origin.land()) continue;
            int originIndex = region.index(originX, originZ);
            if (origin.baseLandHeight > 1 && (origin.baseLandHeight < 4 || origin.baseLandHeight > 11) || (range = this.placeRange(region, random, originIndex)).size() <= 45) continue;
            range.forEach(index -> {
                Region.Point point = region.data()[index];
                point.setMountain();
                if (origin.baseLandHeight <= 2) {
                    point.setCoastalMountain();
                }
            });
            ++placed;
        }
    }

    private IntSet placeRange(Region region, RandomSource random, int originIndex) {
        BitSet explored = new BitSet(region.sizeX() * region.sizeZ());
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        IntOpenHashSet range = new IntOpenHashSet();
        queue.enqueue(originIndex);
        explored.set(originIndex);
        range.add(originIndex);
        int originBaseLandHeight = Math.max(1, region.data()[originIndex].baseLandHeight);
        int maxSize = 70 + random.nextInt(40);
        while (!queue.isEmpty()) {
            int last = queue.dequeueInt();
            Region.Point lastPoint = region.data()[last];
            if (range.size() > maxSize) break;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    int next = region.offset(last, dx, dz);
                    if (next == -1) continue;
                    Region.Point point = region.data()[next];
                    if (point != null && point.land() && point.baseLandHeight >= originBaseLandHeight - 1 && point.baseLandHeight <= originBaseLandHeight + 1 && (point.baseLandHeight > 2 || point.distanceToOcean < 3) && !explored.get(next)) {
                        if (lastPoint.baseLandHeight != point.baseLandHeight) {
                            queue.enqueue(next);
                        } else {
                            queue.enqueueFirst(next);
                        }
                        range.add(next);
                    }
                    explored.set(next);
                }
            }
        }
        return range;
    }
}

