/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.function.ToDoubleFunction;
import net.dries007.tfc.world.noise.FastNoiseLite;
import net.dries007.tfc.world.noise.Noise2D;

public class Cellular2D
implements Noise2D {
    public static final float JITTER = 0.43701595f;
    private final int seed;
    private float frequency;

    public Cellular2D(long seed) {
        this.seed = HashCommon.long2int((long)seed);
        this.frequency = 1.0f;
    }

    @Override
    public float noise(float x, float y) {
        return this.cell(x, y).noise();
    }

    @Override
    public Cellular2D spread(float scaleFactor) {
        this.frequency *= scaleFactor;
        return this;
    }

    public Noise2D then(ToDoubleFunction<Cell> f) {
        return (x, y) -> (float)f.applyAsDouble(this.cell(x, y));
    }

    public Cell cell(float x, float y) {
        int primeX = 501125321;
        int primeY = 1136930381;
        int xr = FastNoiseLite.FastFloor(x *= this.frequency);
        int yr = FastNoiseLite.FastFloor(y *= this.frequency);
        float distance0 = Float.MAX_VALUE;
        float distance1 = Float.MAX_VALUE;
        float closestCenterX = 0.0f;
        float closestCenterY = 0.0f;
        int closestHash = 0;
        int closestCellX = 0;
        int closestCellY = 0;
        int xPrimed = (xr - 1) * 501125321;
        int yPrimedBase = (yr - 1) * 1136930381;
        for (int xi = xr - 1; xi <= xr + 1; ++xi) {
            int yPrimed = yPrimedBase;
            for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                int hash = FastNoiseLite.Hash(this.seed, xPrimed, yPrimed);
                int idx = hash & 0x1FE;
                float vecX = (float)xi + FastNoiseLite.RandVecs2D[idx] * 0.43701595f;
                float vecY = (float)yi + FastNoiseLite.RandVecs2D[idx | 1] * 0.43701595f;
                float newDistance = (vecX - x) * (vecX - x) + (vecY - y) * (vecY - y);
                distance1 = FastNoiseLite.FastMax(FastNoiseLite.FastMin(distance1, newDistance), distance0);
                if (newDistance < distance0) {
                    distance0 = newDistance;
                    closestHash = hash;
                    closestCenterX = vecX;
                    closestCenterY = vecY;
                    closestCellX = xi;
                    closestCellY = yi;
                }
                yPrimed += 1136930381;
            }
            xPrimed += 501125321;
        }
        return new Cell(closestCenterX / this.frequency, closestCenterY / this.frequency, closestCellX, closestCellY, distance0, distance1, (float)closestHash * 4.656613E-10f);
    }

    public record Cell(float x, float y, int cx, int cy, float f1, float f2, float noise) {
    }
}

