/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer;

import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.Area;
import net.dries007.tfc.world.layer.framework.AreaContext;
import net.dries007.tfc.world.layer.framework.TransformLayer;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionPartition;
import net.dries007.tfc.world.region.Units;
import net.dries007.tfc.world.river.MidpointFractal;

public record RegionMergeRiverLayer(RegionGenerator generator) implements TransformLayer
{
    @Override
    public int apply(AreaContext context, Area area, int quartX, int quartZ) {
        int value = area.get(quartX, quartZ);
        if (TFCLayers.hasRiver(value)) {
            int gridX = Units.quartToGrid(quartX);
            int gridZ = Units.quartToGrid(quartZ);
            float exactGridX = Units.quartToGridExact(quartX);
            float exactGridZ = Units.quartToGridExact(quartZ);
            RegionPartition partition = this.generator.getOrCreatePartition(gridX, gridZ);
            RegionPartition.Point partitionPoint = partition.get(gridX, gridZ);
            for (MidpointFractal fractal : partitionPoint.rivers()) {
                if (!fractal.maybeIntersect(exactGridX, exactGridZ, 0.052f) || !fractal.intersect(exactGridX, exactGridZ, 0.052f)) continue;
                return TFCLayers.riverFor(value);
            }
        }
        return value;
    }
}

