/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer;

import net.dries007.tfc.world.layer.Plate;
import net.dries007.tfc.world.layer.framework.Area;
import net.dries007.tfc.world.layer.framework.AreaContext;
import net.dries007.tfc.world.layer.framework.AreaFactory;
import net.dries007.tfc.world.layer.framework.TypedArea;
import net.dries007.tfc.world.layer.framework.TypedAreaFactory;

public enum PlateBoundaryLayer {
    INSTANCE;

    public static final float SHEAR_THRESHOLD = 7.5f;
    public static final float HIGH_ELEVATION = 0.7f;
    public static final float MID_ELEVATION = 0.3f;

    public AreaFactory apply(long seed, TypedAreaFactory<Plate> plateLayer) {
        return () -> {
            AreaContext context = new AreaContext(seed);
            TypedArea area = (TypedArea)plateLayer.get();
            return new Area((x, z) -> {
                context.setSeed(x, z);
                return this.apply(context, area, x, z);
            }, 1024);
        };
    }

    private int apply(AreaContext context, TypedArea<Plate> area, int x, int z) {
        return this.apply(context, area.get(x, z - 1), area.get(x + 1, z), area.get(x, z + 1), area.get(x - 1, z), area.get(x, z));
    }

    private int apply(AreaContext context, Plate north, Plate west, Plate south, Plate east, Plate center) {
        Plate boundary = null;
        int boundaryCount = 0;
        if (!north.equals(center)) {
            ++boundaryCount;
            boundary = north;
        }
        if (!(west.equals(center) || boundary != null && context.random().nextInt(++boundaryCount) != 0)) {
            boundary = west;
        }
        if (!(south.equals(center) || boundary == null && context.random().nextInt(++boundaryCount) != 0)) {
            boundary = south;
        }
        if (!(east.equals(center) || boundary == null && context.random().nextInt(++boundaryCount) != 0)) {
            boundary = east;
        }
        if (boundary != null) {
            return this.boundary(center, boundary);
        }
        return this.plate(center);
    }

    private int boundary(Plate center, Plate other) {
        float vZ;
        float distX = center.x() - other.x();
        float distZ = center.z() - other.z();
        float vX = center.driftX() - other.driftX();
        float delta = distX * vX + distZ * (vZ = center.driftZ() - other.driftZ());
        if (delta > 7.5f) {
            if (center.oceanic() && other.oceanic()) {
                return center.elevation() > other.elevation() ? 6 : 5;
            }
            if (center.oceanic()) {
                return 7;
            }
            if (other.oceanic()) {
                return 8;
            }
            return 11;
        }
        if (delta < -7.5f) {
            if (center.oceanic() && other.oceanic()) {
                return 4;
            }
            if (center.oceanic() || other.oceanic()) {
                return 9;
            }
            return 10;
        }
        return this.plate(center);
    }

    private int plate(Plate center) {
        if (center.oceanic()) {
            return 0;
        }
        if (center.elevation() > 0.7f) {
            return 3;
        }
        if (center.elevation() > 0.3f) {
            return 2;
        }
        return 1;
    }
}

