/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer;

import java.util.Random;
import net.dries007.tfc.world.layer.RegionBiomeLayer;
import net.dries007.tfc.world.layer.RegionEdgeBiomeLayer;
import net.dries007.tfc.world.layer.RegionLayer;
import net.dries007.tfc.world.layer.ShoreLayer;
import net.dries007.tfc.world.layer.SmoothLayer;
import net.dries007.tfc.world.layer.TypedZoomLayer;
import net.dries007.tfc.world.layer.UniformLayer;
import net.dries007.tfc.world.layer.ZoomLayer;
import net.dries007.tfc.world.layer.framework.AreaFactory;
import net.dries007.tfc.world.layer.framework.TypedAreaFactory;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.minecraft.world.level.levelgen.RandomSource;

public final class PLayers {
    public static TypedAreaFactory<Region.Point> createLayers(long seed) {
        RegionGenerator generator = new RegionGenerator(seed);
        TypedAreaFactory<Region.Point> pointLayer = new RegionLayer(generator).apply(seed);
        pointLayer = TypedZoomLayer.normal().apply(seed, pointLayer);
        pointLayer = TypedZoomLayer.normal().apply(seed, pointLayer);
        pointLayer = TypedZoomLayer.normal().apply(seed, pointLayer);
        return pointLayer;
    }

    public static AreaFactory createBiomeLayer(RegionGenerator generator, long seed) {
        Random random = new Random(seed);
        TypedAreaFactory<Region.Point> regionLayer = new RegionLayer(generator).apply(random.nextLong());
        AreaFactory mainLayer = RegionBiomeLayer.INSTANCE.apply(regionLayer);
        mainLayer = RegionEdgeBiomeLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = ShoreLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = ZoomLayer.NORMAL.apply(random.nextLong(), mainLayer);
        mainLayer = SmoothLayer.INSTANCE.apply(random.nextLong(), mainLayer);
        return mainLayer;
    }

    public static AreaFactory createUniformLayer(RandomSource random, int zoomLevels) {
        AreaFactory layer = UniformLayer.INSTANCE.apply(random.nextLong());
        for (int i = 0; i < zoomLevels; ++i) {
            layer = ZoomLayer.NORMAL.apply(random.nextLong(), layer);
        }
        layer = SmoothLayer.INSTANCE.apply(random.nextLong(), layer);
        return layer;
    }
}

