/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.wood.ILeavesBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.feature.tree.ForestConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.jetbrains.annotations.Nullable;

public class ForestFeature
extends Feature<ForestConfig> {
    public ForestFeature(Codec<ForestConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ForestConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random rand = context.m_159776_();
        ForestConfig config = (ForestConfig)context.m_159778_();
        ChunkDataProvider provider = ChunkDataProvider.get(context.m_159775_());
        ChunkData data = provider.get(level, pos);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        ForestType forestType = data.getForestType();
        ForestConfig.Type typeConfig = config.typeMap().get((Object)forestType);
        float density = data.getForestDensity();
        if (rand.nextFloat() > typeConfig.perChunkChance()) {
            return false;
        }
        int treeCount = typeConfig.treeCount().m_142270_(rand);
        int groundCount = typeConfig.groundcoverCount().m_142270_(rand);
        int bushCount = typeConfig.sampleBushCount(rand, typeConfig.bushCount(), treeCount, density);
        boolean placedTrees = false;
        boolean placedBushes = false;
        treeCount = (int)((float)treeCount * (0.6f + 0.9f * density));
        for (int i = 0; i < treeCount; ++i) {
            placedTrees |= this.placeTree(level, context.m_159775_(), rand, pos, config, data, mutablePos, typeConfig);
        }
        for (int j = 0; j < bushCount; ++j) {
            placedBushes |= this.placeBush(level, rand, pos, config, data, mutablePos);
        }
        if (placedTrees) {
            this.placeGroundcover(level, rand, pos, config, data, mutablePos, groundCount);
            this.placeFallenTree(level, rand, pos, config, data, mutablePos);
        }
        return placedTrees || placedBushes;
    }

    private boolean placeTree(WorldGenLevel level, ChunkGenerator generator, Random random, BlockPos chunkBlockPos, ForestConfig config, ChunkData data, BlockPos.MutableBlockPos mutablePos, ForestConfig.Type typeConfig) {
        int chunkX = chunkBlockPos.m_123341_();
        int chunkZ = chunkBlockPos.m_123343_();
        mutablePos.m_122178_(chunkX + random.nextInt(16), 0, chunkZ + random.nextInt(16));
        mutablePos.m_142448_(level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, mutablePos.m_123341_(), mutablePos.m_123343_()));
        ForestConfig.Entry entry = this.getTree(data, random, config, (BlockPos)mutablePos);
        if (entry != null) {
            ConfiguredFeature<?, ?> feature;
            int oldChance = entry.oldGrowthChance();
            int deadChance = entry.deadChance();
            if (typeConfig.allowOldGrowth() && oldChance > 0 && random.nextInt(oldChance) == 0) {
                feature = entry.getOldGrowthFeature();
            } else if (deadChance > 0 && random.nextInt(deadChance) == 0) {
                feature = entry.getDeadFeature();
            } else {
                int spoilerChance = entry.spoilerOldGrowthChance();
                feature = typeConfig.hasSpoilers() && spoilerChance > 0 && random.nextInt(spoilerChance) == 0 ? entry.getOldGrowthFeature() : entry.getFeature();
            }
            return feature.m_65385_(level, generator, random, (BlockPos)mutablePos);
        }
        return false;
    }

    private boolean placeBush(WorldGenLevel level, Random random, BlockPos chunkBlockPos, ForestConfig config, ChunkData data, BlockPos.MutableBlockPos mutablePos) {
        int chunkX = chunkBlockPos.m_123341_();
        int chunkZ = chunkBlockPos.m_123343_();
        mutablePos.m_122178_(chunkX + random.nextInt(16), 0, chunkZ + random.nextInt(16));
        mutablePos.m_142448_(level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, mutablePos.m_123341_(), mutablePos.m_123343_()));
        ForestConfig.Entry entry = this.getTree(data, random, config, (BlockPos)mutablePos);
        if (entry != null && EnvironmentHelpers.canPlaceBushOn(level, (BlockPos)mutablePos)) {
            entry.bushLog().ifPresent(log -> entry.bushLeaves().ifPresent(leaves -> {
                this.placeBushPart(level, mutablePos, (BlockState)log, (BlockState)leaves, 1.0f, random, true);
                for (int i = 0; i < 5; ++i) {
                    if (random.nextInt(4) != 0) continue;
                    mutablePos.m_122173_(Direction.Plane.HORIZONTAL.m_122560_(random));
                    this.placeBushPart(level, mutablePos, (BlockState)leaves, (BlockState)leaves, 0.7f, random, false);
                    if (random.nextInt(6) != 0) continue;
                    mutablePos.m_122173_(Direction.UP);
                    this.placeBushPart(level, mutablePos, (BlockState)leaves, (BlockState)leaves, 0.6f, random, false);
                    break;
                }
            }));
            return true;
        }
        return false;
    }

    private void placeBushPart(WorldGenLevel level, BlockPos.MutableBlockPos mutablePos, BlockState log, BlockState leaves, float decay, Random rand, boolean needsEmptyCenter) {
        if (EnvironmentHelpers.isWorldgenReplaceable(level, (BlockPos)mutablePos)) {
            this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, log);
        } else if (needsEmptyCenter) {
            return;
        }
        for (Direction facing : Helpers.DIRECTIONS) {
            BlockPos offsetPos;
            if (facing == Direction.DOWN || !EnvironmentHelpers.isWorldgenReplaceable(level, offsetPos = mutablePos.m_142082_(facing.m_122429_(), facing.m_122430_(), facing.m_122431_())) || !(rand.nextFloat() < decay)) continue;
            this.m_5974_((LevelWriter)level, offsetPos, leaves);
        }
    }

    private void placeGroundcover(WorldGenLevel level, Random random, BlockPos chunkBlockPos, ForestConfig config, ChunkData data, BlockPos.MutableBlockPos mutablePos, int tries) {
        int chunkX = chunkBlockPos.m_123341_();
        int chunkZ = chunkBlockPos.m_123343_();
        mutablePos.m_122178_(chunkX + random.nextInt(16), 0, chunkZ + random.nextInt(16));
        mutablePos.m_142448_(level.m_6924_(Heightmap.Types.OCEAN_FLOOR, mutablePos.m_123341_(), mutablePos.m_123343_()));
        ForestConfig.Entry entry = this.getTree(data, random, config, (BlockPos)mutablePos);
        if (entry != null) {
            entry.groundcover().ifPresent(groundcover -> {
                for (int j = 0; j < tries; ++j) {
                    BlockState placementState = (BlockState)groundcover.get(random);
                    mutablePos.m_122178_(chunkX + random.nextInt(16), 0, chunkZ + random.nextInt(16));
                    mutablePos.m_142448_(level.m_6924_(Heightmap.Types.OCEAN_FLOOR, mutablePos.m_123341_(), mutablePos.m_123343_()));
                    placementState = FluidHelpers.fillWithFluid(placementState, level.m_6425_((BlockPos)mutablePos).m_76152_());
                    if (placementState == null || !EnvironmentHelpers.isWorldgenReplaceable(level.m_8055_((BlockPos)mutablePos)) || !EnvironmentHelpers.isOnSturdyFace(level, (BlockPos)mutablePos)) continue;
                    this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, placementState);
                }
            });
        }
    }

    private void placeFallenTree(WorldGenLevel level, Random random, BlockPos chunkBlockPos, ForestConfig config, ChunkData data, BlockPos.MutableBlockPos mutablePos) {
        BlockState log;
        int fallChance;
        ForestConfig.Entry entry;
        int chunkX = chunkBlockPos.m_123341_();
        int chunkZ = chunkBlockPos.m_123343_();
        mutablePos.m_122178_(chunkX + random.nextInt(16), 0, chunkZ + random.nextInt(16));
        mutablePos.m_142448_(level.m_6924_(Heightmap.Types.OCEAN_FLOOR, mutablePos.m_123341_(), mutablePos.m_123343_()));
        mutablePos.m_122173_(Direction.DOWN);
        BlockState downState = level.m_8055_((BlockPos)mutablePos);
        mutablePos.m_122173_(Direction.UP);
        if ((Helpers.isBlock(downState, TFCTags.Blocks.BUSH_PLANTABLE_ON) || Helpers.isBlock(downState, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON)) && (entry = this.getTree(data, random, config, (BlockPos)mutablePos)) != null && (fallChance = entry.fallenChance()) > 0 && level.m_5822_().nextInt(fallChance) == 0 && (log = (BlockState)entry.fallenLog().orElse(null)) != null) {
            int left;
            BlockState replaceState;
            int valid;
            Direction axis = Direction.Plane.HORIZONTAL.m_122560_(random);
            log = Helpers.setProperty(log, TFCBlockStateProperties.NATURAL, false);
            log = Helpers.setProperty(log, BlockStateProperties.f_61365_, axis.m_122434_());
            int length = 4 + random.nextInt(10);
            BlockPos start = mutablePos.m_7949_();
            boolean[] moment = new boolean[length];
            mutablePos.m_122190_((Vec3i)start);
            for (valid = 0; valid < length && (EnvironmentHelpers.isWorldgenReplaceable(replaceState = level.m_8055_((BlockPos)mutablePos)) || replaceState.m_60734_() instanceof ILeavesBlock); ++valid) {
                mutablePos.m_122173_(Direction.DOWN);
                moment[valid] = level.m_8055_((BlockPos)mutablePos).m_60783_((BlockGetter)level, (BlockPos)mutablePos, Direction.UP);
                mutablePos.m_122173_(Direction.UP);
                mutablePos.m_122173_(axis);
            }
            int right = valid - 1;
            for (left = 0; left < moment.length && !moment[left]; ++left) {
            }
            while (right >= 0 && !moment[right]) {
                --right;
            }
            if (left <= valid / 2 && right >= valid / 2 && valid >= 3) {
                mutablePos.m_122190_((Vec3i)start);
                for (int i = 0; i < length; ++i) {
                    level.m_7731_((BlockPos)mutablePos, log, 2);
                    mutablePos.m_122173_(axis);
                }
            }
        }
    }

    @Nullable
    private ForestConfig.Entry getTree(ChunkData chunkData, Random random, ForestConfig config, BlockPos pos) {
        int index;
        ArrayList entries = new ArrayList(4);
        float rainfall = chunkData.getRainfall(pos);
        float averageTemperature = chunkData.getAverageTemp(pos);
        config.entries().m_203614_().map(configuredFeature -> ((ConfiguredFeature)configuredFeature.m_203334_()).f_65378_()).map(cfg -> (ForestConfig.Entry)cfg).forEach(entry -> {
            float lastRain = entry.getAverageRain();
            float lastTemp = entry.getAverageTemp();
            if (entry.isValid(averageTemperature, rainfall)) {
                if (entry.distanceFromMean(lastTemp, lastRain) < entry.distanceFromMean(averageTemperature, rainfall)) {
                    entries.add(entry);
                } else {
                    entries.add(0, entry);
                }
            }
        });
        if (entries.isEmpty()) {
            return null;
        }
        if (config.useWeirdness()) {
            float weirdness = chunkData.getForestWeirdness();
            Collections.rotate(entries, -((int)(weirdness * ((float)entries.size() - 1.0f))));
            for (int i = 1; i >= -1 && entries.size() > 1; --i) {
                if (!(random.nextFloat() > weirdness - 0.15f * (float)i + 0.1f)) continue;
                entries.remove(entries.size() - 1);
            }
        }
        for (index = 0; index < entries.size() - 1 && random.nextFloat() < 0.6f; ++index) {
        }
        return (ForestConfig.Entry)entries.get(index);
    }

    public static class Entry
    extends Feature<ForestConfig.Entry> {
        public Entry(Codec<ForestConfig.Entry> codec) {
            super(codec);
        }

        public boolean m_142674_(FeaturePlaceContext<ForestConfig.Entry> context) {
            throw new IllegalArgumentException("This is not a real feature and should never be placed!");
        }
    }
}

