/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.cave;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.OverworldClimateModel;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class IceCaveFeature
extends Feature<NoneFeatureConfiguration> {
    public IceCaveFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random rand = context.m_159776_();
        OverworldClimateModel model = OverworldClimateModel.getIfPresent(level);
        if (model == null) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkDataProvider provider = ChunkDataProvider.get(context.m_159775_());
        ChunkData chunkData = provider.get(level, chunkPos);
        for (int i = 0; i < 72; ++i) {
            mutablePos.m_122154_((Vec3i)pos, rand.nextInt(15) - rand.nextInt(15), -3, rand.nextInt(15) - rand.nextInt(15));
            float maxTemperature = model.getAverageMonthlyTemperature(mutablePos.m_123343_(), mutablePos.m_123342_(), chunkData.getAverageTemp((BlockPos)mutablePos), 1.0f);
            if (maxTemperature > -4.0f) {
                return false;
            }
            if (level.m_8055_((BlockPos)mutablePos).m_60734_() == Blocks.f_50627_) {
                for (int j = 0; j < 7; ++j) {
                    mutablePos.m_122184_(0, -1, 0);
                    if (!level.m_46859_((BlockPos)mutablePos)) break;
                }
                BlockState finalState = level.m_8055_((BlockPos)mutablePos);
                mutablePos.m_122173_(Direction.UP);
                if (Helpers.isBlock(finalState, (TagKey<Block>)BlockTags.f_13061_)) {
                    this.placeDisc(level, mutablePos, rand);
                } else if (Helpers.isBlock(finalState, (TagKey<Block>)BlockTags.f_13047_) && rand.nextFloat() < 0.03f) {
                    this.placeDisc(level, mutablePos, rand);
                }
            } else if (mutablePos.m_123342_() < 96 && rand.nextFloat() < 0.1f) {
                mutablePos.m_122175_(Direction.UP, 5);
                if (!level.m_46859_((BlockPos)mutablePos)) {
                    mutablePos.m_122175_(Direction.DOWN, 3);
                    if (level.m_46859_((BlockPos)mutablePos)) {
                        this.placeSphere(level, mutablePos, rand);
                    }
                }
            }
            if (rand.nextFloat() < 0.002f) {
                mutablePos.m_142448_(4 + rand.nextInt(7));
                if (level.m_46859_((BlockPos)mutablePos)) {
                    mutablePos.m_122173_(Direction.UP);
                    if (Helpers.isBlock(level.m_8055_((BlockPos)mutablePos), (TagKey<Block>)BlockTags.f_13061_)) {
                        this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, Fluids.f_76193_.m_76145_().m_76188_());
                        level.m_186469_((BlockPos)mutablePos, (Fluid)Fluids.f_76193_, 0);
                    }
                }
            }
            if (!(rand.nextFloat() < 0.03f) || mutablePos.m_123342_() >= 96 || !Helpers.isBlock(level.m_8055_((BlockPos)mutablePos), (TagKey<Block>)BlockTags.f_13061_)) continue;
            mutablePos.m_122173_(Direction.DOWN);
            if (level.m_46859_((BlockPos)mutablePos)) {
                this.placeSpike(level, mutablePos, rand, Direction.DOWN);
                continue;
            }
            mutablePos.m_122175_(Direction.UP, 2);
            if (!level.m_46859_((BlockPos)mutablePos)) continue;
            this.placeSpike(level, mutablePos, rand, Direction.UP);
        }
        return true;
    }

    private void placeSpike(WorldGenLevel world, BlockPos.MutableBlockPos mutablePos, Random rand, Direction direction) {
        BlockState state = this.getState(rand);
        BlockPos pos = mutablePos.m_7949_();
        int height = 6 + rand.nextInt(11);
        int radius = 2 + rand.nextInt(1);
        int maxHeightReached = 0;
        for (int y = -3; y <= height; ++y) {
            float radiusSquared = (float)radius * (1.0f - 1.5f * (float)Math.abs(y) / (float)height);
            if (radiusSquared < 0.0f) continue;
            radiusSquared *= radiusSquared;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    mutablePos.m_122190_((Vec3i)pos).m_122184_(x, y * direction.m_122430_(), z);
                    float actualRadius = (float)(x * x + z * z) / radiusSquared;
                    if ((double)actualRadius < 0.7) {
                        this.m_5974_((LevelWriter)world, (BlockPos)mutablePos, state);
                        if (x != 0 || z != 0) continue;
                        maxHeightReached = y;
                        continue;
                    }
                    if (!((double)actualRadius < 0.85) || !rand.nextBoolean() || world.m_8055_(mutablePos.m_142082_(0, -direction.m_122430_(), 0)) != state) continue;
                    this.m_5974_((LevelWriter)world, (BlockPos)mutablePos, state);
                }
            }
        }
        mutablePos.m_122190_((Vec3i)pos).m_122175_(direction, maxHeightReached - 1);
    }

    private void placeDisc(WorldGenLevel world, BlockPos.MutableBlockPos mutablePos, Random rand) {
        float radius = 1.0f + rand.nextFloat() * rand.nextFloat() * 3.5f;
        float radiusSquared = radius * radius;
        int size = Mth.m_14167_((float)radius);
        BlockPos pos = mutablePos.m_7949_();
        BlockState ice = this.getState(rand);
        for (Direction d : Direction.Plane.HORIZONTAL) {
            mutablePos.m_122173_(d);
            mutablePos.m_122175_(Direction.DOWN, 2);
            if (world.m_46859_((BlockPos)mutablePos)) {
                return;
            }
            mutablePos.m_122173_(d.m_122424_());
            mutablePos.m_122175_(Direction.UP, 2);
        }
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                if (!((float)(x * x + z * z) <= radiusSquared)) continue;
                mutablePos.m_122190_((Vec3i)pos).m_122184_(x, -1, z);
                if (!world.m_46859_((BlockPos)mutablePos)) {
                    mutablePos.m_122173_(Direction.UP);
                }
                this.m_5974_((LevelWriter)world, (BlockPos)mutablePos, ice);
            }
        }
    }

    private void placeSphere(WorldGenLevel world, BlockPos.MutableBlockPos mutablePos, Random rand) {
        float radius = 1.0f + rand.nextFloat() * rand.nextFloat() * 3.0f;
        float radiusSquared = radius * radius;
        int size = Mth.m_14167_((float)radius);
        BlockPos pos = mutablePos.m_7949_();
        BlockState ice = Blocks.f_50126_.m_49966_();
        for (int x = -size; x <= size; ++x) {
            for (int y = -size; y <= size; ++y) {
                for (int z = -size; z <= size; ++z) {
                    if (!((float)(x * x + y * y + z * z) <= radiusSquared)) continue;
                    mutablePos.m_122190_((Vec3i)pos).m_122184_(x, y, z);
                    if (!world.m_46859_((BlockPos)mutablePos)) continue;
                    this.m_5974_((LevelWriter)world, (BlockPos)mutablePos, ice);
                }
            }
        }
    }

    private BlockState getState(Random rand) {
        if (rand.nextFloat() < 0.4f) {
            return Blocks.f_50354_.m_49966_();
        }
        return Blocks.f_50568_.m_49966_();
    }
}

