/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.cave;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.RockSpikeBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkGeneratorExtension;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class CaveSpikesFeature
extends Feature<NoneFeatureConfiguration> {
    public CaveSpikesFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        Direction direction;
        BlockState wallState;
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random random = context.m_159776_();
        RockLayerSettings rockSettings = ((ChunkGeneratorExtension)context.m_159775_()).getRockLayerSettings();
        RockSettings wallRock = rockSettings.getRock((wallState = level.m_8055_(pos.m_142300_((direction = random.nextBoolean() ? Direction.UP : Direction.DOWN).m_122424_()))).m_60734_());
        if (wallRock != null && wallRock.isRawOrHardened(wallState)) {
            this.placeIfPresent(level, pos, direction, random, wallRock);
        } else {
            wallState = level.m_8055_(pos.m_142300_(direction = direction.m_122424_()));
            wallRock = rockSettings.getRock(wallState.m_60734_());
            if (wallRock != null && wallRock.isRawOrHardened(wallState)) {
                this.placeIfPresent(level, pos, direction, random, wallRock);
            }
        }
        return true;
    }

    protected void place(WorldGenLevel level, BlockPos pos, BlockState spike, BlockState raw, Direction direction, Random random) {
        this.placeSmallSpike(level, pos, spike, raw, direction, random);
    }

    protected void placeSmallSpike(WorldGenLevel level, BlockPos pos, BlockState spike, BlockState raw, Direction direction, Random random) {
        this.placeSmallSpike(level, pos, spike, raw, direction, random, random.nextFloat());
    }

    protected void placeSmallSpike(WorldGenLevel level, BlockPos pos, BlockState spike, BlockState raw, Direction direction, Random random, float sizeWeight) {
        BlockPos above = pos.m_7494_();
        BlockState stateAbove = level.m_8055_(pos.m_7494_());
        if (Helpers.isBlock(stateAbove, (TagKey<Block>)BlockTags.f_13061_)) {
            level.m_7731_(above, raw, 2);
        }
        if (sizeWeight < 0.2f) {
            this.replaceBlock(level, pos, (BlockState)spike.m_61124_(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.MIDDLE)));
            this.replaceBlock(level, pos.m_5484_(direction, 1), (BlockState)spike.m_61124_(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.TIP)));
        } else if (sizeWeight < 0.7f) {
            this.replaceBlock(level, pos, (BlockState)spike.m_61124_(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.BASE)));
            this.replaceBlock(level, pos.m_5484_(direction, 1), (BlockState)spike.m_61124_(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.MIDDLE)));
            this.replaceBlock(level, pos.m_5484_(direction, 2), (BlockState)spike.m_61124_(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.TIP)));
        } else {
            this.replaceBlockWithoutFluid(level, pos, raw);
            this.replaceBlock(level, pos.m_5484_(direction, 1), (BlockState)spike.m_61124_(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.BASE)));
            this.replaceBlock(level, pos.m_5484_(direction, 2), (BlockState)spike.m_61124_(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.MIDDLE)));
            this.replaceBlock(level, pos.m_5484_(direction, 3), (BlockState)spike.m_61124_(RockSpikeBlock.PART, (Comparable)((Object)RockSpikeBlock.Part.TIP)));
        }
    }

    protected void replaceBlock(WorldGenLevel level, BlockPos pos, BlockState state) {
        Block block = level.m_8055_(pos).m_60734_();
        if (block == Blocks.f_50627_) {
            this.m_5974_((LevelWriter)level, pos, state);
        } else if (block == Blocks.f_49990_ || block == TFCBlocks.RIVER_WATER.get()) {
            this.m_5974_((LevelWriter)level, pos, (BlockState)state.m_61124_((Property)RockSpikeBlock.FLUID, (Comparable)RockSpikeBlock.FLUID.keyFor((Fluid)Fluids.f_76193_)));
        } else if (block == Blocks.f_49991_) {
            this.m_5974_((LevelWriter)level, pos, (BlockState)state.m_61124_((Property)RockSpikeBlock.FLUID, (Comparable)RockSpikeBlock.FLUID.keyFor((Fluid)Fluids.f_76195_)));
        }
    }

    protected void replaceBlockWithoutFluid(WorldGenLevel level, BlockPos pos, BlockState state) {
        Block block = level.m_8055_(pos).m_60734_();
        if (block == Blocks.f_50627_ || block == Blocks.f_49990_ || block == TFCBlocks.RIVER_WATER.get() || block == Blocks.f_49991_) {
            this.m_5974_((LevelWriter)level, pos, state);
        }
    }

    private void placeIfPresent(WorldGenLevel level, BlockPos pos, Direction direction, Random random, RockSettings wallRock) {
        wallRock.spike().ifPresent(spike -> this.place(level, pos, spike.m_49966_(), wallRock.hardened().m_49966_(), direction, random));
    }
}

