/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import java.util.List;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class RockData {
    private static final int SIZE = 256;
    private final RockSettings[] bottomLayer;
    private final RockSettings[] middleLayer;
    private final RockSettings[] topLayer;
    private final int[] rockLayerHeight;
    private int @Nullable [] surfaceHeight;

    private static int index(int x, int z) {
        return x & 0xF | (z & 0xF) << 4;
    }

    public RockData(RockSettings[] bottomLayer, RockSettings[] middleLayer, RockSettings[] topLayer, int[] rockLayerHeight) {
        this.bottomLayer = bottomLayer;
        this.middleLayer = middleLayer;
        this.topLayer = topLayer;
        this.rockLayerHeight = rockLayerHeight;
        this.surfaceHeight = null;
    }

    public RockData(CompoundTag nbt, RockLayerSettings settings) {
        this.bottomLayer = new RockSettings[256];
        this.middleLayer = new RockSettings[256];
        this.topLayer = new RockSettings[256];
        this.read(this.bottomLayer, nbt.m_128465_("bottomLayer"), settings);
        this.read(this.middleLayer, nbt.m_128465_("middleLayer"), settings);
        this.read(this.topLayer, nbt.m_128465_("topLayer"), settings);
        this.rockLayerHeight = nbt.m_128465_("height");
        this.surfaceHeight = nbt.m_128441_("surfaceHeight") ? nbt.m_128465_("surfaceHeight") : null;
    }

    public RockSettings getRock(BlockPos pos) {
        return this.getRock(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public RockSettings getRock(int x, int y, int z) {
        int rh;
        assert (this.surfaceHeight != null);
        int i = RockData.index(x, z);
        int sh = this.surfaceHeight[i];
        if (y > (int)(109.0 - 0.2 * (double)sh + (double)(rh = this.rockLayerHeight[i]))) {
            return this.topLayer[i];
        }
        if (y > (int)(29.0 - 0.2 * (double)sh + (double)rh)) {
            return this.middleLayer[i];
        }
        return this.bottomLayer[i];
    }

    public RockSettings getBottomRock(int x, int z) {
        return this.bottomLayer[RockData.index(x, z)];
    }

    public void setSurfaceHeight(int[] surfaceHeightMap) {
        this.surfaceHeight = surfaceHeightMap;
    }

    public CompoundTag write(RockLayerSettings settings) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128385_("bottomLayer", this.write(this.bottomLayer, settings));
        nbt.m_128385_("middleLayer", this.write(this.middleLayer, settings));
        nbt.m_128385_("topLayer", this.write(this.topLayer, settings));
        nbt.m_128385_("height", this.rockLayerHeight);
        if (this.surfaceHeight != null) {
            nbt.m_128385_("surfaceHeight", this.surfaceHeight);
        }
        return nbt;
    }

    private int[] write(RockSettings[] layer, RockLayerSettings settings) {
        int[] array = new int[256];
        List<RockSettings> palette = settings.getRocks();
        for (int i = 0; i < array.length; ++i) {
            array[i] = palette.indexOf(layer[i]);
        }
        return array;
    }

    private void read(RockSettings[] layer, int[] data, RockLayerSettings settings) {
        assert (data.length == 256);
        List<RockSettings> palette = settings.getRocks();
        for (int i = 0; i < data.length; ++i) {
            layer[i] = palette.get(data[i]);
        }
    }
}

