/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class LerpFloatLayer {
    private final float valueNW;
    private final float valueNE;
    private final float valueSW;
    private final float valueSE;

    public LerpFloatLayer(FriendlyByteBuf buffer) {
        this.valueNW = buffer.readFloat();
        this.valueNE = buffer.readFloat();
        this.valueSW = buffer.readFloat();
        this.valueSE = buffer.readFloat();
    }

    public LerpFloatLayer(CompoundTag nbt) {
        this.valueNW = nbt.m_128457_("nw");
        this.valueNE = nbt.m_128457_("ne");
        this.valueSW = nbt.m_128457_("sw");
        this.valueSE = nbt.m_128457_("se");
    }

    public LerpFloatLayer(float valueNW, float valueNE, float valueSW, float valueSE) {
        this.valueNW = valueNW;
        this.valueNE = valueNE;
        this.valueSW = valueSW;
        this.valueSE = valueSE;
    }

    public float getValue(float tNS, float tEW) {
        return Helpers.lerp4(this.valueNE, this.valueNW, this.valueSE, this.valueSW, tNS, tEW);
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("nw", this.valueNW);
        nbt.m_128350_("ne", this.valueNE);
        nbt.m_128350_("sw", this.valueSW);
        nbt.m_128350_("se", this.valueSE);
        return nbt;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.valueNW);
        buffer.writeFloat(this.valueNE);
        buffer.writeFloat(this.valueSW);
        buffer.writeFloat(this.valueSE);
    }
}

