/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.dries007.tfc.world.FeatureCycleDetector;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeSourceExtension;
import net.dries007.tfc.world.biome.LegacyBiomeSource;
import net.dries007.tfc.world.biome.RegionBiomeSource;
import net.dries007.tfc.world.biome.RiverSource;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.chunkdata.TFCChunkDataGenerator;
import net.dries007.tfc.world.settings.ClimateSettings;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraftforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public abstract class TFCBiomeSource
extends BiomeSource
implements BiomeSourceExtension,
RiverSource {
    public static final DeferredRegister<Codec<? extends BiomeSource>> BIOME_SOURCE = DeferredRegister.create((ResourceKey)Registry.f_122852_, (String)"tfc");
    protected final BiomeSourceExtension.Settings settings;
    protected final Registry<Biome> biomeRegistry;
    protected final Supplier<List<BiomeSource.StepFeatureData>> customFeaturesPerStep;
    protected final ChunkDataProvider chunkDataProvider;

    public static TFCBiomeSource defaultBiomeSource(long seed, Registry<Biome> biomeRegistry) {
        BiomeSourceExtension.Settings settings = new BiomeSourceExtension.Settings(seed, 8000, 0, 0, RockLayerSettings.getDefault(), ClimateSettings.DEFAULT, ClimateSettings.DEFAULT);
        return new LegacyBiomeSource(settings, biomeRegistry);
    }

    protected TFCBiomeSource(BiomeSourceExtension.Settings settings, Registry<Biome> biomeRegistry, TFCChunkDataGenerator chunkDataGenerator, Collection<ResourceKey<Biome>> allBiomes) {
        this(settings, biomeRegistry, chunkDataGenerator, allBiomes.stream().map(arg_0 -> biomeRegistry.m_206081_(arg_0)).toList());
    }

    private TFCBiomeSource(BiomeSourceExtension.Settings settings, Registry<Biome> biomeRegistry, TFCChunkDataGenerator chunkDataGenerator, List<Holder<Biome>> allBiomes) {
        super(allBiomes);
        this.settings = settings;
        this.biomeRegistry = biomeRegistry;
        this.customFeaturesPerStep = Suppliers.memoize(() -> FeatureCycleDetector.buildFeaturesPerStep(allBiomes));
        this.chunkDataProvider = new ChunkDataProvider(chunkDataGenerator, settings.rockLayerSettings());
    }

    @Override
    public BiomeSourceExtension.Settings settings() {
        return this.settings;
    }

    @Override
    public ChunkDataProvider getChunkDataProvider() {
        return this.chunkDataProvider;
    }

    public Holder<Biome> m_203407_(int quartX, int quartY, int quartZ, @Nullable Climate.Sampler sampler) {
        return this.getNoiseBiome(quartX, quartZ);
    }

    @Override
    public Holder<Biome> getNoiseBiome(int quartX, int quartZ) {
        return this.biomeRegistry.m_206081_(this.getNoiseBiomeVariants(quartX, quartZ).key());
    }

    @Override
    public Holder<Biome> getBiome(BiomeExtension variants) {
        return this.biomeRegistry.m_206081_(variants.key());
    }

    public List<BiomeSource.StepFeatureData> m_186733_() {
        return this.customFeaturesPerStep.get();
    }

    public abstract TFCBiomeSource withSeed(long var1);

    @Nullable
    public Pair<BlockPos, Holder<Biome>> m_207481_(int blockX, int blockY, int blockZ, int maxRadius, int step, Predicate<Holder<Biome>> biome, Random random, boolean findClosest, @Nullable Climate.Sampler sampler) {
        int radius;
        int minQuartX = QuartPos.m_175400_((int)blockX);
        int minQuartZ = QuartPos.m_175400_((int)blockZ);
        int maxQuartRadius = QuartPos.m_175400_((int)maxRadius);
        Pair pair = null;
        int count = 0;
        int n = radius = findClosest ? 0 : maxQuartRadius;
        while (radius <= maxQuartRadius) {
            for (int dz = -radius; dz <= radius; dz += step) {
                boolean atZEdge = Math.abs(dz) == radius;
                for (int dx = -radius; dx <= radius; dx += step) {
                    int z;
                    int x;
                    Holder<Biome> found;
                    if (findClosest) {
                        boolean atXEdge;
                        boolean bl = atXEdge = Math.abs(dx) == radius;
                        if (!atXEdge && !atZEdge) continue;
                    }
                    if (!biome.test(found = this.getNoiseBiome(x = minQuartX + dx, z = minQuartZ + dz))) continue;
                    if (pair == null || random.nextInt(count + 1) == 0) {
                        BlockPos pos = new BlockPos(QuartPos.m_175402_((int)x), blockY, QuartPos.m_175402_((int)z));
                        if (findClosest) {
                            return Pair.of((Object)pos, found);
                        }
                        pair = Pair.of((Object)pos, found);
                    }
                    ++count;
                }
            }
            radius += step;
        }
        return pair;
    }

    static {
        BIOME_SOURCE.register("overworld", () -> LegacyBiomeSource.CODEC);
        BIOME_SOURCE.register("continental", () -> RegionBiomeSource.CODEC);
    }
}

