/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import java.util.Random;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.biome.VolcanoNoise;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.noise.OpenSimplex3D;
import net.minecraft.util.Mth;

public final class BiomeNoise {
    public static Noise2D badlands(long seed) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.025f).scaled(85.0f, 95.0f).add(new OpenSimplex2D(seed + 1L).octaves(4).spread(0.04f).ridged().map(x -> 1.3f * -(x > 0.0f ? x * x * x : 0.5f * x)).scaled(-1.0f, 0.3f, -1.0f, 1.0f).terraces(15).scaled(-19.5f, 0.0f)).map(x -> x < 63.0f ? 63.0f - 0.3f * (63.0f - x) : x);
    }

    public static Noise2D bryceCanyon(long seed) {
        Random generator = new Random(seed);
        Noise2D noise = new OpenSimplex2D(generator.nextLong()).octaves(4).spread(0.1f).scaled(65.0f, 77.0f);
        for (int layer = 0; layer < 3; ++layer) {
            float threshold = 0.25f;
            float delta = 0.015f;
            noise = noise.add(new OpenSimplex2D(generator.nextLong()).octaves(3).spread(0.02f + 0.01f * (float)layer).abs().affine(1.0f, -0.05f * (float)layer).map(t -> Mth.m_184631_((float)t, (float)0.25f, (float)0.265f, (float)0.0f, (float)1.0f)).lazyProduct(new OpenSimplex2D(generator.nextLong()).octaves(4).spread(0.1f).scaled(5.0f, 11.0f)));
        }
        return noise;
    }

    public static Noise2D canyons(long seed, int minHeight, int maxHeight) {
        OpenSimplex2D warp = new OpenSimplex2D(seed).octaves(4).spread(0.03f).scaled(-100.0f, 100.0f);
        return new OpenSimplex2D(seed + 1L).octaves(4).spread(0.06f).warped(warp).map(x -> (double)x > 0.4 ? x - 0.8f : -x).scaled(-0.4f, 0.8f, 63 + minHeight, 63 + maxHeight);
    }

    public static Noise2D hills(long seed, int minHeight, int maxHeight) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.05f).scaled(63 + minHeight, 63 + maxHeight);
    }

    public static Noise2D lake(long seed) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.15f).scaled(51.0f, 61.0f);
    }

    public static Noise2D river(long seed) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.2f).scaled(55.0f, 61.0f);
    }

    public static BiomeNoiseSampler riverSampler(long seed) {
        final OpenSimplex2D riverHeight = new OpenSimplex2D(seed).octaves(4).spread(0.2f).scaled(52.0f, 58.0f);
        final OpenSimplex3D cliffNoise = new OpenSimplex3D(seed).octaves(2).spread(0.1f).scaled(0.0f, 3.0f);
        return new BiomeNoiseSampler(){
            private double height;
            private int x;
            private int z;

            @Override
            public void setColumn(int x, int z) {
                this.height = riverHeight.noise(x, z);
                this.x = x;
                this.z = z;
            }

            @Override
            public double height() {
                return this.height;
            }

            @Override
            public double noise(int y) {
                if (y > 83) {
                    return 0.0;
                }
                if (y > 73) {
                    double easing = 1.0f - (float)(y - 63 - 10) / 10.0f;
                    return easing * (double)cliffNoise.noise(this.x, y, this.z);
                }
                if (y > 63) {
                    return cliffNoise.noise(this.x, y, this.z);
                }
                if (y > 55) {
                    double easing = (double)(y - 63 + 8) / 8.0;
                    return easing * (double)cliffNoise.noise(this.x, y, this.z);
                }
                return 0.0;
            }
        };
    }

    public static Noise2D lowlands(long seed) {
        return new OpenSimplex2D(seed).octaves(6).spread(0.55f).scaled(58.0f, 65.0f).clamped(61.0f, 65.0f);
    }

    public static Noise2D mountains(long seed, int baseHeight, int scaleHeight) {
        Noise2D baseNoise = new OpenSimplex2D(seed).octaves(6).spread(0.14f).add(new OpenSimplex2D(seed + 1L).octaves(4).spread(0.02f).scaled(-0.7f, 0.7f).ridged()).map(x -> {
            float x0 = 0.125f * (x + 1.0f) * (x + 1.0f) * (x + 1.0f);
            return (float)(63 + baseHeight) + (float)scaleHeight * x0;
        });
        Noise2D cliffNoise = new OpenSimplex2D(seed + 2L).octaves(2).spread(0.01f).scaled(-25.0f, 25.0f).map(x -> x > 0.0f ? x : 0.0f);
        OpenSimplex2D cliffHeightNoise = new OpenSimplex2D(seed + 3L).octaves(2).spread(0.01f).scaled(120.0f, 160.0f);
        return (x, z) -> {
            float cliffHeight;
            float height = baseNoise.noise(x, z);
            if (height > 120.0f && (cliffHeight = cliffHeightNoise.noise(x, z) - height) < 0.0f) {
                float mappedCliffHeight = Mth.m_184631_((float)cliffHeight, (float)0.0f, (float)-1.0f, (float)0.0f, (float)1.0f);
                height += mappedCliffHeight * cliffNoise.noise(x, z);
            }
            return height;
        };
    }

    public static Noise2D ocean(long seed, int depthMin, int depthMax) {
        OpenSimplex2D warp = new OpenSimplex2D(seed).octaves(2).spread(0.015f).scaled(-30.0f, 30.0f);
        return new OpenSimplex2D(seed + 1L).octaves(4).spread(0.11f).scaled(63 + depthMin, 63 + depthMax).warped(warp);
    }

    public static Noise2D oceanRidge(long seed, int depthMin, int depthMax) {
        OpenSimplex2D warp = new OpenSimplex2D(seed).octaves(2).spread(0.015f).scaled(-30.0f, 30.0f);
        Noise2D ridgeNoise = new OpenSimplex2D(seed + 1L).octaves(4).spread(0.015f).ridged().map(x -> {
            if (x > -0.3f) {
                x = (x + 0.3f) / 1.3f;
                x = x * x * x;
                return -16.0f * x;
            }
            return 0.0f;
        });
        return new OpenSimplex2D(seed + 2L).octaves(4).spread(0.11f).scaled(63 + depthMin, 63 + depthMax).add(ridgeNoise).warped(warp);
    }

    public static Noise2D shore(long seed) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.17f).scaled(63.0f, 64.8f);
    }

    public static Noise2D addVolcanoes(long seed, Noise2D baseNoise, int rarity, int baseVolcanoHeight, int scaleVolcanoHeight) {
        VolcanoNoise volcanoes = new VolcanoNoise(seed);
        return (x, z) -> volcanoes.modifyHeight(x, z, baseNoise.noise(x, z), rarity, baseVolcanoHeight, scaleVolcanoHeight);
    }

    public static BiomeNoiseSampler undergroundRivers(long seed, Noise2D heightNoise) {
        OpenSimplex2D carvingCenterNoise = new OpenSimplex2D(seed).octaves(2).spread(0.02f).scaled(60.0f, 66.0f);
        OpenSimplex2D carvingHeightNoise = new OpenSimplex2D(seed + 1L).octaves(4).spread(0.15f).scaled(8.0f, 14.0f);
        return BiomeNoiseSampler.fromHeightAndCarvingNoise(heightNoise, carvingCenterNoise, carvingHeightNoise);
    }

    public static BiomeNoiseSampler undergroundLakes(long seed, final Noise2D heightNoise) {
        final Noise2D blobsNoise = new OpenSimplex2D(seed + 1L).spread(0.04f).abs();
        final OpenSimplex2D depthNoise = new OpenSimplex2D(seed + 2L).octaves(4).scaled(2.0f, 18.0f).spread(0.2f);
        final OpenSimplex2D centerNoise = new OpenSimplex2D(seed + 3L).octaves(2).spread(0.06f).scaled(59.0f, 67.0f);
        return new BiomeNoiseSampler(){
            private float surfaceHeight;
            private float center;
            private float height;

            @Override
            public void setColumn(int x, int z) {
                float h0 = Mth.m_14036_((float)((0.7f - blobsNoise.noise(x, z)) * 3.3333333f), (float)0.0f, (float)1.0f);
                float h1 = depthNoise.noise(x, z);
                this.surfaceHeight = heightNoise.noise(x, z);
                this.center = centerNoise.noise(x, z);
                this.height = h0 * h1;
            }

            @Override
            public double height() {
                return this.surfaceHeight;
            }

            @Override
            public double noise(int y) {
                float delta = Math.abs(this.center - (float)y);
                return Mth.m_14036_((float)(0.4f + 0.05f * (this.height - delta)), (float)0.0f, (float)1.0f);
            }
        };
    }
}

