/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import java.util.Arrays;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.ChunkBaseBlockSource;
import net.dries007.tfc.world.noise.Cellular3D;
import net.dries007.tfc.world.noise.ChunkNoiseSamplingSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.Nullable;

public class TFCAquifer
implements Aquifer {
    private static final int GRID_WIDTH = 16;
    private static final int GRID_HEIGHT = 12;
    private static final int XZ_RANGE = 10;
    private static final int Y_RANGE = 8;
    private static final double FLOWING_UPDATE_SIMILARITY = TFCAquifer.similarity(Mth.m_144944_((int)10), Mth.m_144944_((int)12));
    private final int minGridX;
    private final int minGridY;
    private final int minGridZ;
    private final int gridSizeX;
    private final int gridSizeZ;
    private final int minChunkX;
    private final int minChunkZ;
    private final int minY;
    private final PositionalRandomFactory fork;
    private final ChunkBaseBlockSource baseBlockSource;
    private final NormalNoise barrierNoise;
    private final long fluidCellSeed;
    private final Cellular3D fluidCellNoise;
    private final AquiferEntry lavaLevelAquifer;
    private final AquiferEntry seaLevelAquifer;
    private final AquiferEntry[] aquifers;
    private final long[] aquiferLocations;
    private int[] surfaceHeights;
    private boolean shouldScheduleFluidUpdate;

    private static int gridXZ(int xz) {
        return Math.floorDiv(xz, 16);
    }

    private static int gridY(int y) {
        return Math.floorDiv(y, 12);
    }

    private static double similarity(int firstDistance, int secondDistance) {
        return 1.0 - (double)Math.abs(secondDistance - firstDistance) / 25.0;
    }

    public TFCAquifer(ChunkPos chunkPos, ChunkNoiseSamplingSettings settings, ChunkBaseBlockSource baseBlockSource, int seaLevel, PositionalRandomFactory fork, NormalNoise barrierNoise) {
        int maxGridX = TFCAquifer.gridXZ(chunkPos.m_45608_()) + 1;
        int maxGridY = TFCAquifer.gridY((settings.firstCellY() + settings.cellCountY()) * settings.cellHeight()) + 1;
        int maxGridZ = TFCAquifer.gridXZ(chunkPos.m_45609_()) + 1;
        this.minGridX = TFCAquifer.gridXZ(chunkPos.m_45604_()) - 1;
        this.minGridY = TFCAquifer.gridY(settings.firstCellY() * settings.cellHeight()) - 1;
        this.minGridZ = TFCAquifer.gridXZ(chunkPos.m_45605_()) - 1;
        this.gridSizeX = maxGridX - this.minGridX + 1;
        int gridSizeY = maxGridY - this.minGridY + 1;
        this.gridSizeZ = maxGridZ - this.minGridZ + 1;
        this.minChunkX = chunkPos.m_45604_();
        this.minY = settings.minY();
        this.minChunkZ = chunkPos.m_45605_();
        this.surfaceHeights = new int[16];
        this.baseBlockSource = baseBlockSource;
        this.fork = fork;
        this.barrierNoise = barrierNoise;
        RandomSource fluidCellNoiseFork = fork.m_183211_("aquifer_fluid_cell_noise");
        this.fluidCellSeed = fluidCellNoiseFork.nextLong();
        this.fluidCellNoise = new Cellular3D(fluidCellNoiseFork.nextLong()).spread(0.015f);
        this.lavaLevelAquifer = new AquiferEntry(Blocks.f_49991_.m_49966_(), this.minY + 10);
        this.seaLevelAquifer = new AquiferEntry(Blocks.f_49990_.m_49966_(), seaLevel);
        this.aquifers = new AquiferEntry[this.gridSizeX * gridSizeY * this.gridSizeZ];
        this.aquiferLocations = new long[this.gridSizeX * gridSizeY * this.gridSizeZ];
        Arrays.fill(this.aquiferLocations, Long.MAX_VALUE);
    }

    public int[] getSurfaceHeights() {
        return this.surfaceHeights;
    }

    public void setSurfaceHeights(int[] surfaceHeights) {
        this.surfaceHeights = surfaceHeights;
    }

    @Nullable
    public BlockState m_207104_(DensityFunction.FunctionContext context, double baseNoise) {
        return this.sampleState(context.m_207115_(), context.m_207114_(), context.m_207113_(), baseNoise);
    }

    @Nullable
    public BlockState sampleState(int x, int y, int z, double terrainNoise) {
        if (terrainNoise <= 0.0) {
            boolean isSurfaceLevelAquifer;
            double aquiferNoiseContribution;
            BlockState state;
            AquiferEntry global = this.globalAquifer(y);
            if (Helpers.isBlock(global.at(y), Blocks.f_49991_)) {
                state = Blocks.f_49991_.m_49966_();
                aquiferNoiseContribution = 0.0;
                isSurfaceLevelAquifer = false;
                this.shouldScheduleFluidUpdate = false;
            } else {
                int lowerGridX = Math.floorDiv(x - 5, 16);
                int lowerGridY = Math.floorDiv(y, 12);
                int lowerGridZ = Math.floorDiv(z - 5, 16);
                int distance1 = Integer.MAX_VALUE;
                int distance2 = Integer.MAX_VALUE;
                int distance3 = Integer.MAX_VALUE;
                long aquifer1 = 0L;
                long aquifer2 = 0L;
                long aquifer3 = 0L;
                for (int offsetGridX = 0; offsetGridX <= 1; ++offsetGridX) {
                    for (int offsetGridY = -1; offsetGridY <= 1; ++offsetGridY) {
                        for (int offsetGridZ = 0; offsetGridZ <= 1; ++offsetGridZ) {
                            int dz;
                            int dy;
                            int dx;
                            int distance;
                            int adjGridX = lowerGridX + offsetGridX;
                            int adjGridY = lowerGridY + offsetGridY;
                            int adjGridZ = lowerGridZ + offsetGridZ;
                            int adjIndex = this.getIndex(adjGridX, adjGridY, adjGridZ);
                            long adjAquifer = this.aquiferLocations[adjIndex];
                            if (adjAquifer == Long.MAX_VALUE) {
                                RandomSource random = this.fork.m_183161_(adjGridX, adjGridY, adjGridZ);
                                this.aquiferLocations[adjIndex] = adjAquifer = BlockPos.m_121882_((int)(adjGridX * 16 + random.nextInt(10) + 3), (int)(adjGridY * 12 + random.nextInt(8) + 2), (int)(adjGridZ * 16 + random.nextInt(10) + 3));
                            }
                            if ((distance = (dx = BlockPos.m_121983_((long)adjAquifer) - x) * dx + (dy = BlockPos.m_122008_((long)adjAquifer) - y) * dy + (dz = BlockPos.m_122015_((long)adjAquifer) - z) * dz) <= distance1) {
                                aquifer3 = aquifer2;
                                aquifer2 = aquifer1;
                                aquifer1 = adjAquifer;
                                distance3 = distance2;
                                distance2 = distance1;
                                distance1 = distance;
                                continue;
                            }
                            if (distance <= distance2) {
                                aquifer3 = aquifer2;
                                aquifer2 = adjAquifer;
                                distance3 = distance2;
                                distance2 = distance;
                                continue;
                            }
                            if (distance > distance3) continue;
                            aquifer3 = adjAquifer;
                            distance3 = distance;
                        }
                    }
                }
                AquiferEntry entry1 = this.getOrCreateAquifer(aquifer1);
                AquiferEntry entry2 = this.getOrCreateAquifer(aquifer2);
                AquiferEntry entry3 = this.getOrCreateAquifer(aquifer3);
                double similarity12 = TFCAquifer.similarity(distance1, distance2);
                double similarity13 = TFCAquifer.similarity(distance1, distance3);
                double similarity23 = TFCAquifer.similarity(distance2, distance3);
                if (Helpers.isBlock(entry1.at(y), Blocks.f_49990_) && Helpers.isBlock(this.globalAquifer(y - 1).at(y - 1), Blocks.f_49991_)) {
                    aquiferNoiseContribution = 1.0;
                } else if (similarity12 > -1.0) {
                    MutableDouble barrierNoise = new MutableDouble(Double.NaN);
                    double pressure12 = this.calculatePressure(x, y, z, barrierNoise, entry1, entry2);
                    double pressure13 = this.calculatePressure(x, y, z, barrierNoise, entry1, entry3);
                    double pressure23 = this.calculatePressure(x, y, z, barrierNoise, entry2, entry3);
                    double clampedSimilarity12 = Math.max(0.0, similarity12);
                    double clampedSimilarity13 = Math.max(0.0, similarity13);
                    double clampedSimilarity23 = Math.max(0.0, similarity23);
                    aquiferNoiseContribution = Math.max(0.0, 2.0 * clampedSimilarity12 * Math.max(pressure12, Math.max(pressure13 * clampedSimilarity13, pressure23 * clampedSimilarity23)));
                } else {
                    aquiferNoiseContribution = 0.0;
                }
                state = entry1.at(y);
                isSurfaceLevelAquifer = entry1.fluidY == 63;
                boolean bl = this.shouldScheduleFluidUpdate = similarity12 >= FLOWING_UPDATE_SIMILARITY;
            }
            if (terrainNoise + aquiferNoiseContribution <= 0.0) {
                if (isSurfaceLevelAquifer) {
                    state = this.baseBlockSource.modifyFluid(state, x, z);
                }
                return state;
            }
        }
        this.shouldScheduleFluidUpdate = false;
        return null;
    }

    public boolean m_142203_() {
        return this.shouldScheduleFluidUpdate;
    }

    private double calculatePressure(int x, int y, int z, MutableDouble barrierNoise, AquiferEntry leftAquifer, AquiferEntry rightAquifer) {
        BlockState leftState = leftAquifer.at(y);
        BlockState rightState = rightAquifer.at(y);
        if (Helpers.isBlock(leftState, Blocks.f_49991_) && Helpers.isBlock(rightState, Blocks.f_49990_) || Helpers.isBlock(leftState, Blocks.f_49990_) && Helpers.isBlock(rightState, Blocks.f_49991_)) {
            return 1.0;
        }
        int deltaFluidLevel = Math.abs(leftAquifer.fluidY - rightAquifer.fluidY);
        if (deltaFluidLevel == 0) {
            return 0.0;
        }
        double averageFluidLevel = 0.5 * (double)(leftAquifer.fluidY + rightAquifer.fluidY);
        double deltaAboveAverageFluidLevel = (double)y + 0.5 - averageFluidLevel;
        double deltaNearAverageFluidLevel = 0.5 * (double)deltaFluidLevel - Math.abs(deltaAboveAverageFluidLevel);
        double pressure = deltaAboveAverageFluidLevel > 0.0 ? deltaNearAverageFluidLevel / (deltaNearAverageFluidLevel > 0.0 ? 1.5 : 2.5) : (deltaNearAverageFluidLevel + 3.0) / (double)(deltaNearAverageFluidLevel > -3.0 ? 3 : 10);
        if (pressure < -2.0 || pressure > 2.0) {
            return pressure;
        }
        double cachedBarrierNoise = barrierNoise.getValue();
        if (Double.isNaN(cachedBarrierNoise)) {
            double barrierNoiseValue = this.barrierNoise.m_75380_((double)x, (double)y * 0.5, (double)z);
            barrierNoise.setValue(barrierNoiseValue);
            return barrierNoiseValue + pressure;
        }
        return cachedBarrierNoise + pressure;
    }

    private AquiferEntry getOrCreateAquifer(long location) {
        int x = BlockPos.m_121983_((long)location);
        int y = BlockPos.m_122008_((long)location);
        int z = BlockPos.m_122015_((long)location);
        int gridIndex = this.getIndex(TFCAquifer.gridXZ(x), TFCAquifer.gridY(y), TFCAquifer.gridXZ(z));
        AquiferEntry status = this.aquifers[gridIndex];
        if (status == null) {
            this.aquifers[gridIndex] = status = this.createAquifer(x, y, z);
        }
        return status;
    }

    private AquiferEntry createAquifer(int x, int y, int z) {
        int dx = x - this.minChunkX + 16;
        int dz = z - this.minChunkZ + 16;
        int surfaceIndex = SectionPos.m_123171_((int)dx) + 4 * SectionPos.m_123171_((int)dz);
        int surfaceHeight = this.surfaceHeights[surfaceIndex];
        if (y >= surfaceHeight) {
            return this.seaLevelAquifer;
        }
        Cellular3D.Cell cell = this.fluidCellNoise.cell(x, (float)y / 0.6f, z);
        float cellNoise = cell.noise();
        float cellY = cell.y();
        if (cellNoise < 0.25f || cellY > 53.0f && cellNoise < 0.5f) {
            return new AquiferEntry(Blocks.f_49990_.m_49966_(), this.minY - 1);
        }
        XoroshiroRandomSource random = new XoroshiroRandomSource(this.fluidCellSeed, (long)Float.floatToIntBits(cellNoise));
        float aquiferY = Math.min((random.nextFloat() - random.nextFloat() - 2.0f) * 5.0f + cellY, (float)surfaceHeight);
        boolean lava = cellY < 40.0f && random.nextInt(3) == 0;
        return new AquiferEntry(lava ? Blocks.f_49991_.m_49966_() : Blocks.f_49990_.m_49966_(), (int)aquiferY);
    }

    private AquiferEntry globalAquifer(int y) {
        return y < this.minY + 10 ? this.lavaLevelAquifer : this.seaLevelAquifer;
    }

    private int getIndex(int x, int y, int z) {
        int dx = x - this.minGridX;
        int dy = y - this.minGridY;
        int dz = z - this.minGridZ;
        return (dy * this.gridSizeZ + dz) * this.gridSizeX + dx;
    }

    record AquiferEntry(BlockState state, int fluidY) {
        public BlockState at(int y) {
            return y < this.fluidY ? this.state : Blocks.f_50016_.m_49966_();
        }
    }
}

