/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import com.google.gson.JsonObject;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.RegisteredDataManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ClimateRange {
    public static final RegisteredDataManager<ClimateRange> MANAGER = new RegisteredDataManager<ClimateRange>(ClimateRange::new, ClimateRange::new, Helpers.identifier("climate_ranges"), "climate range", ClimateRange::new, ClimateRange::encode, Packet::new);
    public static final ClimateRange NOOP = new ClimateRange(new ResourceLocation("tfc:no_op"));
    private final ResourceLocation id;
    private final int minHydration;
    private final int maxHydration;
    private final int hydrationWiggleRange;
    private final float minTemperature;
    private final float maxTemperature;
    private final float temperatureWiggleRange;

    private ClimateRange(ResourceLocation id) {
        this.id = id;
        this.minHydration = 0;
        this.maxHydration = 100;
        this.hydrationWiggleRange = 0;
        this.minTemperature = -100.0f;
        this.maxTemperature = 100.0f;
        this.temperatureWiggleRange = 0.0f;
    }

    private ClimateRange(ResourceLocation id, JsonObject json) {
        this.id = id;
        this.minHydration = JsonHelpers.m_13824_((JsonObject)json, (String)"min_hydration", (int)0);
        this.maxHydration = JsonHelpers.m_13824_((JsonObject)json, (String)"max_hydration", (int)100);
        this.hydrationWiggleRange = JsonHelpers.m_13824_((JsonObject)json, (String)"hydration_wiggle_range", (int)0);
        this.minTemperature = JsonHelpers.m_13820_((JsonObject)json, (String)"min_temperature", (float)-100.0f);
        this.maxTemperature = JsonHelpers.m_13820_((JsonObject)json, (String)"max_temperature", (float)100.0f);
        this.temperatureWiggleRange = JsonHelpers.m_13820_((JsonObject)json, (String)"temperature_wiggle_range", (float)0.0f);
    }

    private ClimateRange(ResourceLocation id, FriendlyByteBuf buffer) {
        this.id = id;
        this.minHydration = buffer.m_130242_();
        this.maxHydration = buffer.m_130242_();
        this.hydrationWiggleRange = buffer.m_130242_();
        this.minTemperature = buffer.readFloat();
        this.maxTemperature = buffer.readFloat();
        this.temperatureWiggleRange = buffer.readFloat();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.minHydration);
        buffer.m_130130_(this.maxHydration);
        buffer.m_130130_(this.hydrationWiggleRange);
        buffer.writeFloat(this.minTemperature);
        buffer.writeFloat(this.maxTemperature);
        buffer.writeFloat(this.temperatureWiggleRange);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public int getMinHydration(boolean allowWiggle) {
        return allowWiggle ? this.minHydration - this.hydrationWiggleRange : this.minHydration;
    }

    public int getMaxHydration(boolean allowWiggle) {
        return allowWiggle ? this.maxHydration + this.hydrationWiggleRange : this.maxHydration;
    }

    public float getMinTemperature(boolean allowWiggle) {
        return allowWiggle ? this.minTemperature - this.temperatureWiggleRange : this.minTemperature;
    }

    public float getMaxTemperature(boolean allowWiggle) {
        return allowWiggle ? this.maxTemperature + this.temperatureWiggleRange : this.maxTemperature;
    }

    public Result checkHydration(int hydration, boolean allowWiggle) {
        return this.check(hydration, this.minHydration, this.maxHydration, this.hydrationWiggleRange, allowWiggle);
    }

    public Result checkTemperature(float temperature, boolean allowWiggle) {
        return this.check(temperature, this.minTemperature, this.maxTemperature, this.temperatureWiggleRange, allowWiggle);
    }

    public boolean checkBoth(int hydration, float temperature, boolean allowWiggle) {
        return this.checkHydration(hydration, allowWiggle) == Result.VALID && this.checkTemperature(temperature, allowWiggle) == Result.VALID;
    }

    @NotNull
    private Result check(float value, float min, float max, float range, boolean allowRange) {
        if (allowRange) {
            min -= range;
            max += range;
        }
        if (value < min) {
            return Result.LOW;
        }
        if (value > max) {
            return Result.HIGH;
        }
        return Result.VALID;
    }

    public static enum Result {
        LOW,
        VALID,
        HIGH;

    }

    public static class Packet
    extends DataManagerSyncPacket<RegisteredDataManager.Entry<ClimateRange>> {
    }
}

