/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.slf4j.Logger;

public class CalendarEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(CalendarEventHandler::onServerStart);
        bus.addListener(CalendarEventHandler::onServerStop);
        bus.addListener(CalendarEventHandler::onServerTick);
        bus.addListener(CalendarEventHandler::onOverworldTick);
        bus.addListener(CalendarEventHandler::onPlayerWakeUp);
        bus.addListener(CalendarEventHandler::onPlayerLoggedOut);
        bus.addListener(CalendarEventHandler::onPlayerLoggedIn);
    }

    public static void onServerStart(ServerStartingEvent event) {
        Calendars.SERVER.onServerStart(event.getServer());
    }

    public static void onServerStop(ServerStoppedEvent event) {
        Calendars.SERVER.onServerStop();
    }

    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Calendars.SERVER.onServerTick();
        }
    }

    public static void onOverworldTick(TickEvent.WorldTickEvent event) {
        ServerLevel level;
        Level level2;
        if (event.phase == TickEvent.Phase.END && (level2 = event.world) instanceof ServerLevel && (level = (ServerLevel)level2).m_46472_() == Level.f_46428_) {
            Calendars.SERVER.onOverworldTick(level);
        }
    }

    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        if (!event.getEntity().m_20193_().m_5776_() && !event.updateWorld()) {
            long currentDayTime = event.getEntity().m_20193_().m_46468_();
            if (Calendars.SERVER.getCalendarDayTime() != currentDayTime) {
                long jump = Calendars.SERVER.setTimeFromDayTime(currentDayTime);
                float exhaustion = (float)jump * 0.0033333334f * ((Double)TFCConfig.SERVER.passiveExhaustionModifier.get()).floatValue();
                for (Player player : event.getEntity().f_19853_.m_6907_()) {
                    player.m_36399_(exhaustion);
                }
            }
        }
    }

    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player;
        MinecraftServer server;
        Player player2 = event.getPlayer();
        if (player2 instanceof ServerPlayer && (server = (player = (ServerPlayer)player2).m_20194_()) != null) {
            LOGGER.info("Player Logged Out - Checking for Calendar Updates.");
            List players = server.m_6846_().m_11314_();
            int playerCount = players.size();
            if (players.contains(player)) {
                --playerCount;
            }
            Calendars.SERVER.setPlayersLoggedOn(playerCount > 0);
        }
    }

    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        MinecraftServer server;
        Player player2 = event.getPlayer();
        if (player2 instanceof ServerPlayer && (server = (player = (ServerPlayer)player2).m_20194_()) != null) {
            LOGGER.info("Player Logged In - Checking for Calendar Updates.");
            Calendars.SERVER.setPlayersLoggedOn(server.m_6846_().m_11309_() > 0);
        }
    }
}

