/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class MultiBlock
implements BiPredicate<LevelAccessor, BlockPos> {
    protected final List<BiPredicate<LevelAccessor, BlockPos>> conditions;

    public MultiBlock() {
        this.conditions = new ArrayList<BiPredicate<LevelAccessor, BlockPos>>();
    }

    MultiBlock(List<BiPredicate<LevelAccessor, BlockPos>> conditions) {
        this.conditions = conditions;
    }

    public MultiBlock copy() {
        return new MultiBlock(new ArrayList<BiPredicate<LevelAccessor, BlockPos>>(this.conditions));
    }

    public MultiBlock match(BlockPos posOffset, TagKey<Block> tagMatch) {
        return this.match(posOffset, (LevelAccessor level, BlockPos pos) -> Helpers.isBlock(level.m_8055_(pos), tagMatch));
    }

    public MultiBlock match(BlockPos posOffset, Predicate<BlockState> stateMatcher) {
        return this.match(posOffset, (LevelAccessor level, BlockPos pos) -> stateMatcher.test(level.m_8055_(pos)));
    }

    public <T extends BlockEntity> MultiBlock match(BlockPos posOffset, Predicate<T> blockEntityMatcher, BlockEntityType<T> type) {
        return this.match(posOffset, (LevelAccessor level, BlockPos pos) -> level.m_141902_(pos, type).map(blockEntityMatcher::test).orElse(false));
    }

    public MultiBlock match(BlockPos posOffset, BiPredicate<LevelAccessor, BlockPos> condition) {
        this.conditions.add((level, pos) -> condition.test((LevelAccessor)level, pos.m_141952_((Vec3i)posOffset)));
        return this;
    }

    public MultiBlock matchEachDirection(BlockPos posOffset, BiPredicate<LevelAccessor, BlockPos> condition, Direction[] directions, int relativeAmount) {
        for (Direction d : directions) {
            this.conditions.add((level, pos) -> condition.test((LevelAccessor)level, pos.m_141952_((Vec3i)posOffset).m_5484_(d, relativeAmount)));
        }
        return this;
    }

    public MultiBlock matchHorizontal(BlockPos posOffset, BiPredicate<LevelAccessor, BlockPos> condition, int relativeAmount) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            this.conditions.add((level, pos) -> condition.test((LevelAccessor)level, pos.m_141952_((Vec3i)posOffset).m_5484_(d, relativeAmount)));
        }
        return this;
    }

    public MultiBlock matchOneOf(BlockPos baseOffset, MultiBlock subMultiBlock) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        this.conditions.add((level, pos) -> {
            for (BiPredicate<LevelAccessor, BlockPos> condition : subMultiBlock.conditions) {
                if (!condition.test((LevelAccessor)level, (BlockPos)mutable.m_122190_((Vec3i)pos).m_122193_((Vec3i)baseOffset))) continue;
                return true;
            }
            return false;
        });
        return this;
    }

    @Override
    public boolean test(LevelAccessor level, BlockPos pos) {
        for (BiPredicate<LevelAccessor, BlockPos> condition : this.conditions) {
            if (condition.test(level, pos)) continue;
            return false;
        }
        return true;
    }
}

