/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.GroundcoverBlockType;
import net.dries007.tfc.common.blocks.SnowPileBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.ThatchBedBlock;
import net.dries007.tfc.common.blocks.devices.IngotPileBlock;
import net.dries007.tfc.common.blocks.devices.SheetPileBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.container.ItemStackContainerProvider;
import net.dries007.tfc.common.container.TFCContainerProviders;
import net.dries007.tfc.common.recipes.ScrapingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.BlockItemPlacement;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.events.StartFireEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public final class InteractionManager {
    private static final ThreadLocal<Boolean> ACTIVE = ThreadLocal.withInitial(() -> false);
    private static final List<Entry> ACTIONS = new ArrayList<Entry>();
    private static final IndirectHashCollection<Item, Entry> CACHE = IndirectHashCollection.create(e -> Arrays.stream(e.item.m_43908_()).map(ItemStack::m_41720_).toList(), () -> ACTIONS);

    public static void register(BlockItemPlacement wrapper) {
        InteractionManager.register(new Entry(wrapper, Ingredient.m_43929_((ItemLike[])new ItemLike[]{wrapper.getItem()}), true, false));
    }

    public static void register(Ingredient item, OnItemUseAction action) {
        InteractionManager.register(item, false, action);
    }

    public static void register(Ingredient item, boolean targetAir, OnItemUseAction action) {
        InteractionManager.register(item, true, targetAir, action);
    }

    public static void register(Ingredient item, boolean targetBlocks, boolean targetAir, OnItemUseAction action) {
        InteractionManager.register(new Entry(action, item, targetBlocks, targetAir));
    }

    public static void registerDefaultInteractions() {
        InteractionManager.register(Ingredient.m_204132_(TFCTags.Items.THATCH_BED_HIDES), false, (stack, context) -> {
            Level level = context.m_43725_();
            Player player = context.m_43723_();
            if (!level.m_5776_() && player != null) {
                BlockPos basePos = context.m_8083_();
                BlockState baseState = level.m_8055_(basePos);
                Direction facing = context.m_8125_();
                BlockState bed = ((Block)TFCBlocks.THATCH_BED.get()).m_49966_();
                for (Direction direction : new Direction[]{facing, facing.m_122427_(), facing.m_122424_(), facing.m_122428_()}) {
                    BlockPos playerPos;
                    BlockPos headPos = basePos.m_5484_(direction, 1);
                    BlockState headState = level.m_8055_(headPos);
                    if (!Helpers.isBlock(baseState, TFCTags.Blocks.THATCH_BED_THATCH) || !Helpers.isBlock(headState, TFCTags.Blocks.THATCH_BED_THATCH) || (playerPos = player.m_142538_()) == headPos || playerPos == basePos) continue;
                    level.m_7731_(basePos, (BlockState)((BlockState)bed.m_61124_((Property)ThatchBedBlock.f_49440_, (Comparable)BedPart.FOOT)).m_61124_((Property)ThatchBedBlock.f_54117_, (Comparable)direction), 18);
                    level.m_7731_(headPos, (BlockState)((BlockState)bed.m_61124_((Property)ThatchBedBlock.f_49440_, (Comparable)BedPart.HEAD)).m_61124_((Property)ThatchBedBlock.f_54117_, (Comparable)direction), 18);
                    level.m_141902_(headPos, (BlockEntityType)TFCBlockEntities.THATCH_BED.get()).ifPresent(entity -> entity.setBed(headState, baseState, stack.m_41620_(1)));
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.FAIL;
        });
        InteractionManager.register(Ingredient.m_204132_(TFCTags.Items.STARTS_FIRES_WITH_DURABILITY), false, (stack, context) -> {
            Player player = context.m_43723_();
            Level level = context.m_43725_();
            BlockPos pos = context.m_8083_();
            if (player != null && StartFireEvent.startFire(level, pos, level.m_8055_(pos), context.m_43719_(), player, stack)) {
                level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_5822_().nextFloat() * 0.4f + 0.8f);
                if (!player.m_7500_()) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        });
        InteractionManager.register(Ingredient.m_204132_(TFCTags.Items.STARTS_FIRES_WITH_ITEMS), false, (stack, context) -> {
            Player playerEntity = context.m_43723_();
            if (playerEntity instanceof ServerPlayer) {
                BlockPos pos;
                ServerPlayer player = (ServerPlayer)playerEntity;
                Level level = context.m_43725_();
                if (StartFireEvent.startFire(level, pos = context.m_8083_(), level.m_8055_(pos), context.m_43719_(), (Player)player, stack)) {
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.FAIL;
        });
        InteractionManager.register(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41979_}), false, (stack, context) -> {
            BlockState stateAt;
            BlockPos pos;
            Player player = context.m_43723_();
            if (player != null && !player.m_150110_().f_35938_) {
                return InteractionResult.PASS;
            }
            BlockPlaceContext blockContext = new BlockPlaceContext(context);
            Level level = blockContext.m_43725_();
            if (SnowPileBlock.canPlaceSnowPile((LevelAccessor)level, pos = blockContext.m_8083_(), stateAt = level.m_8055_(blockContext.m_8083_()))) {
                SnowPileBlock.placeSnowPile((LevelAccessor)level, pos, stateAt, true);
                BlockState placedState = level.m_8055_(pos);
                SoundType placementSound = placedState.getSoundType((LevelReader)level, pos, (Entity)player);
                level.m_5594_(player, pos, placedState.getSoundType((LevelReader)level, pos, (Entity)player).m_56777_(), SoundSource.BLOCKS, (placementSound.m_56773_() + 1.0f) / 2.0f, placementSound.m_56774_() * 0.8f);
                if (player == null || !player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                InteractionResult result = InteractionResult.m_19078_((boolean)level.f_46443_);
                if (player != null && result.m_19077_()) {
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_41979_));
                }
                return result;
            }
            Item patt11718$temp = Items.f_41979_;
            if (patt11718$temp instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)patt11718$temp;
                return blockItem.m_40576_(blockContext);
            }
            return InteractionResult.FAIL;
        });
        InteractionManager.register(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42414_}), false, (stack, context) -> {
            Player player = context.m_43723_();
            if (player != null && player.m_36326_()) {
                BlockPlaceContext blockContext = new BlockPlaceContext(context);
                Level level = blockContext.m_43725_();
                BlockPos clickedPos = context.m_8083_();
                BlockPos offsetPos = blockContext.m_8083_();
                BlockState clickedState = level.m_8055_(clickedPos);
                BlockState offsetState = level.m_8055_(offsetPos);
                BlockItemPlacement placement = new BlockItemPlacement((Supplier<? extends Item>)((Supplier<Item>)() -> Items.f_42414_), (Supplier<? extends Block>)TFCBlocks.CHARCOAL_PILE);
                if (Helpers.isBlock(clickedState, (Block)TFCBlocks.CHARCOAL_PILE.get()) && (Integer)clickedState.m_61143_((Property)CharcoalPileBlock.LAYERS) < 8) {
                    BlockState placementState = (BlockState)clickedState.m_61124_((Property)CharcoalPileBlock.LAYERS, (Comparable)Integer.valueOf((Integer)clickedState.m_61143_((Property)CharcoalPileBlock.LAYERS) + 1));
                    if (BlockItemPlacement.canPlace(blockContext, placementState, clickedPos)) {
                        level.m_46597_(clickedPos, placementState);
                        return placement.postPlacement(blockContext, clickedPos);
                    }
                    return InteractionResult.FAIL;
                }
                if (Helpers.isBlock(offsetState, (Block)TFCBlocks.CHARCOAL_PILE.get()) && (Integer)offsetState.m_61143_((Property)CharcoalPileBlock.LAYERS) < 8) {
                    BlockState placementState = (BlockState)offsetState.m_61124_((Property)CharcoalPileBlock.LAYERS, (Comparable)Integer.valueOf((Integer)offsetState.m_61143_((Property)CharcoalPileBlock.LAYERS) + 1));
                    if (BlockItemPlacement.canPlace(blockContext, placementState, offsetPos)) {
                        level.m_46597_(offsetPos, placementState);
                        return placement.postPlacement(blockContext, offsetPos);
                    }
                    return InteractionResult.FAIL;
                }
                return placement.place(blockContext);
            }
            return InteractionResult.PASS;
        });
        BlockItemPlacement logPilePlacement = new BlockItemPlacement((Supplier<? extends Item>)((Supplier<Item>)() -> Items.f_41852_), (Supplier<? extends Block>)TFCBlocks.LOG_PILE);
        InteractionManager.register(Ingredient.m_204132_(TFCTags.Items.LOG_PILE_LOGS), false, (stack, context) -> {
            Player player = context.m_43723_();
            if (player != null && player.m_36326_() && player.m_6144_()) {
                Level level = context.m_43725_();
                Direction direction = context.m_43719_();
                BlockPos posClicked = context.m_8083_();
                BlockState stateClicked = level.m_8055_(posClicked);
                BlockPos relativePos = posClicked.m_142300_(direction);
                if (Helpers.isBlock(stateClicked, (Block)TFCBlocks.LOG_PILE.get())) {
                    return level.m_141902_(posClicked, (BlockEntityType)TFCBlockEntities.LOG_PILE.get()).flatMap(entity -> entity.getCapability(Capabilities.ITEM).map(t -> t)).map(cap -> {
                        ItemStack insertStack = stack.m_41777_();
                        if ((insertStack = Helpers.insertAllSlots(cap, insertStack)).m_41613_() < stack.m_41613_()) {
                            if (!level.m_5776_()) {
                                Helpers.playPlaceSound(level, relativePos, SoundType.f_56736_);
                                stack.m_41764_(insertStack.m_41613_());
                            }
                            return InteractionResult.SUCCESS;
                        }
                        InteractionResult result = logPilePlacement.onItemUse(stack, context);
                        if (result.m_19077_()) {
                            Helpers.insertOne(level, relativePos, (BlockEntityType<? extends BlockEntity>)((BlockEntityType)TFCBlockEntities.LOG_PILE.get()), insertStack);
                        }
                        return result;
                    }).orElse(InteractionResult.PASS);
                }
                if (level.m_8055_(relativePos.m_7495_()).m_60783_((BlockGetter)level, relativePos.m_7495_(), Direction.UP)) {
                    ItemStack stackBefore = stack.m_41777_();
                    BlockPos actualPlacedPos = new BlockPlaceContext(context).m_8083_();
                    InteractionResult result = logPilePlacement.onItemUse(stack, context);
                    if (result.m_19077_()) {
                        Helpers.insertOne(level, actualPlacedPos, (BlockEntityType<? extends BlockEntity>)((BlockEntityType)TFCBlockEntities.LOG_PILE.get()), stackBefore);
                    }
                    return result;
                }
            }
            return InteractionResult.PASS;
        });
        InteractionManager.register(Ingredient.m_204132_(TFCTags.Items.SCRAPABLE), false, (stack, context) -> {
            Level level = context.m_43725_();
            ScrapingRecipe recipe = ScrapingRecipe.getRecipe(level, new ItemStackInventory(stack));
            if (recipe != null) {
                BlockPos pos = context.m_8083_();
                BlockPos abovePos = pos.m_7494_();
                Player player = context.m_43723_();
                if (player != null && context.m_43719_() == Direction.UP && Helpers.isBlock(level.m_8055_(pos), TFCTags.Blocks.SCRAPING_SURFACE) && level.m_8055_(abovePos).m_60795_()) {
                    level.m_46597_(abovePos, ((Block)TFCBlocks.SCRAPING.get()).m_49966_());
                    level.m_141902_(abovePos, (BlockEntityType)TFCBlockEntities.SCRAPING.get()).map(entity -> entity.getCapability(Capabilities.ITEM).map(cap -> {
                        if (!level.f_46443_) {
                            ItemStack insertStack = stack.m_41620_(1);
                            stack.m_41764_(stack.m_41613_() + cap.insertItem(0, insertStack, false).m_41613_());
                            entity.updateDisplayCache();
                        }
                        return InteractionResult.SUCCESS;
                    }).orElse(InteractionResult.PASS));
                }
            }
            return InteractionResult.PASS;
        });
        for (GroundcoverBlockType type : GroundcoverBlockType.values()) {
            if (type.getVanillaItem() == null) continue;
            InteractionManager.register(new BlockItemPlacement(type.getVanillaItem(), (Supplier)TFCBlocks.GROUNDCOVER.get((Object)type)));
        }
        BiPredicate<ItemStack, Player> rockPredicate = (stack, player) -> Helpers.isItem(player.m_21205_(), TFCTags.Items.ROCK_KNAPPING) && Helpers.isItem(player.m_21206_(), TFCTags.Items.ROCK_KNAPPING) || (Boolean)TFCConfig.SERVER.requireOffhandForRockKnapping.get() == false && stack.m_41613_() >= 2;
        InteractionManager.register(Ingredient.m_204132_(TFCTags.Items.CLAY_KNAPPING), true, InteractionManager.createKnappingInteraction((stack, player) -> stack.m_41613_() >= 5, TFCContainerProviders.CLAY_KNAPPING));
        InteractionManager.register(Ingredient.m_204132_(TFCTags.Items.FIRE_CLAY_KNAPPING), true, InteractionManager.createKnappingInteraction((stack, player) -> stack.m_41613_() >= 5, TFCContainerProviders.FIRE_CLAY_KNAPPING));
        InteractionManager.register(Ingredient.m_204132_(TFCTags.Items.ROCK_KNAPPING), false, true, InteractionManager.createKnappingInteraction(rockPredicate, TFCContainerProviders.ROCK_KNAPPING));
        InteractionManager.register(Ingredient.m_204132_(TFCTags.Items.LEATHER_KNAPPING), true, InteractionManager.createKnappingInteraction((stack, player) -> {
            if (player.m_150109_().m_204075_(TFCTags.Items.KNIVES)) {
                return true;
            }
            player.m_5661_((Component)Helpers.translatable("tfc.tooltip.knapping.knife_needed"), true);
            return false;
        }, TFCContainerProviders.LEATHER_KNAPPING));
        BlockItemPlacement ingotPilePlacement = new BlockItemPlacement((Supplier<? extends Item>)((Supplier<Item>)() -> Items.f_41852_), (Supplier<? extends Block>)TFCBlocks.INGOT_PILE);
        InteractionManager.register(Ingredient.m_204132_(TFCTags.Items.PILEABLE_INGOTS), false, (stack, context) -> {
            Player player = context.m_43723_();
            if (player != null && player.m_36326_() && player.m_6144_()) {
                BlockPos posClicked;
                Level level = context.m_43725_();
                BlockState stateClicked = level.m_8055_(posClicked = context.m_8083_());
                if (Helpers.isBlock(stateClicked, (Block)TFCBlocks.INGOT_PILE.get())) {
                    BlockState topState;
                    int currentIngots = (Integer)stateClicked.m_61143_((Property)IngotPileBlock.COUNT);
                    if (currentIngots < 64) {
                        ItemStack insertStack = stack.m_41620_(1);
                        Helpers.playPlaceSound(level, posClicked, stateClicked);
                        level.m_7731_(posClicked, (BlockState)stateClicked.m_61124_((Property)IngotPileBlock.COUNT, (Comparable)Integer.valueOf(currentIngots + 1)), 2);
                        level.m_141902_(posClicked, (BlockEntityType)TFCBlockEntities.INGOT_PILE.get()).ifPresent(pile -> pile.addIngot(insertStack));
                        return InteractionResult.SUCCESS;
                    }
                    BlockPos topPos = posClicked;
                    while (Helpers.isBlock(topState = level.m_8055_(topPos = topPos.m_7494_()), (Block)TFCBlocks.INGOT_PILE.get()) && (Integer)topState.m_61143_((Property)IngotPileBlock.COUNT) == 64) {
                    }
                    if (Helpers.isBlock(topState, (Block)TFCBlocks.INGOT_PILE.get())) {
                        ItemStack insertStack = stack.m_41620_(1);
                        int topIngots = (Integer)topState.m_61143_((Property)IngotPileBlock.COUNT);
                        Helpers.playPlaceSound(level, topPos, topState);
                        level.m_7731_(topPos, (BlockState)topState.m_61124_((Property)IngotPileBlock.COUNT, (Comparable)Integer.valueOf(topIngots + 1)), 2);
                        level.m_141902_(topPos, (BlockEntityType)TFCBlockEntities.INGOT_PILE.get()).ifPresent(topPile -> topPile.addIngot(insertStack));
                        return InteractionResult.SUCCESS;
                    }
                    if (topState.m_60795_()) {
                        ItemStack stackBefore = stack.m_41777_();
                        BlockPos topOfIngotPilePos = topPos.m_7495_();
                        UseOnContext topOfIngotPileContext = new UseOnContext(player, context.m_43724_(), new BlockHitResult(Vec3.f_82478_, Direction.UP, topOfIngotPilePos, false));
                        InteractionResult result = ingotPilePlacement.onItemUse(stack, topOfIngotPileContext);
                        if (result.m_19077_()) {
                            stackBefore.m_41764_(1);
                            level.m_141902_(topPos, (BlockEntityType)TFCBlockEntities.INGOT_PILE.get()).ifPresent(topPile -> topPile.addIngot(stackBefore));
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.FAIL;
                }
                ItemStack stackBefore = Helpers.copyWithSize(stack, 1);
                BlockPos actualPlacedPos = new BlockPlaceContext(context).m_8083_();
                InteractionResult result = ingotPilePlacement.onItemUse(stack, context);
                if (result.m_19077_()) {
                    level.m_141902_(actualPlacedPos, (BlockEntityType)TFCBlockEntities.INGOT_PILE.get()).ifPresent(pile -> pile.addIngot(stackBefore));
                }
                return result;
            }
            return InteractionResult.PASS;
        });
        InteractionManager.register(Ingredient.m_204132_(TFCTags.Items.PILEABLE_SHEETS), false, (stack, context) -> {
            Player player = context.m_43723_();
            if (player != null && player.m_36326_() && player.m_6144_()) {
                BlockState placingState;
                Level level = context.m_43725_();
                Direction clickedFace = context.m_43719_();
                Direction sheetFace = clickedFace.m_122424_();
                BlockPos clickedPos = context.m_8083_();
                BlockPos relativePos = clickedPos.m_142300_(clickedFace);
                BlockState clickedState = level.m_8055_(clickedPos);
                BlockState relativeState = level.m_8055_(relativePos);
                BlockPlaceContext blockContext = new BlockPlaceContext(context);
                BooleanProperty property = DirectionPropertyBlock.getProperty(sheetFace);
                if (blockContext.m_7058_()) {
                    return InteractionResult.FAIL;
                }
                if (Helpers.isBlock(relativeState, (Block)TFCBlocks.SHEET_PILE.get())) {
                    if (!((Boolean)relativeState.m_61143_((Property)property)).booleanValue() && BlockItemPlacement.canPlace(blockContext, clickedState) && clickedState.m_60783_((BlockGetter)level, clickedPos, clickedFace)) {
                        ItemStack insertStack = stack.m_41620_(1);
                        SheetPileBlock.addSheet((LevelAccessor)level, relativePos, relativeState, sheetFace, insertStack);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.FAIL;
                }
                if (level.m_8055_(relativePos).m_60629_(blockContext) && BlockItemPlacement.canPlace(blockContext, placingState = (BlockState)((Block)TFCBlocks.SHEET_PILE.get()).m_49966_().m_61124_((Property)property, (Comparable)Boolean.valueOf(true))) && clickedState.m_60783_((BlockGetter)level, clickedPos, clickedFace)) {
                    ItemStack insertStack = stack.m_41620_(1);
                    SheetPileBlock.addSheet((LevelAccessor)level, relativePos, placingState, sheetFace, insertStack);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        });
        InteractionManager.register(Ingredient.m_204132_(TFCTags.Items.SALAD_BOWLS), true, (stack, context) -> {
            if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
                Player patt31502$temp = context.m_43723_();
                if (patt31502$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt31502$temp;
                    Helpers.openScreen(player, TFCContainerProviders.SALAD);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        });
        InteractionManager.register(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42521_}), true, (stack, context) -> {
            if (!((Boolean)TFCConfig.SERVER.enableVanillaEggThrowing.get()).booleanValue()) {
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        });
    }

    public static OnItemUseAction createKnappingInteraction(BiPredicate<ItemStack, Player> condition, ItemStackContainerProvider container) {
        return (stack, context) -> {
            Player player = context.m_43723_();
            if (player != null && context.m_8083_().equals((Object)BlockPos.f_121853_) && condition.test(stack, player)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    container.openScreen(serverPlayer, context.m_43724_());
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<InteractionResult> onItemUse(ItemStack stack, UseOnContext context, boolean isTargetingAir) {
        if (!ACTIVE.get().booleanValue()) {
            for (Entry entry : CACHE.getAll(stack.m_41720_())) {
                InteractionResult result;
                if (!(isTargetingAir ? entry.targetAir : entry.targetBlocks) || !entry.item.test(stack)) continue;
                ACTIVE.set(true);
                try {
                    result = entry.action().onItemUse(stack, context);
                }
                finally {
                    ACTIVE.set(false);
                }
                return result == InteractionResult.PASS ? Optional.empty() : Optional.of(result);
            }
        }
        return Optional.empty();
    }

    private static synchronized void register(Entry entry) {
        ACTIONS.add(entry);
    }

    private record Entry(OnItemUseAction action, Ingredient item, boolean targetBlocks, boolean targetAir) {
    }

    @FunctionalInterface
    public static interface OnItemUseAction {
        public InteractionResult onItemUse(ItemStack var1, UseOnContext var2);
    }
}

