/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonObject;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.ItemDefinition;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public final class Fuel
extends ItemDefinition {
    public static final DataManager<Fuel> MANAGER = new DataManager<Fuel>(Helpers.identifier("fuels"), "fuel", Fuel::new, Fuel::new, Fuel::encode, Packet::new);
    public static final IndirectHashCollection<Item, Fuel> CACHE = IndirectHashCollection.create(ItemDefinition::getValidItems, MANAGER::getValues);
    private final int duration;
    private final float temperature;
    private final float purity;

    @Nullable
    public static Fuel get(ItemStack stack) {
        for (Fuel def : CACHE.getAll(stack.m_41720_())) {
            if (!def.matches(stack)) continue;
            return def;
        }
        return null;
    }

    public Fuel(ResourceLocation id, JsonObject json) {
        super(id, json);
        this.duration = GsonHelper.m_13927_((JsonObject)json, (String)"duration");
        this.temperature = GsonHelper.m_13915_((JsonObject)json, (String)"temperature");
        this.purity = GsonHelper.m_13820_((JsonObject)json, (String)"purity", (float)1.0f);
    }

    public Fuel(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, Ingredient.m_43940_((FriendlyByteBuf)buffer));
        this.duration = buffer.m_130242_();
        this.temperature = buffer.readFloat();
        this.purity = buffer.readFloat();
    }

    public void encode(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.m_130130_(this.duration);
        buffer.writeFloat(this.temperature);
        buffer.writeFloat(this.purity);
    }

    public int getDuration() {
        return this.duration;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getPurity() {
        return this.purity;
    }

    public static class Packet
    extends DataManagerSyncPacket<Fuel> {
    }
}

