/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.IcePileBlock;
import net.dries007.tfc.common.blocks.SnowPileBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.ThinSpikeBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.tracker.WorldTrackerCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public final class EnvironmentHelpers {
    public static final int ICICLE_MELT_RANDOM_TICK_CHANCE = 4;
    public static final int SNOW_MELT_RANDOM_TICK_CHANCE = 75;
    public static final int ICE_MELT_RANDOM_TICK_CHANCE = 200;
    public static final int ICICLE_MAX_LENGTH = 7;

    public static void tickChunk(ServerLevel level, LevelChunk chunk, ProfilerFiller profiler) {
        ChunkPos chunkPos = chunk.m_7697_();
        BlockPos lcgPos = level.m_46496_(chunkPos.m_45604_(), 0, chunkPos.m_45605_(), 15);
        BlockPos surfacePos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, lcgPos);
        BlockPos groundPos = surfacePos.m_7495_();
        float temperature = Climate.getTemperature((Level)level, surfacePos);
        profiler.m_6180_("tfcSnow");
        EnvironmentHelpers.doSnow((Level)level, surfacePos, temperature);
        profiler.m_6182_("tfcIce");
        EnvironmentHelpers.doIce((Level)level, groundPos, temperature);
        profiler.m_6182_("tfcIcicles");
        EnvironmentHelpers.doIcicles((Level)level, surfacePos, temperature);
        profiler.m_7238_();
    }

    public static boolean isSnow(BlockState state) {
        return Helpers.isBlock(state, Blocks.f_50125_) || Helpers.isBlock(state, (Block)TFCBlocks.SNOW_PILE.get());
    }

    public static boolean isIce(BlockState state) {
        return Helpers.isBlock(state, Blocks.f_50126_) || Helpers.isBlock(state, (Block)TFCBlocks.ICE_PILE.get()) || Helpers.isBlock(state, (Block)TFCBlocks.SEA_ICE.get());
    }

    public static boolean isWater(BlockState state) {
        return Helpers.isBlock(state, Blocks.f_49990_) || Helpers.isBlock(state, (Block)TFCBlocks.SALT_WATER.get());
    }

    public static boolean isAdjacentToWater(LevelAccessor level, BlockPos pos) {
        return EnvironmentHelpers.isAdjacentToMaybeWater(level, pos, true);
    }

    public static boolean isAdjacentToNotWater(LevelAccessor level, BlockPos pos) {
        return EnvironmentHelpers.isAdjacentToMaybeWater(level, pos, false);
    }

    private static boolean isAdjacentToMaybeWater(LevelAccessor level, BlockPos pos, boolean expected) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (level.m_46801_((BlockPos)mutablePos.m_122159_((Vec3i)pos, direction)) != expected) continue;
            return true;
        }
        return false;
    }

    public static boolean isWorldgenReplaceable(WorldGenLevel level, BlockPos pos) {
        return EnvironmentHelpers.isWorldgenReplaceable(level.m_8055_(pos));
    }

    public static boolean isWorldgenReplaceable(BlockState state) {
        return FluidHelpers.isAirOrEmptyFluid(state) || Helpers.isBlock(state, TFCTags.Blocks.SINGLE_BLOCK_REPLACEABLE);
    }

    public static boolean canPlaceBushOn(WorldGenLevel level, BlockPos pos) {
        return EnvironmentHelpers.isWorldgenReplaceable(level, pos) && Helpers.isBlock(level.m_8055_(pos.m_7495_()), TFCTags.Blocks.BUSH_PLANTABLE_ON);
    }

    public static boolean isOnSturdyFace(WorldGenLevel level, BlockPos pos) {
        pos = pos.m_7495_();
        return level.m_8055_(pos).m_60783_((BlockGetter)level, pos, Direction.UP);
    }

    public static boolean isRainingOrSnowing(Level level, BlockPos pos) {
        return level.m_46471_() && level.getCapability(WorldTrackerCapability.CAPABILITY).map(cap -> cap.isRaining(level, pos)).orElse(false) != false;
    }

    public static float getExpectedSnowLayerHeight(float temperature) {
        return Mth.m_184631_((float)temperature, (float)2.0f, (float)-26.0f, (float)0.0f, (float)7.0f);
    }

    private static void doSnow(Level level, BlockPos surfacePos, float temperature) {
        BlockState state;
        Random random = level.f_46441_;
        int expectedLayers = (int)EnvironmentHelpers.getExpectedSnowLayerHeight(temperature);
        if (temperature < -2.0f && EnvironmentHelpers.isRainingOrSnowing(level, surfacePos)) {
            if (random.nextInt((Integer)TFCConfig.SERVER.snowAccumulateChance.get()) == 0 && !EnvironmentHelpers.placeSnowOrSnowPile(level, surfacePos, random, expectedLayers) && !EnvironmentHelpers.placeSnowOrSnowPile(level, surfacePos.m_7495_(), random, expectedLayers)) {
                EnvironmentHelpers.placeSnowOrSnowPile(level, surfacePos.m_6625_(2), random, expectedLayers);
            }
        } else if (random.nextInt((Integer)TFCConfig.SERVER.snowMeltChance.get()) == 0 && EnvironmentHelpers.isSnow(state = level.m_8055_(surfacePos))) {
            SnowPileBlock.removePileOrSnow((LevelAccessor)level, surfacePos, state, temperature > 0.0f ? expectedLayers : expectedLayers + 2);
        }
    }

    private static boolean placeSnowOrSnowPile(Level level, BlockPos initialPos, Random random, int expectedLayers) {
        if (expectedLayers < 1) {
            return false;
        }
        BlockPos pos = EnvironmentHelpers.findOptimalSnowLocation((LevelAccessor)level, initialPos, level.m_8055_(initialPos), random);
        BlockState state = level.m_8055_(pos);
        if (initialPos.equals((Object)pos) && !level.m_45527_(pos)) {
            return false;
        }
        return EnvironmentHelpers.placeSnowOrSnowPileAt((LevelAccessor)level, pos, state, random, expectedLayers);
    }

    private static boolean placeSnowOrSnowPileAt(LevelAccessor level, BlockPos pos, BlockState state, Random random, int expectedLayers) {
        if (EnvironmentHelpers.isSnow(state) && (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) < 7) {
            int currentLayers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
            BlockState newState = (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(currentLayers + 1));
            if (newState.m_60710_((LevelReader)level, pos) && random.nextInt(1 + 3 * currentLayers) == 0 && expectedLayers > currentLayers) {
                level.m_7731_(pos, newState, 3);
            }
            return true;
        }
        if (SnowPileBlock.canPlaceSnowPile(level, pos, state)) {
            SnowPileBlock.placeSnowPile(level, pos, state, false);
            return true;
        }
        if (state.m_60795_() && Blocks.f_50125_.m_49966_().m_60710_((LevelReader)level, pos)) {
            level.m_7731_(pos, Blocks.f_50125_.m_49966_(), 3);
            return true;
        }
        if (level instanceof Level) {
            Level fullLevel = (Level)level;
            state.m_60734_().m_141997_(state, fullLevel, pos, Biome.Precipitation.SNOW);
        }
        return false;
    }

    private static BlockPos findOptimalSnowLocation(LevelAccessor level, BlockPos pos, BlockState state, Random random) {
        BlockPos targetPos = null;
        int found = 0;
        if (EnvironmentHelpers.isSnow(state)) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos adjPos = pos.m_142300_(direction);
                BlockState adjState = level.m_8055_(adjPos);
                if ((!EnvironmentHelpers.isSnow(adjState) || (Integer)adjState.m_61143_((Property)SnowLayerBlock.f_56581_) >= (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_)) && (!adjState.m_60795_() && !Helpers.isBlock(adjState.m_60734_(), TFCTags.Blocks.CAN_BE_SNOW_PILED) || !Blocks.f_50125_.m_49966_().m_60710_((LevelReader)level, adjPos)) || targetPos != null && random.nextInt(++found) != 0) continue;
                targetPos = adjPos;
            }
            if (targetPos != null) {
                return targetPos;
            }
        }
        return pos;
    }

    private static void doIce(Level level, BlockPos groundPos, float temperature) {
        Random random = level.m_5822_();
        BlockState groundState = level.m_8055_(groundPos);
        if (temperature < -4.0f) {
            if (random.nextInt(16) == 0) {
                if (EnvironmentHelpers.isIce(groundState)) {
                    return;
                }
                if (groundState.m_60819_().m_76152_() != Fluids.f_76193_) {
                    groundPos = groundPos.m_7495_();
                    groundState = level.m_8055_(groundPos);
                }
                IcePileBlock.placeIcePileOrIce((LevelAccessor)level, groundPos, groundState, false);
            }
        } else if (temperature > 2.0f && (groundState.m_60734_() == Blocks.f_50126_ || groundState.m_60734_() == TFCBlocks.ICE_PILE.get()) && (random.nextInt(600) == 0 || random.nextInt(12) == 0 && EnvironmentHelpers.isAdjacentToWater((LevelAccessor)level, groundPos))) {
            IcePileBlock.removeIcePileOrIce((LevelAccessor)level, groundPos, groundState);
        }
    }

    private static void doIcicles(Level level, BlockPos lcgPos, float temperature) {
        BlockPos iciclePos;
        Random random = level.m_5822_();
        if (random.nextInt(16) == 0 && EnvironmentHelpers.isRainingOrSnowing(level, lcgPos) && temperature < -2.0f && temperature > -10.0f && (iciclePos = EnvironmentHelpers.findIcicleLocation(level, lcgPos, random)) != null) {
            BlockPos posAbove = iciclePos.m_7494_();
            BlockState stateAbove = level.m_8055_(posAbove);
            if (Helpers.isBlock(stateAbove, (Block)TFCBlocks.ICICLE.get())) {
                level.m_7731_(posAbove, (BlockState)stateAbove.m_61124_((Property)ThinSpikeBlock.TIP, (Comparable)Boolean.valueOf(false)), 19);
            }
            level.m_7731_(iciclePos, (BlockState)((ThinSpikeBlock)TFCBlocks.ICICLE.get()).m_49966_().m_61124_((Property)ThinSpikeBlock.TIP, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    @Nullable
    private static BlockPos findIcicleLocation(Level level, BlockPos pos, Random random) {
        BlockPos searchPos;
        Direction side = Direction.Plane.HORIZONTAL.m_122560_(random);
        BlockPos adjacentPos = pos.m_142300_(side);
        int adjacentHeight = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, adjacentPos.m_123341_(), adjacentPos.m_123343_());
        BlockPos foundPos = null;
        int found = 0;
        for (int y = 0; y < adjacentHeight; ++y) {
            BlockState stateAt = level.m_8055_(adjacentPos);
            BlockPos posAbove = adjacentPos.m_7494_();
            BlockState stateAbove = level.m_8055_(posAbove);
            if (stateAt.m_60795_() && (stateAbove.m_60734_() == TFCBlocks.ICICLE.get() || stateAbove.m_60783_((BlockGetter)level, posAbove, Direction.DOWN)) && (foundPos == null || random.nextInt(++found) == 0)) {
                foundPos = adjacentPos;
            }
            adjacentPos = posAbove;
        }
        if (foundPos != null && level.m_46749_(searchPos = foundPos.m_6630_(7)) && Helpers.isBlock(level.m_8055_(searchPos), (Block)TFCBlocks.ICICLE.get())) {
            foundPos = null;
        }
        return foundPos;
    }
}

