/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.tracker.WorldTrackerCapability;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public record UpdateClimateModelPacket(ClimateModel model) {
    static UpdateClimateModelPacket decode(FriendlyByteBuf buffer) {
        ClimateModel model = Climate.create(buffer.m_130281_());
        model.onReceiveOnClient(buffer);
        return new UpdateClimateModelPacket(model);
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(Climate.getId(this.model));
        this.model.onSyncToClient(buffer);
    }

    void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            Level level = ClientHelpers.getLevel();
            if (level != null) {
                level.getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(c -> c.setClimateModel(this.model));
            }
        });
    }
}

