/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import net.dries007.tfc.common.container.ButtonHandlerContainer;
import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ScreenButtonPacket {
    private final int buttonID;
    @Nullable
    private final CompoundTag extraNBT;

    public ScreenButtonPacket(int buttonID, @Nullable CompoundTag extraNBT) {
        this.buttonID = buttonID;
        this.extraNBT = extraNBT;
    }

    ScreenButtonPacket(FriendlyByteBuf buffer) {
        this.buttonID = buffer.m_130242_();
        this.extraNBT = Helpers.decodeNullable(buffer, FriendlyByteBuf::m_130260_);
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.buttonID);
        Helpers.encodeNullable(this.extraNBT, buffer, (nbt, buf) -> buf.m_130079_(nbt));
    }

    void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            AbstractContainerMenu patt1344$temp;
            ServerPlayer sender = context.getSender();
            if (sender != null && (patt1344$temp = sender.f_36096_) instanceof ButtonHandlerContainer) {
                ButtonHandlerContainer handler = (ButtonHandlerContainer)patt1344$temp;
                handler.onButtonPress(this.buttonID, this.extraNBT);
            }
        });
    }
}

