/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.util.tracker.WorldTrackerCapability;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class RainfallUpdatePacket {
    private final long rainStartTick;
    private final long rainEndTick;
    private final float rainIntensity;

    public RainfallUpdatePacket(long rainStartTick, long rainEndTick, float rainIntensity) {
        this.rainStartTick = rainStartTick;
        this.rainEndTick = rainEndTick;
        this.rainIntensity = rainIntensity;
    }

    RainfallUpdatePacket(FriendlyByteBuf buffer) {
        this.rainStartTick = buffer.readLong();
        this.rainEndTick = buffer.readLong();
        this.rainIntensity = buffer.readFloat();
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.writeLong(this.rainStartTick);
        buffer.writeLong(this.rainEndTick);
        buffer.writeFloat(this.rainIntensity);
    }

    void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            Level level = ClientHelpers.getLevel();
            if (level != null) {
                level.getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(cap -> cap.setWeatherData(this.rainStartTick, this.rainEndTick, this.rainIntensity));
            }
        });
    }
}

