/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.items.ProspectResult;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.events.ProspectedEvent;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ProspectedPacket {
    private final Block block;
    private final ProspectResult result;

    public ProspectedPacket(Block block, ProspectResult result) {
        this.block = block;
        this.result = result;
    }

    ProspectedPacket(FriendlyByteBuf buffer) {
        this.block = (Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS);
        this.result = ProspectResult.valueOf(buffer.readByte());
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (IForgeRegistryEntry)this.block);
        buffer.writeByte(this.result.ordinal());
    }

    void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            Player player = ClientHelpers.getPlayer();
            if (player != null) {
                MinecraftForge.EVENT_BUS.post((Event)new ProspectedEvent(player, this.result, this.block));
                player.m_5661_(this.result.getText(this.block), ((Boolean)TFCConfig.CLIENT.sendProspectResultsToActionbar.get()).booleanValue());
            }
        });
    }
}

