/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.capabilities.player.PlayerDataCapability;
import net.dries007.tfc.common.recipes.ChiselRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PlayerDataUpdatePacket {
    private final long lastDrinkTick;
    private final long intoxicationTick;
    private final ChiselRecipe.Mode mode;

    public PlayerDataUpdatePacket(long lastDrinkTick, long intoxicationTick, ChiselRecipe.Mode mode) {
        this.lastDrinkTick = lastDrinkTick;
        this.intoxicationTick = intoxicationTick;
        this.mode = mode;
    }

    PlayerDataUpdatePacket(FriendlyByteBuf buffer) {
        this.lastDrinkTick = buffer.m_130258_();
        this.intoxicationTick = buffer.m_130258_();
        this.mode = ChiselRecipe.Mode.valueOf(buffer.m_130242_());
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.m_130103_(this.lastDrinkTick);
        buffer.m_130103_(this.intoxicationTick);
        buffer.m_130130_(this.mode.ordinal());
    }

    void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            Player player = ClientHelpers.getPlayer();
            if (player != null) {
                player.getCapability(PlayerDataCapability.CAPABILITY).ifPresent(p -> p.updateFromPacket(this.lastDrinkTick, this.intoxicationTick, this.mode));
            }
        });
    }
}

