/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import net.dries007.tfc.common.entities.livestock.pet.TamableMammal;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class PetCommandPacket {
    private final int entityId;
    private final int command;

    public PetCommandPacket(Entity entityId, TamableMammal.Command command) {
        this.entityId = entityId.m_142049_();
        this.command = command.ordinal();
    }

    PetCommandPacket(FriendlyByteBuf buffer) {
        this.entityId = buffer.m_130242_();
        this.command = buffer.m_130242_();
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.entityId);
        buffer.m_130130_(this.command);
    }

    void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            Entity entity;
            ServerPlayer sender = context.getSender();
            if (sender != null && (entity = sender.f_19853_.m_6815_(this.entityId)) instanceof TamableMammal) {
                TamableMammal pet = (TamableMammal)entity;
                TamableMammal.Command value = TamableMammal.Command.valueOf(this.command);
                if (pet.willListenTo(value, false)) {
                    pet.receiveCommand(sender, value);
                } else {
                    sender.m_5661_((Component)Helpers.translatable("tfc.pet.will_not_listen"), true);
                }
            }
        });
    }
}

