/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.network.NetworkEvent;

public class FoodDataUpdatePacket {
    private final float[] nutrients;
    private final float thirst;

    public FoodDataUpdatePacket(float[] nutrients, float thirst) {
        this.nutrients = nutrients;
        this.thirst = thirst;
    }

    FoodDataUpdatePacket(FriendlyByteBuf buffer) {
        this.nutrients = new float[Nutrient.TOTAL];
        for (int i = 0; i < this.nutrients.length; ++i) {
            this.nutrients[i] = buffer.readFloat();
        }
        this.thirst = buffer.readFloat();
    }

    void encode(FriendlyByteBuf buffer) {
        for (float nutrient : this.nutrients) {
            buffer.writeFloat(nutrient);
        }
        buffer.writeFloat(this.thirst);
    }

    void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            FoodData patt1423$temp;
            Player player = ClientHelpers.getPlayer();
            if (player != null && (patt1423$temp = player.m_36324_()) instanceof TFCFoodData) {
                TFCFoodData data = (TFCFoodData)patt1423$temp;
                data.onClientUpdate(this.nutrients, this.thirst);
            }
        });
    }
}

